<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.TicketPackageElement StructType
 * @subpackage Structs
 */
class Sales_TicketPackageElement extends Sales_PromoCodeProductPackageElement
{
    /**
     * The LagPolicy
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LagPolicy;
    /**
     * The MaxMinutesFromCurrentEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxMinutesFromCurrentEvent;
    /**
     * The MinMinutesFromCurrentEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinMinutesFromCurrentEvent;
    /**
     * The RecommendedMinutesFromCurrentEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecommendedMinutesFromCurrentEvent;
    /**
     * Constructor method for Sales.TicketPackageElement
     * @uses Sales_TicketPackageElement::setLagPolicy()
     * @uses Sales_TicketPackageElement::setMaxMinutesFromCurrentEvent()
     * @uses Sales_TicketPackageElement::setMinMinutesFromCurrentEvent()
     * @uses Sales_TicketPackageElement::setRecommendedMinutesFromCurrentEvent()
     * @param string $lagPolicy
     * @param int $maxMinutesFromCurrentEvent
     * @param int $minMinutesFromCurrentEvent
     * @param int $recommendedMinutesFromCurrentEvent
     */
    public function __construct($lagPolicy = null, $maxMinutesFromCurrentEvent = null, $minMinutesFromCurrentEvent = null, $recommendedMinutesFromCurrentEvent = null)
    {
        $this
            ->setLagPolicy($lagPolicy)
            ->setMaxMinutesFromCurrentEvent($maxMinutesFromCurrentEvent)
            ->setMinMinutesFromCurrentEvent($minMinutesFromCurrentEvent)
            ->setRecommendedMinutesFromCurrentEvent($recommendedMinutesFromCurrentEvent);
    }
    /**
     * Get LagPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLagPolicy()
    {
        return isset($this->LagPolicy) ? $this->LagPolicy : null;
    }
    /**
     * Set LagPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BundleTicketElementLagPolicy::valueIsValid()
     * @uses \patest\EnumType\BundleTicketElementLagPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lagPolicy
     * @return \patest\StructType\Sales_TicketPackageElement
     */
    public function setLagPolicy($lagPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BundleTicketElementLagPolicy::valueIsValid($lagPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BundleTicketElementLagPolicy', is_array($lagPolicy) ? implode(', ', $lagPolicy) : var_export($lagPolicy, true), implode(', ', \patest\EnumType\BundleTicketElementLagPolicy::getValidValues())), __LINE__);
        }
        if (is_null($lagPolicy) || (is_array($lagPolicy) && empty($lagPolicy))) {
            unset($this->LagPolicy);
        } else {
            $this->LagPolicy = $lagPolicy;
        }
        return $this;
    }
    /**
     * Get MaxMinutesFromCurrentEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxMinutesFromCurrentEvent()
    {
        return isset($this->MaxMinutesFromCurrentEvent) ? $this->MaxMinutesFromCurrentEvent : null;
    }
    /**
     * Set MaxMinutesFromCurrentEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxMinutesFromCurrentEvent
     * @return \patest\StructType\Sales_TicketPackageElement
     */
    public function setMaxMinutesFromCurrentEvent($maxMinutesFromCurrentEvent = null)
    {
        // validation for constraint: int
        if (!is_null($maxMinutesFromCurrentEvent) && !(is_int($maxMinutesFromCurrentEvent) || ctype_digit($maxMinutesFromCurrentEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxMinutesFromCurrentEvent, true), gettype($maxMinutesFromCurrentEvent)), __LINE__);
        }
        if (is_null($maxMinutesFromCurrentEvent) || (is_array($maxMinutesFromCurrentEvent) && empty($maxMinutesFromCurrentEvent))) {
            unset($this->MaxMinutesFromCurrentEvent);
        } else {
            $this->MaxMinutesFromCurrentEvent = $maxMinutesFromCurrentEvent;
        }
        return $this;
    }
    /**
     * Get MinMinutesFromCurrentEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinMinutesFromCurrentEvent()
    {
        return isset($this->MinMinutesFromCurrentEvent) ? $this->MinMinutesFromCurrentEvent : null;
    }
    /**
     * Set MinMinutesFromCurrentEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minMinutesFromCurrentEvent
     * @return \patest\StructType\Sales_TicketPackageElement
     */
    public function setMinMinutesFromCurrentEvent($minMinutesFromCurrentEvent = null)
    {
        // validation for constraint: int
        if (!is_null($minMinutesFromCurrentEvent) && !(is_int($minMinutesFromCurrentEvent) || ctype_digit($minMinutesFromCurrentEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minMinutesFromCurrentEvent, true), gettype($minMinutesFromCurrentEvent)), __LINE__);
        }
        if (is_null($minMinutesFromCurrentEvent) || (is_array($minMinutesFromCurrentEvent) && empty($minMinutesFromCurrentEvent))) {
            unset($this->MinMinutesFromCurrentEvent);
        } else {
            $this->MinMinutesFromCurrentEvent = $minMinutesFromCurrentEvent;
        }
        return $this;
    }
    /**
     * Get RecommendedMinutesFromCurrentEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecommendedMinutesFromCurrentEvent()
    {
        return isset($this->RecommendedMinutesFromCurrentEvent) ? $this->RecommendedMinutesFromCurrentEvent : null;
    }
    /**
     * Set RecommendedMinutesFromCurrentEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recommendedMinutesFromCurrentEvent
     * @return \patest\StructType\Sales_TicketPackageElement
     */
    public function setRecommendedMinutesFromCurrentEvent($recommendedMinutesFromCurrentEvent = null)
    {
        // validation for constraint: int
        if (!is_null($recommendedMinutesFromCurrentEvent) && !(is_int($recommendedMinutesFromCurrentEvent) || ctype_digit($recommendedMinutesFromCurrentEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recommendedMinutesFromCurrentEvent, true), gettype($recommendedMinutesFromCurrentEvent)), __LINE__);
        }
        if (is_null($recommendedMinutesFromCurrentEvent) || (is_array($recommendedMinutesFromCurrentEvent) && empty($recommendedMinutesFromCurrentEvent))) {
            unset($this->RecommendedMinutesFromCurrentEvent);
        } else {
            $this->RecommendedMinutesFromCurrentEvent = $recommendedMinutesFromCurrentEvent;
        }
        return $this;
    }
}
