<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SroAppAbout StructType
 * @subpackage Structs
 */
class Sales_SroAppAbout extends AnyEntity
{
    /**
     * The ApplicationChannelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannelName;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The CultureName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CultureName;
    /**
     * The DebugMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DebugMode;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HolderTenantId;
    /**
     * The OrganizationUnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganizationUnitName;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointName;
    /**
     * The SecurityTokenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityTokenName;
    /**
     * The SiteCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencyCode;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteName;
    /**
     * The SroContextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SroContextId;
    /**
     * The TillGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TillGroupName;
    /**
     * The TillLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TillLocalId;
    /**
     * The TillName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TillName;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The UserProfileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserProfileName;
    /**
     * The UserRoleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserRoleName;
    /**
     * The WebLinkUri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebLinkUri;
    /**
     * Constructor method for Sales.SroAppAbout
     * @uses Sales_SroAppAbout::setApplicationChannelName()
     * @uses Sales_SroAppAbout::setCompanyName()
     * @uses Sales_SroAppAbout::setCultureName()
     * @uses Sales_SroAppAbout::setDebugMode()
     * @uses Sales_SroAppAbout::setHolderTenantId()
     * @uses Sales_SroAppAbout::setOrganizationUnitName()
     * @uses Sales_SroAppAbout::setSalePointId()
     * @uses Sales_SroAppAbout::setSalePointName()
     * @uses Sales_SroAppAbout::setSecurityTokenName()
     * @uses Sales_SroAppAbout::setSiteCurrencyCode()
     * @uses Sales_SroAppAbout::setSiteName()
     * @uses Sales_SroAppAbout::setSroContextId()
     * @uses Sales_SroAppAbout::setTillGroupName()
     * @uses Sales_SroAppAbout::setTillLocalId()
     * @uses Sales_SroAppAbout::setTillName()
     * @uses Sales_SroAppAbout::setUserId()
     * @uses Sales_SroAppAbout::setUserName()
     * @uses Sales_SroAppAbout::setUserProfileName()
     * @uses Sales_SroAppAbout::setUserRoleName()
     * @uses Sales_SroAppAbout::setWebLinkUri()
     * @param string $applicationChannelName
     * @param string $companyName
     * @param string $cultureName
     * @param bool $debugMode
     * @param string $holderTenantId
     * @param string $organizationUnitName
     * @param string $salePointId
     * @param string $salePointName
     * @param string $securityTokenName
     * @param string $siteCurrencyCode
     * @param string $siteName
     * @param string $sroContextId
     * @param string $tillGroupName
     * @param string $tillLocalId
     * @param string $tillName
     * @param string $userId
     * @param string $userName
     * @param string $userProfileName
     * @param string $userRoleName
     * @param string $webLinkUri
     */
    public function __construct($applicationChannelName = null, $companyName = null, $cultureName = null, $debugMode = null, $holderTenantId = null, $organizationUnitName = null, $salePointId = null, $salePointName = null, $securityTokenName = null, $siteCurrencyCode = null, $siteName = null, $sroContextId = null, $tillGroupName = null, $tillLocalId = null, $tillName = null, $userId = null, $userName = null, $userProfileName = null, $userRoleName = null, $webLinkUri = null)
    {
        $this
            ->setApplicationChannelName($applicationChannelName)
            ->setCompanyName($companyName)
            ->setCultureName($cultureName)
            ->setDebugMode($debugMode)
            ->setHolderTenantId($holderTenantId)
            ->setOrganizationUnitName($organizationUnitName)
            ->setSalePointId($salePointId)
            ->setSalePointName($salePointName)
            ->setSecurityTokenName($securityTokenName)
            ->setSiteCurrencyCode($siteCurrencyCode)
            ->setSiteName($siteName)
            ->setSroContextId($sroContextId)
            ->setTillGroupName($tillGroupName)
            ->setTillLocalId($tillLocalId)
            ->setTillName($tillName)
            ->setUserId($userId)
            ->setUserName($userName)
            ->setUserProfileName($userProfileName)
            ->setUserRoleName($userRoleName)
            ->setWebLinkUri($webLinkUri);
    }
    /**
     * Get ApplicationChannelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannelName()
    {
        return isset($this->ApplicationChannelName) ? $this->ApplicationChannelName : null;
    }
    /**
     * Set ApplicationChannelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannelName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setApplicationChannelName($applicationChannelName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannelName) && !is_string($applicationChannelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannelName, true), gettype($applicationChannelName)), __LINE__);
        }
        if (is_null($applicationChannelName) || (is_array($applicationChannelName) && empty($applicationChannelName))) {
            unset($this->ApplicationChannelName);
        } else {
            $this->ApplicationChannelName = $applicationChannelName;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get CultureName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCultureName()
    {
        return isset($this->CultureName) ? $this->CultureName : null;
    }
    /**
     * Set CultureName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cultureName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setCultureName($cultureName = null)
    {
        // validation for constraint: string
        if (!is_null($cultureName) && !is_string($cultureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureName, true), gettype($cultureName)), __LINE__);
        }
        if (is_null($cultureName) || (is_array($cultureName) && empty($cultureName))) {
            unset($this->CultureName);
        } else {
            $this->CultureName = $cultureName;
        }
        return $this;
    }
    /**
     * Get DebugMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDebugMode()
    {
        return isset($this->DebugMode) ? $this->DebugMode : null;
    }
    /**
     * Set DebugMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $debugMode
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setDebugMode($debugMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($debugMode) && !is_bool($debugMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($debugMode, true), gettype($debugMode)), __LINE__);
        }
        if (is_null($debugMode) || (is_array($debugMode) && empty($debugMode))) {
            unset($this->DebugMode);
        } else {
            $this->DebugMode = $debugMode;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $holderTenantId
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: string
        if (!is_null($holderTenantId) && !is_string($holderTenantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitName()
    {
        return isset($this->OrganizationUnitName) ? $this->OrganizationUnitName : null;
    }
    /**
     * Set OrganizationUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setOrganizationUnitName($organizationUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitName) && !is_string($organizationUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitName, true), gettype($organizationUnitName)), __LINE__);
        }
        if (is_null($organizationUnitName) || (is_array($organizationUnitName) && empty($organizationUnitName))) {
            unset($this->OrganizationUnitName);
        } else {
            $this->OrganizationUnitName = $organizationUnitName;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setSalePointName($salePointName = null)
    {
        // validation for constraint: string
        if (!is_null($salePointName) && !is_string($salePointName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointName, true), gettype($salePointName)), __LINE__);
        }
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SecurityTokenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenName()
    {
        return isset($this->SecurityTokenName) ? $this->SecurityTokenName : null;
    }
    /**
     * Set SecurityTokenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setSecurityTokenName($securityTokenName = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenName) && !is_string($securityTokenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenName, true), gettype($securityTokenName)), __LINE__);
        }
        if (is_null($securityTokenName) || (is_array($securityTokenName) && empty($securityTokenName))) {
            unset($this->SecurityTokenName);
        } else {
            $this->SecurityTokenName = $securityTokenName;
        }
        return $this;
    }
    /**
     * Get SiteCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencyCode()
    {
        return isset($this->SiteCurrencyCode) ? $this->SiteCurrencyCode : null;
    }
    /**
     * Set SiteCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencyCode
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setSiteCurrencyCode($siteCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencyCode) && !is_string($siteCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencyCode, true), gettype($siteCurrencyCode)), __LINE__);
        }
        if (is_null($siteCurrencyCode) || (is_array($siteCurrencyCode) && empty($siteCurrencyCode))) {
            unset($this->SiteCurrencyCode);
        } else {
            $this->SiteCurrencyCode = $siteCurrencyCode;
        }
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteName, true), gettype($siteName)), __LINE__);
        }
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get SroContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSroContextId()
    {
        return isset($this->SroContextId) ? $this->SroContextId : null;
    }
    /**
     * Set SroContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sroContextId
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setSroContextId($sroContextId = null)
    {
        // validation for constraint: string
        if (!is_null($sroContextId) && !is_string($sroContextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sroContextId, true), gettype($sroContextId)), __LINE__);
        }
        if (is_null($sroContextId) || (is_array($sroContextId) && empty($sroContextId))) {
            unset($this->SroContextId);
        } else {
            $this->SroContextId = $sroContextId;
        }
        return $this;
    }
    /**
     * Get TillGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillGroupName()
    {
        return isset($this->TillGroupName) ? $this->TillGroupName : null;
    }
    /**
     * Set TillGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillGroupName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setTillGroupName($tillGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($tillGroupName) && !is_string($tillGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillGroupName, true), gettype($tillGroupName)), __LINE__);
        }
        if (is_null($tillGroupName) || (is_array($tillGroupName) && empty($tillGroupName))) {
            unset($this->TillGroupName);
        } else {
            $this->TillGroupName = $tillGroupName;
        }
        return $this;
    }
    /**
     * Get TillLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillLocalId()
    {
        return isset($this->TillLocalId) ? $this->TillLocalId : null;
    }
    /**
     * Set TillLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillLocalId
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setTillLocalId($tillLocalId = null)
    {
        // validation for constraint: string
        if (!is_null($tillLocalId) && !is_string($tillLocalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillLocalId, true), gettype($tillLocalId)), __LINE__);
        }
        if (is_null($tillLocalId) || (is_array($tillLocalId) && empty($tillLocalId))) {
            unset($this->TillLocalId);
        } else {
            $this->TillLocalId = $tillLocalId;
        }
        return $this;
    }
    /**
     * Get TillName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillName()
    {
        return isset($this->TillName) ? $this->TillName : null;
    }
    /**
     * Set TillName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setTillName($tillName = null)
    {
        // validation for constraint: string
        if (!is_null($tillName) && !is_string($tillName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillName, true), gettype($tillName)), __LINE__);
        }
        if (is_null($tillName) || (is_array($tillName) && empty($tillName))) {
            unset($this->TillName);
        } else {
            $this->TillName = $tillName;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get UserProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserProfileName()
    {
        return isset($this->UserProfileName) ? $this->UserProfileName : null;
    }
    /**
     * Set UserProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userProfileName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setUserProfileName($userProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($userProfileName) && !is_string($userProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userProfileName, true), gettype($userProfileName)), __LINE__);
        }
        if (is_null($userProfileName) || (is_array($userProfileName) && empty($userProfileName))) {
            unset($this->UserProfileName);
        } else {
            $this->UserProfileName = $userProfileName;
        }
        return $this;
    }
    /**
     * Get UserRoleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserRoleName()
    {
        return isset($this->UserRoleName) ? $this->UserRoleName : null;
    }
    /**
     * Set UserRoleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userRoleName
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setUserRoleName($userRoleName = null)
    {
        // validation for constraint: string
        if (!is_null($userRoleName) && !is_string($userRoleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRoleName, true), gettype($userRoleName)), __LINE__);
        }
        if (is_null($userRoleName) || (is_array($userRoleName) && empty($userRoleName))) {
            unset($this->UserRoleName);
        } else {
            $this->UserRoleName = $userRoleName;
        }
        return $this;
    }
    /**
     * Get WebLinkUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebLinkUri()
    {
        return isset($this->WebLinkUri) ? $this->WebLinkUri : null;
    }
    /**
     * Set WebLinkUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webLinkUri
     * @return \patest\StructType\Sales_SroAppAbout
     */
    public function setWebLinkUri($webLinkUri = null)
    {
        // validation for constraint: string
        if (!is_null($webLinkUri) && !is_string($webLinkUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webLinkUri, true), gettype($webLinkUri)), __LINE__);
        }
        if (is_null($webLinkUri) || (is_array($webLinkUri) && empty($webLinkUri))) {
            unset($this->WebLinkUri);
        } else {
            $this->WebLinkUri = $webLinkUri;
        }
        return $this;
    }
}
