<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SeriesPackageElement StructType
 * @subpackage Structs
 */
class Sales_SeriesPackageElement extends Sales_ProductPackageElement
{
    /**
     * The MaxSubscriptionsPerSeries
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSubscriptionsPerSeries;
    /**
     * The MinSubscriptionsPerSeries
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSubscriptionsPerSeries;
    /**
     * The SameQuantityPerSeries
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SameQuantityPerSeries;
    /**
     * Constructor method for Sales.SeriesPackageElement
     * @uses Sales_SeriesPackageElement::setMaxSubscriptionsPerSeries()
     * @uses Sales_SeriesPackageElement::setMinSubscriptionsPerSeries()
     * @uses Sales_SeriesPackageElement::setSameQuantityPerSeries()
     * @param int $maxSubscriptionsPerSeries
     * @param int $minSubscriptionsPerSeries
     * @param bool $sameQuantityPerSeries
     */
    public function __construct($maxSubscriptionsPerSeries = null, $minSubscriptionsPerSeries = null, $sameQuantityPerSeries = null)
    {
        $this
            ->setMaxSubscriptionsPerSeries($maxSubscriptionsPerSeries)
            ->setMinSubscriptionsPerSeries($minSubscriptionsPerSeries)
            ->setSameQuantityPerSeries($sameQuantityPerSeries);
    }
    /**
     * Get MaxSubscriptionsPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSubscriptionsPerSeries()
    {
        return isset($this->MaxSubscriptionsPerSeries) ? $this->MaxSubscriptionsPerSeries : null;
    }
    /**
     * Set MaxSubscriptionsPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSubscriptionsPerSeries
     * @return \patest\StructType\Sales_SeriesPackageElement
     */
    public function setMaxSubscriptionsPerSeries($maxSubscriptionsPerSeries = null)
    {
        // validation for constraint: int
        if (!is_null($maxSubscriptionsPerSeries) && !(is_int($maxSubscriptionsPerSeries) || ctype_digit($maxSubscriptionsPerSeries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSubscriptionsPerSeries, true), gettype($maxSubscriptionsPerSeries)), __LINE__);
        }
        if (is_null($maxSubscriptionsPerSeries) || (is_array($maxSubscriptionsPerSeries) && empty($maxSubscriptionsPerSeries))) {
            unset($this->MaxSubscriptionsPerSeries);
        } else {
            $this->MaxSubscriptionsPerSeries = $maxSubscriptionsPerSeries;
        }
        return $this;
    }
    /**
     * Get MinSubscriptionsPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSubscriptionsPerSeries()
    {
        return isset($this->MinSubscriptionsPerSeries) ? $this->MinSubscriptionsPerSeries : null;
    }
    /**
     * Set MinSubscriptionsPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSubscriptionsPerSeries
     * @return \patest\StructType\Sales_SeriesPackageElement
     */
    public function setMinSubscriptionsPerSeries($minSubscriptionsPerSeries = null)
    {
        // validation for constraint: int
        if (!is_null($minSubscriptionsPerSeries) && !(is_int($minSubscriptionsPerSeries) || ctype_digit($minSubscriptionsPerSeries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSubscriptionsPerSeries, true), gettype($minSubscriptionsPerSeries)), __LINE__);
        }
        if (is_null($minSubscriptionsPerSeries) || (is_array($minSubscriptionsPerSeries) && empty($minSubscriptionsPerSeries))) {
            unset($this->MinSubscriptionsPerSeries);
        } else {
            $this->MinSubscriptionsPerSeries = $minSubscriptionsPerSeries;
        }
        return $this;
    }
    /**
     * Get SameQuantityPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSameQuantityPerSeries()
    {
        return isset($this->SameQuantityPerSeries) ? $this->SameQuantityPerSeries : null;
    }
    /**
     * Set SameQuantityPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sameQuantityPerSeries
     * @return \patest\StructType\Sales_SeriesPackageElement
     */
    public function setSameQuantityPerSeries($sameQuantityPerSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameQuantityPerSeries) && !is_bool($sameQuantityPerSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sameQuantityPerSeries, true), gettype($sameQuantityPerSeries)), __LINE__);
        }
        if (is_null($sameQuantityPerSeries) || (is_array($sameQuantityPerSeries) && empty($sameQuantityPerSeries))) {
            unset($this->SameQuantityPerSeries);
        } else {
            $this->SameQuantityPerSeries = $sameQuantityPerSeries;
        }
        return $this;
    }
}
