<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ReservationTransaction StructType
 * @subpackage Structs
 */
class Sales_ReservationTransaction extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The FirstDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FirstDefinitionId;
    /**
     * The FirstItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FirstItemType;
    /**
     * The HasVariousItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasVariousItems;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The ItemQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemQty;
    /**
     * The TotalAmountDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmountDue;
    /**
     * The TransactionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionAuditId;
    /**
     * The TransactionDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateTime;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Sales.ReservationTransaction
     * @uses Sales_ReservationTransaction::setClientId()
     * @uses Sales_ReservationTransaction::setDetails()
     * @uses Sales_ReservationTransaction::setFirstDefinitionId()
     * @uses Sales_ReservationTransaction::setFirstItemType()
     * @uses Sales_ReservationTransaction::setHasVariousItems()
     * @uses Sales_ReservationTransaction::setHolderCompanyId()
     * @uses Sales_ReservationTransaction::setItemQty()
     * @uses Sales_ReservationTransaction::setTotalAmountDue()
     * @uses Sales_ReservationTransaction::setTransactionAuditId()
     * @uses Sales_ReservationTransaction::setTransactionDateTime()
     * @uses Sales_ReservationTransaction::setTransactionGuid()
     * @uses Sales_ReservationTransaction::setTransactionNumber()
     * @param string $clientId
     * @param string $details
     * @param string $firstDefinitionId
     * @param int $firstItemType
     * @param bool $hasVariousItems
     * @param int $holderCompanyId
     * @param int $itemQty
     * @param \patest\StructType\Money $totalAmountDue
     * @param int $transactionAuditId
     * @param string $transactionDateTime
     * @param string $transactionGuid
     * @param int $transactionNumber
     */
    public function __construct($clientId = null, $details = null, $firstDefinitionId = null, $firstItemType = null, $hasVariousItems = null, $holderCompanyId = null, $itemQty = null, \patest\StructType\Money $totalAmountDue = null, $transactionAuditId = null, $transactionDateTime = null, $transactionGuid = null, $transactionNumber = null)
    {
        $this
            ->setClientId($clientId)
            ->setDetails($details)
            ->setFirstDefinitionId($firstDefinitionId)
            ->setFirstItemType($firstItemType)
            ->setHasVariousItems($hasVariousItems)
            ->setHolderCompanyId($holderCompanyId)
            ->setItemQty($itemQty)
            ->setTotalAmountDue($totalAmountDue)
            ->setTransactionAuditId($transactionAuditId)
            ->setTransactionDateTime($transactionDateTime)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get FirstDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstDefinitionId()
    {
        return isset($this->FirstDefinitionId) ? $this->FirstDefinitionId : null;
    }
    /**
     * Set FirstDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstDefinitionId
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setFirstDefinitionId($firstDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($firstDefinitionId) && !is_string($firstDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstDefinitionId, true), gettype($firstDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($firstDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $firstDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($firstDefinitionId, true)), __LINE__);
        }
        if (is_null($firstDefinitionId) || (is_array($firstDefinitionId) && empty($firstDefinitionId))) {
            unset($this->FirstDefinitionId);
        } else {
            $this->FirstDefinitionId = $firstDefinitionId;
        }
        return $this;
    }
    /**
     * Get FirstItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFirstItemType()
    {
        return isset($this->FirstItemType) ? $this->FirstItemType : null;
    }
    /**
     * Set FirstItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $firstItemType
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setFirstItemType($firstItemType = null)
    {
        // validation for constraint: int
        if (!is_null($firstItemType) && !(is_int($firstItemType) || ctype_digit($firstItemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstItemType, true), gettype($firstItemType)), __LINE__);
        }
        if (is_null($firstItemType) || (is_array($firstItemType) && empty($firstItemType))) {
            unset($this->FirstItemType);
        } else {
            $this->FirstItemType = $firstItemType;
        }
        return $this;
    }
    /**
     * Get HasVariousItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasVariousItems()
    {
        return isset($this->HasVariousItems) ? $this->HasVariousItems : null;
    }
    /**
     * Set HasVariousItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasVariousItems
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setHasVariousItems($hasVariousItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasVariousItems) && !is_bool($hasVariousItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasVariousItems, true), gettype($hasVariousItems)), __LINE__);
        }
        if (is_null($hasVariousItems) || (is_array($hasVariousItems) && empty($hasVariousItems))) {
            unset($this->HasVariousItems);
        } else {
            $this->HasVariousItems = $hasVariousItems;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get ItemQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemQty()
    {
        return isset($this->ItemQty) ? $this->ItemQty : null;
    }
    /**
     * Set ItemQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemQty
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setItemQty($itemQty = null)
    {
        // validation for constraint: int
        if (!is_null($itemQty) && !(is_int($itemQty) || ctype_digit($itemQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemQty, true), gettype($itemQty)), __LINE__);
        }
        if (is_null($itemQty) || (is_array($itemQty) && empty($itemQty))) {
            unset($this->ItemQty);
        } else {
            $this->ItemQty = $itemQty;
        }
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmountDue()
    {
        return isset($this->TotalAmountDue) ? $this->TotalAmountDue : null;
    }
    /**
     * Set TotalAmountDue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmountDue
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setTotalAmountDue(\patest\StructType\Money $totalAmountDue = null)
    {
        if (is_null($totalAmountDue) || (is_array($totalAmountDue) && empty($totalAmountDue))) {
            unset($this->TotalAmountDue);
        } else {
            $this->TotalAmountDue = $totalAmountDue;
        }
        return $this;
    }
    /**
     * Get TransactionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionAuditId()
    {
        return isset($this->TransactionAuditId) ? $this->TransactionAuditId : null;
    }
    /**
     * Set TransactionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionAuditId
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setTransactionAuditId($transactionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionAuditId) && !(is_int($transactionAuditId) || ctype_digit($transactionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionAuditId, true), gettype($transactionAuditId)), __LINE__);
        }
        if (is_null($transactionAuditId) || (is_array($transactionAuditId) && empty($transactionAuditId))) {
            unset($this->TransactionAuditId);
        } else {
            $this->TransactionAuditId = $transactionAuditId;
        }
        return $this;
    }
    /**
     * Get TransactionDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateTime()
    {
        return isset($this->TransactionDateTime) ? $this->TransactionDateTime : null;
    }
    /**
     * Set TransactionDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateTime
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setTransactionDateTime($transactionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTime) && !is_string($transactionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateTime, true), gettype($transactionDateTime)), __LINE__);
        }
        if (is_null($transactionDateTime) || (is_array($transactionDateTime) && empty($transactionDateTime))) {
            unset($this->TransactionDateTime);
        } else {
            $this->TransactionDateTime = $transactionDateTime;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_ReservationTransaction
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
