<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ProductPackageElement StructType
 * @subpackage Structs
 */
class Sales_ProductPackageElement extends Sales_PackageElement
{
    /**
     * The ActionApplyItemPickPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionApplyItemPickPolicy;
    /**
     * The ActionApplyPolicy
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ProductActionApplyPolicy
     * @var string
     */
    public $ActionApplyPolicy;
    /**
     * The ActionApplyQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ActionApplyQuantity;
    /**
     * The ItemPickPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemPickPolicy;
    /**
     * Constructor method for Sales.ProductPackageElement
     * @uses Sales_ProductPackageElement::setActionApplyItemPickPolicy()
     * @uses Sales_ProductPackageElement::setActionApplyPolicy()
     * @uses Sales_ProductPackageElement::setActionApplyQuantity()
     * @uses Sales_ProductPackageElement::setItemPickPolicy()
     * @param string $actionApplyItemPickPolicy
     * @param string $actionApplyPolicy
     * @param int $actionApplyQuantity
     * @param string $itemPickPolicy
     */
    public function __construct($actionApplyItemPickPolicy = null, $actionApplyPolicy = null, $actionApplyQuantity = null, $itemPickPolicy = null)
    {
        $this
            ->setActionApplyItemPickPolicy($actionApplyItemPickPolicy)
            ->setActionApplyPolicy($actionApplyPolicy)
            ->setActionApplyQuantity($actionApplyQuantity)
            ->setItemPickPolicy($itemPickPolicy);
    }
    /**
     * Get ActionApplyItemPickPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionApplyItemPickPolicy()
    {
        return isset($this->ActionApplyItemPickPolicy) ? $this->ActionApplyItemPickPolicy : null;
    }
    /**
     * Set ActionApplyItemPickPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ActionApplyItemPickPolicy::valueIsValid()
     * @uses \patest\EnumType\ActionApplyItemPickPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionApplyItemPickPolicy
     * @return \patest\StructType\Sales_ProductPackageElement
     */
    public function setActionApplyItemPickPolicy($actionApplyItemPickPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ActionApplyItemPickPolicy::valueIsValid($actionApplyItemPickPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ActionApplyItemPickPolicy', is_array($actionApplyItemPickPolicy) ? implode(', ', $actionApplyItemPickPolicy) : var_export($actionApplyItemPickPolicy, true), implode(', ', \patest\EnumType\ActionApplyItemPickPolicy::getValidValues())), __LINE__);
        }
        if (is_null($actionApplyItemPickPolicy) || (is_array($actionApplyItemPickPolicy) && empty($actionApplyItemPickPolicy))) {
            unset($this->ActionApplyItemPickPolicy);
        } else {
            $this->ActionApplyItemPickPolicy = $actionApplyItemPickPolicy;
        }
        return $this;
    }
    /**
     * Get ActionApplyPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionApplyPolicy()
    {
        return isset($this->ActionApplyPolicy) ? $this->ActionApplyPolicy : null;
    }
    /**
     * Set ActionApplyPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionApplyPolicy
     * @return \patest\StructType\Sales_ProductPackageElement
     */
    public function setActionApplyPolicy($actionApplyPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($actionApplyPolicy) && !is_string($actionApplyPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionApplyPolicy, true), gettype($actionApplyPolicy)), __LINE__);
        }
        if (is_null($actionApplyPolicy) || (is_array($actionApplyPolicy) && empty($actionApplyPolicy))) {
            unset($this->ActionApplyPolicy);
        } else {
            $this->ActionApplyPolicy = $actionApplyPolicy;
        }
        return $this;
    }
    /**
     * Get ActionApplyQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getActionApplyQuantity()
    {
        return isset($this->ActionApplyQuantity) ? $this->ActionApplyQuantity : null;
    }
    /**
     * Set ActionApplyQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $actionApplyQuantity
     * @return \patest\StructType\Sales_ProductPackageElement
     */
    public function setActionApplyQuantity($actionApplyQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($actionApplyQuantity) && !(is_int($actionApplyQuantity) || ctype_digit($actionApplyQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actionApplyQuantity, true), gettype($actionApplyQuantity)), __LINE__);
        }
        if (is_null($actionApplyQuantity) || (is_array($actionApplyQuantity) && empty($actionApplyQuantity))) {
            unset($this->ActionApplyQuantity);
        } else {
            $this->ActionApplyQuantity = $actionApplyQuantity;
        }
        return $this;
    }
    /**
     * Get ItemPickPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemPickPolicy()
    {
        return isset($this->ItemPickPolicy) ? $this->ItemPickPolicy : null;
    }
    /**
     * Set ItemPickPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemPickPolicy::valueIsValid()
     * @uses \patest\EnumType\ItemPickPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemPickPolicy
     * @return \patest\StructType\Sales_ProductPackageElement
     */
    public function setItemPickPolicy($itemPickPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemPickPolicy::valueIsValid($itemPickPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemPickPolicy', is_array($itemPickPolicy) ? implode(', ', $itemPickPolicy) : var_export($itemPickPolicy, true), implode(', ', \patest\EnumType\ItemPickPolicy::getValidValues())), __LINE__);
        }
        if (is_null($itemPickPolicy) || (is_array($itemPickPolicy) && empty($itemPickPolicy))) {
            unset($this->ItemPickPolicy);
        } else {
            $this->ItemPickPolicy = $itemPickPolicy;
        }
        return $this;
    }
}
