<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PriceList StructType
 * @subpackage Structs
 */
class Sales_PriceList extends DistributableEntity
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The BasePrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_PriceListBasePrice
     */
    public $BasePrices;
    /**
     * The BasePriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BasePriceTypeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EffectivePriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectivePriceLevelIds
     */
    public $EffectivePriceLevelIds;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsBasePriceEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBasePriceEnabled;
    /**
     * The ItemTypeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemTypeNumber;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_PriceListPriceType
     */
    public $PriceTypes;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Sales.PriceList
     * @uses Sales_PriceList::setAclSchemeId()
     * @uses Sales_PriceList::setBasePrices()
     * @uses Sales_PriceList::setBasePriceTypeId()
     * @uses Sales_PriceList::setDescription()
     * @uses Sales_PriceList::setEffectivePriceLevelIds()
     * @uses Sales_PriceList::setIsActive()
     * @uses Sales_PriceList::setIsBasePriceEnabled()
     * @uses Sales_PriceList::setItemTypeNumber()
     * @uses Sales_PriceList::setOrganizationUnitId()
     * @uses Sales_PriceList::setPriceTypes()
     * @uses Sales_PriceList::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param \patest\StructType\RecordSetOfSales_PriceListBasePrice $basePrices
     * @param string $basePriceTypeId
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\EffectivePriceLevelIds $effectivePriceLevelIds
     * @param bool $isActive
     * @param bool $isBasePriceEnabled
     * @param int $itemTypeNumber
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfSales_PriceListPriceType $priceTypes
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, \patest\StructType\RecordSetOfSales_PriceListBasePrice $basePrices = null, $basePriceTypeId = null, \patest\StructType\GlobalString $description = null, \patest\StructType\EffectivePriceLevelIds $effectivePriceLevelIds = null, $isActive = null, $isBasePriceEnabled = null, $itemTypeNumber = null, $organizationUnitId = null, \patest\StructType\RecordSetOfSales_PriceListPriceType $priceTypes = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setBasePrices($basePrices)
            ->setBasePriceTypeId($basePriceTypeId)
            ->setDescription($description)
            ->setEffectivePriceLevelIds($effectivePriceLevelIds)
            ->setIsActive($isActive)
            ->setIsBasePriceEnabled($isBasePriceEnabled)
            ->setItemTypeNumber($itemTypeNumber)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPriceTypes($priceTypes)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Sales_PriceList
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get BasePrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_PriceListBasePrice|null
     */
    public function getBasePrices()
    {
        return isset($this->BasePrices) ? $this->BasePrices : null;
    }
    /**
     * Set BasePrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_PriceListBasePrice $basePrices
     * @return \patest\StructType\Sales_PriceList
     */
    public function setBasePrices(\patest\StructType\RecordSetOfSales_PriceListBasePrice $basePrices = null)
    {
        if (is_null($basePrices) || (is_array($basePrices) && empty($basePrices))) {
            unset($this->BasePrices);
        } else {
            $this->BasePrices = $basePrices;
        }
        return $this;
    }
    /**
     * Get BasePriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasePriceTypeId()
    {
        return isset($this->BasePriceTypeId) ? $this->BasePriceTypeId : null;
    }
    /**
     * Set BasePriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $basePriceTypeId
     * @return \patest\StructType\Sales_PriceList
     */
    public function setBasePriceTypeId($basePriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($basePriceTypeId) && !is_string($basePriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basePriceTypeId, true), gettype($basePriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($basePriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $basePriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($basePriceTypeId, true)), __LINE__);
        }
        if (is_null($basePriceTypeId) || (is_array($basePriceTypeId) && empty($basePriceTypeId))) {
            unset($this->BasePriceTypeId);
        } else {
            $this->BasePriceTypeId = $basePriceTypeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_PriceList
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectivePriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectivePriceLevelIds|null
     */
    public function getEffectivePriceLevelIds()
    {
        return isset($this->EffectivePriceLevelIds) ? $this->EffectivePriceLevelIds : null;
    }
    /**
     * Set EffectivePriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectivePriceLevelIds $effectivePriceLevelIds
     * @return \patest\StructType\Sales_PriceList
     */
    public function setEffectivePriceLevelIds(\patest\StructType\EffectivePriceLevelIds $effectivePriceLevelIds = null)
    {
        if (is_null($effectivePriceLevelIds) || (is_array($effectivePriceLevelIds) && empty($effectivePriceLevelIds))) {
            unset($this->EffectivePriceLevelIds);
        } else {
            $this->EffectivePriceLevelIds = $effectivePriceLevelIds;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Sales_PriceList
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsBasePriceEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBasePriceEnabled()
    {
        return isset($this->IsBasePriceEnabled) ? $this->IsBasePriceEnabled : null;
    }
    /**
     * Set IsBasePriceEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBasePriceEnabled
     * @return \patest\StructType\Sales_PriceList
     */
    public function setIsBasePriceEnabled($isBasePriceEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBasePriceEnabled) && !is_bool($isBasePriceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBasePriceEnabled, true), gettype($isBasePriceEnabled)), __LINE__);
        }
        if (is_null($isBasePriceEnabled) || (is_array($isBasePriceEnabled) && empty($isBasePriceEnabled))) {
            unset($this->IsBasePriceEnabled);
        } else {
            $this->IsBasePriceEnabled = $isBasePriceEnabled;
        }
        return $this;
    }
    /**
     * Get ItemTypeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemTypeNumber()
    {
        return isset($this->ItemTypeNumber) ? $this->ItemTypeNumber : null;
    }
    /**
     * Set ItemTypeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemTypeNumber
     * @return \patest\StructType\Sales_PriceList
     */
    public function setItemTypeNumber($itemTypeNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemTypeNumber) && !(is_int($itemTypeNumber) || ctype_digit($itemTypeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemTypeNumber, true), gettype($itemTypeNumber)), __LINE__);
        }
        if (is_null($itemTypeNumber) || (is_array($itemTypeNumber) && empty($itemTypeNumber))) {
            unset($this->ItemTypeNumber);
        } else {
            $this->ItemTypeNumber = $itemTypeNumber;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_PriceList
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_PriceListPriceType|null
     */
    public function getPriceTypes()
    {
        return isset($this->PriceTypes) ? $this->PriceTypes : null;
    }
    /**
     * Set PriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_PriceListPriceType $priceTypes
     * @return \patest\StructType\Sales_PriceList
     */
    public function setPriceTypes(\patest\StructType\RecordSetOfSales_PriceListPriceType $priceTypes = null)
    {
        if (is_null($priceTypes) || (is_array($priceTypes) && empty($priceTypes))) {
            unset($this->PriceTypes);
        } else {
            $this->PriceTypes = $priceTypes;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Sales_PriceList
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
