<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PackageItem StructType
 * @subpackage Structs
 */
class Sales_PackageItem extends PersistableEntity
{
    /**
     * The BeneficiaryItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BeneficiaryItemIds;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PackageDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PackageDefinitionId;
    /**
     * Constructor method for Sales.PackageItem
     * @uses Sales_PackageItem::setBeneficiaryItemIds()
     * @uses Sales_PackageItem::setCategory()
     * @uses Sales_PackageItem::setDescription()
     * @uses Sales_PackageItem::setName()
     * @uses Sales_PackageItem::setPackageDefinitionId()
     * @param string $beneficiaryItemIds
     * @param string $category
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\GlobalString $name
     * @param string $packageDefinitionId
     */
    public function __construct($beneficiaryItemIds = null, $category = null, \patest\StructType\GlobalString $description = null, \patest\StructType\GlobalString $name = null, $packageDefinitionId = null)
    {
        $this
            ->setBeneficiaryItemIds($beneficiaryItemIds)
            ->setCategory($category)
            ->setDescription($description)
            ->setName($name)
            ->setPackageDefinitionId($packageDefinitionId);
    }
    /**
     * Get BeneficiaryItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBeneficiaryItemIds()
    {
        return isset($this->BeneficiaryItemIds) ? $this->BeneficiaryItemIds : null;
    }
    /**
     * Set BeneficiaryItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $beneficiaryItemIds
     * @return \patest\StructType\Sales_PackageItem
     */
    public function setBeneficiaryItemIds($beneficiaryItemIds = null)
    {
        // validation for constraint: string
        if (!is_null($beneficiaryItemIds) && !is_string($beneficiaryItemIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beneficiaryItemIds, true), gettype($beneficiaryItemIds)), __LINE__);
        }
        if (is_null($beneficiaryItemIds) || (is_array($beneficiaryItemIds) && empty($beneficiaryItemIds))) {
            unset($this->BeneficiaryItemIds);
        } else {
            $this->BeneficiaryItemIds = $beneficiaryItemIds;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \patest\StructType\Sales_PackageItem
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_PackageItem
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_PackageItem
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PackageDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageDefinitionId()
    {
        return isset($this->PackageDefinitionId) ? $this->PackageDefinitionId : null;
    }
    /**
     * Set PackageDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageDefinitionId
     * @return \patest\StructType\Sales_PackageItem
     */
    public function setPackageDefinitionId($packageDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($packageDefinitionId) && !is_string($packageDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageDefinitionId, true), gettype($packageDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($packageDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $packageDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($packageDefinitionId, true)), __LINE__);
        }
        if (is_null($packageDefinitionId) || (is_array($packageDefinitionId) && empty($packageDefinitionId))) {
            unset($this->PackageDefinitionId);
        } else {
            $this->PackageDefinitionId = $packageDefinitionId;
        }
        return $this;
    }
}
