<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.MergeTransaction StructType
 * @subpackage Structs
 */
class Sales_MergeTransaction extends PersistableEntity
{
    /**
     * The AccountGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountGroupId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The OnBehalfOfAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OnBehalfOfAccountId;
    /**
     * The RecoAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RecoAccountId;
    /**
     * Constructor method for Sales.MergeTransaction
     * @uses Sales_MergeTransaction::setAccountGroupId()
     * @uses Sales_MergeTransaction::setClientId()
     * @uses Sales_MergeTransaction::setOnBehalfOfAccountId()
     * @uses Sales_MergeTransaction::setRecoAccountId()
     * @param string $accountGroupId
     * @param string $clientId
     * @param string $onBehalfOfAccountId
     * @param string $recoAccountId
     */
    public function __construct($accountGroupId = null, $clientId = null, $onBehalfOfAccountId = null, $recoAccountId = null)
    {
        $this
            ->setAccountGroupId($accountGroupId)
            ->setClientId($clientId)
            ->setOnBehalfOfAccountId($onBehalfOfAccountId)
            ->setRecoAccountId($recoAccountId);
    }
    /**
     * Get AccountGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountGroupId()
    {
        return isset($this->AccountGroupId) ? $this->AccountGroupId : null;
    }
    /**
     * Set AccountGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountGroupId
     * @return \patest\StructType\Sales_MergeTransaction
     */
    public function setAccountGroupId($accountGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($accountGroupId) && !is_string($accountGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountGroupId, true), gettype($accountGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountGroupId, true)), __LINE__);
        }
        if (is_null($accountGroupId) || (is_array($accountGroupId) && empty($accountGroupId))) {
            unset($this->AccountGroupId);
        } else {
            $this->AccountGroupId = $accountGroupId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_MergeTransaction
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get OnBehalfOfAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountId()
    {
        return isset($this->OnBehalfOfAccountId) ? $this->OnBehalfOfAccountId : null;
    }
    /**
     * Set OnBehalfOfAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountId
     * @return \patest\StructType\Sales_MergeTransaction
     */
    public function setOnBehalfOfAccountId($onBehalfOfAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountId) && !is_string($onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountId, true), gettype($onBehalfOfAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($onBehalfOfAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($onBehalfOfAccountId, true)), __LINE__);
        }
        if (is_null($onBehalfOfAccountId) || (is_array($onBehalfOfAccountId) && empty($onBehalfOfAccountId))) {
            unset($this->OnBehalfOfAccountId);
        } else {
            $this->OnBehalfOfAccountId = $onBehalfOfAccountId;
        }
        return $this;
    }
    /**
     * Get RecoAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecoAccountId()
    {
        return isset($this->RecoAccountId) ? $this->RecoAccountId : null;
    }
    /**
     * Set RecoAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recoAccountId
     * @return \patest\StructType\Sales_MergeTransaction
     */
    public function setRecoAccountId($recoAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($recoAccountId) && !is_string($recoAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recoAccountId, true), gettype($recoAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($recoAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $recoAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($recoAccountId, true)), __LINE__);
        }
        if (is_null($recoAccountId) || (is_array($recoAccountId) && empty($recoAccountId))) {
            unset($this->RecoAccountId);
        } else {
            $this->RecoAccountId = $recoAccountId;
        }
        return $this;
    }
}
