<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ManifestCriteria StructType
 * @subpackage Structs
 */
class Sales_ManifestCriteria extends FilterEntity
{
    /**
     * The Aisle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Aisle;
    /**
     * The AllocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllocationId;
    /**
     * The AllocationNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationNames;
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaIds;
    /**
     * The Areas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Areas
     */
    public $Areas;
    /**
     * The DaysofWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DaysofWeek;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventIds;
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Events
     */
    public $Events;
    /**
     * The EventTypeIds
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventTypeIds;
    /**
     * The FromRow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromRow;
    /**
     * The FromSector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromSector;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IncludePartiallyAvailables
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludePartiallyAvailables;
    /**
     * The IsResaleOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResaleOnly;
    /**
     * The LockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockId;
    /**
     * The LockNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LockNames;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Price;
    /**
     * The PriceFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriceFrom;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelIds;
    /**
     * The PriceLevelNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelNames;
    /**
     * The PriceTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriceTo;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The QuantityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityType;
    /**
     * The SeasonIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonIds;
    /**
     * The Seasons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Seasons
     */
    public $Seasons;
    /**
     * The SeatTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeIds;
    /**
     * The SeatTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatTypes
     */
    public $SeatTypes;
    /**
     * The Sectors
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Sectors;
    /**
     * The SelectedAreas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedAreas;
    /**
     * The SelectedSeatQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectedSeatQuantity;
    /**
     * The SelectionCriteriaType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectionCriteriaType;
    /**
     * The SeriesEntitiesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeriesEntitiesIds
     */
    public $SeriesEntitiesIds;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesIds;
    /**
     * The ShowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowIds;
    /**
     * The Shows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Shows
     */
    public $Shows;
    /**
     * The ShowTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowTypeIds;
    /**
     * The ShowTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowTypes
     */
    public $ShowTypes;
    /**
     * The StandIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StandIds;
    /**
     * The Stands
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Stands
     */
    public $Stands;
    /**
     * The StartEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartEventDate;
    /**
     * The UntilEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilEventDate;
    /**
     * The UntilRow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilRow;
    /**
     * The UntilSector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilSector;
    /**
     * Constructor method for Sales.ManifestCriteria
     * @uses Sales_ManifestCriteria::setAisle()
     * @uses Sales_ManifestCriteria::setAllocationId()
     * @uses Sales_ManifestCriteria::setAllocationNames()
     * @uses Sales_ManifestCriteria::setAreaIds()
     * @uses Sales_ManifestCriteria::setAreas()
     * @uses Sales_ManifestCriteria::setDaysofWeek()
     * @uses Sales_ManifestCriteria::setEventIds()
     * @uses Sales_ManifestCriteria::setEvents()
     * @uses Sales_ManifestCriteria::setEventTypeIds()
     * @uses Sales_ManifestCriteria::setFromRow()
     * @uses Sales_ManifestCriteria::setFromSector()
     * @uses Sales_ManifestCriteria::setId()
     * @uses Sales_ManifestCriteria::setIncludePartiallyAvailables()
     * @uses Sales_ManifestCriteria::setIsResaleOnly()
     * @uses Sales_ManifestCriteria::setLockId()
     * @uses Sales_ManifestCriteria::setLockNames()
     * @uses Sales_ManifestCriteria::setPrice()
     * @uses Sales_ManifestCriteria::setPriceFrom()
     * @uses Sales_ManifestCriteria::setPriceLevelIds()
     * @uses Sales_ManifestCriteria::setPriceLevelNames()
     * @uses Sales_ManifestCriteria::setPriceTo()
     * @uses Sales_ManifestCriteria::setPriceTypeId()
     * @uses Sales_ManifestCriteria::setQuantityType()
     * @uses Sales_ManifestCriteria::setSeasonIds()
     * @uses Sales_ManifestCriteria::setSeasons()
     * @uses Sales_ManifestCriteria::setSeatTypeIds()
     * @uses Sales_ManifestCriteria::setSeatTypes()
     * @uses Sales_ManifestCriteria::setSectors()
     * @uses Sales_ManifestCriteria::setSelectedAreas()
     * @uses Sales_ManifestCriteria::setSelectedSeatQuantity()
     * @uses Sales_ManifestCriteria::setSelectionCriteriaType()
     * @uses Sales_ManifestCriteria::setSeriesEntitiesIds()
     * @uses Sales_ManifestCriteria::setSeriesIds()
     * @uses Sales_ManifestCriteria::setShowIds()
     * @uses Sales_ManifestCriteria::setShows()
     * @uses Sales_ManifestCriteria::setShowTypeIds()
     * @uses Sales_ManifestCriteria::setShowTypes()
     * @uses Sales_ManifestCriteria::setStandIds()
     * @uses Sales_ManifestCriteria::setStands()
     * @uses Sales_ManifestCriteria::setStartEventDate()
     * @uses Sales_ManifestCriteria::setUntilEventDate()
     * @uses Sales_ManifestCriteria::setUntilRow()
     * @uses Sales_ManifestCriteria::setUntilSector()
     * @param string $aisle
     * @param string $allocationId
     * @param string $allocationNames
     * @param string $areaIds
     * @param \patest\StructType\Areas $areas
     * @param string $daysofWeek
     * @param string $eventIds
     * @param \patest\StructType\Events $events
     * @param string $eventTypeIds
     * @param string $fromRow
     * @param string $fromSector
     * @param string $id
     * @param bool $includePartiallyAvailables
     * @param bool $isResaleOnly
     * @param string $lockId
     * @param string $lockNames
     * @param float $price
     * @param float $priceFrom
     * @param string $priceLevelIds
     * @param string $priceLevelNames
     * @param float $priceTo
     * @param string $priceTypeId
     * @param int $quantityType
     * @param string $seasonIds
     * @param \patest\StructType\Seasons $seasons
     * @param string $seatTypeIds
     * @param \patest\StructType\SeatTypes $seatTypes
     * @param string $sectors
     * @param string $selectedAreas
     * @param int $selectedSeatQuantity
     * @param int $selectionCriteriaType
     * @param \patest\StructType\SeriesEntitiesIds $seriesEntitiesIds
     * @param string $seriesIds
     * @param string $showIds
     * @param \patest\StructType\Shows $shows
     * @param string $showTypeIds
     * @param \patest\StructType\ShowTypes $showTypes
     * @param string $standIds
     * @param \patest\StructType\Stands $stands
     * @param string $startEventDate
     * @param string $untilEventDate
     * @param string $untilRow
     * @param string $untilSector
     */
    public function __construct($aisle = null, $allocationId = null, $allocationNames = null, $areaIds = null, \patest\StructType\Areas $areas = null, $daysofWeek = null, $eventIds = null, \patest\StructType\Events $events = null, $eventTypeIds = null, $fromRow = null, $fromSector = null, $id = null, $includePartiallyAvailables = null, $isResaleOnly = null, $lockId = null, $lockNames = null, $price = null, $priceFrom = null, $priceLevelIds = null, $priceLevelNames = null, $priceTo = null, $priceTypeId = null, $quantityType = null, $seasonIds = null, \patest\StructType\Seasons $seasons = null, $seatTypeIds = null, \patest\StructType\SeatTypes $seatTypes = null, $sectors = null, $selectedAreas = null, $selectedSeatQuantity = null, $selectionCriteriaType = null, \patest\StructType\SeriesEntitiesIds $seriesEntitiesIds = null, $seriesIds = null, $showIds = null, \patest\StructType\Shows $shows = null, $showTypeIds = null, \patest\StructType\ShowTypes $showTypes = null, $standIds = null, \patest\StructType\Stands $stands = null, $startEventDate = null, $untilEventDate = null, $untilRow = null, $untilSector = null)
    {
        $this
            ->setAisle($aisle)
            ->setAllocationId($allocationId)
            ->setAllocationNames($allocationNames)
            ->setAreaIds($areaIds)
            ->setAreas($areas)
            ->setDaysofWeek($daysofWeek)
            ->setEventIds($eventIds)
            ->setEvents($events)
            ->setEventTypeIds($eventTypeIds)
            ->setFromRow($fromRow)
            ->setFromSector($fromSector)
            ->setId($id)
            ->setIncludePartiallyAvailables($includePartiallyAvailables)
            ->setIsResaleOnly($isResaleOnly)
            ->setLockId($lockId)
            ->setLockNames($lockNames)
            ->setPrice($price)
            ->setPriceFrom($priceFrom)
            ->setPriceLevelIds($priceLevelIds)
            ->setPriceLevelNames($priceLevelNames)
            ->setPriceTo($priceTo)
            ->setPriceTypeId($priceTypeId)
            ->setQuantityType($quantityType)
            ->setSeasonIds($seasonIds)
            ->setSeasons($seasons)
            ->setSeatTypeIds($seatTypeIds)
            ->setSeatTypes($seatTypes)
            ->setSectors($sectors)
            ->setSelectedAreas($selectedAreas)
            ->setSelectedSeatQuantity($selectedSeatQuantity)
            ->setSelectionCriteriaType($selectionCriteriaType)
            ->setSeriesEntitiesIds($seriesEntitiesIds)
            ->setSeriesIds($seriesIds)
            ->setShowIds($showIds)
            ->setShows($shows)
            ->setShowTypeIds($showTypeIds)
            ->setShowTypes($showTypes)
            ->setStandIds($standIds)
            ->setStands($stands)
            ->setStartEventDate($startEventDate)
            ->setUntilEventDate($untilEventDate)
            ->setUntilRow($untilRow)
            ->setUntilSector($untilSector);
    }
    /**
     * Get Aisle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAisle()
    {
        return isset($this->Aisle) ? $this->Aisle : null;
    }
    /**
     * Set Aisle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AislePolicy::valueIsValid()
     * @uses \patest\EnumType\AislePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aisle
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setAisle($aisle = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AislePolicy::valueIsValid($aisle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AislePolicy', is_array($aisle) ? implode(', ', $aisle) : var_export($aisle, true), implode(', ', \patest\EnumType\AislePolicy::getValidValues())), __LINE__);
        }
        if (is_null($aisle) || (is_array($aisle) && empty($aisle))) {
            unset($this->Aisle);
        } else {
            $this->Aisle = $aisle;
        }
        return $this;
    }
    /**
     * Get AllocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationId()
    {
        return isset($this->AllocationId) ? $this->AllocationId : null;
    }
    /**
     * Set AllocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationId
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setAllocationId($allocationId = null)
    {
        // validation for constraint: string
        if (!is_null($allocationId) && !is_string($allocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationId, true), gettype($allocationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allocationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allocationId, true)), __LINE__);
        }
        if (is_null($allocationId) || (is_array($allocationId) && empty($allocationId))) {
            unset($this->AllocationId);
        } else {
            $this->AllocationId = $allocationId;
        }
        return $this;
    }
    /**
     * Get AllocationNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationNames()
    {
        return isset($this->AllocationNames) ? $this->AllocationNames : null;
    }
    /**
     * Set AllocationNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationNames
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setAllocationNames($allocationNames = null)
    {
        // validation for constraint: string
        if (!is_null($allocationNames) && !is_string($allocationNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationNames, true), gettype($allocationNames)), __LINE__);
        }
        if (is_null($allocationNames) || (is_array($allocationNames) && empty($allocationNames))) {
            unset($this->AllocationNames);
        } else {
            $this->AllocationNames = $allocationNames;
        }
        return $this;
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setAreaIds($areaIds = null)
    {
        // validation for constraint: string
        if (!is_null($areaIds) && !is_string($areaIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaIds, true), gettype($areaIds)), __LINE__);
        }
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get Areas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Areas|null
     */
    public function getAreas()
    {
        return isset($this->Areas) ? $this->Areas : null;
    }
    /**
     * Set Areas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Areas $areas
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setAreas(\patest\StructType\Areas $areas = null)
    {
        if (is_null($areas) || (is_array($areas) && empty($areas))) {
            unset($this->Areas);
        } else {
            $this->Areas = $areas;
        }
        return $this;
    }
    /**
     * Get DaysofWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaysofWeek()
    {
        return isset($this->DaysofWeek) ? $this->DaysofWeek : null;
    }
    /**
     * Set DaysofWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daysofWeek
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setDaysofWeek($daysofWeek = null)
    {
        // validation for constraint: string
        if (!is_null($daysofWeek) && !is_string($daysofWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daysofWeek, true), gettype($daysofWeek)), __LINE__);
        }
        if (is_null($daysofWeek) || (is_array($daysofWeek) && empty($daysofWeek))) {
            unset($this->DaysofWeek);
        } else {
            $this->DaysofWeek = $daysofWeek;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setEventIds($eventIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventIds) && !is_string($eventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventIds, true), gettype($eventIds)), __LINE__);
        }
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Events|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Events $events
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setEvents(\patest\StructType\Events $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get EventTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTypeIds()
    {
        return isset($this->EventTypeIds) ? $this->EventTypeIds : null;
    }
    /**
     * Set EventTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTypeIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setEventTypeIds($eventTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventTypeIds) && !is_string($eventTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTypeIds, true), gettype($eventTypeIds)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventTypeIds) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventTypeIds, true)), __LINE__);
        }
        if (is_null($eventTypeIds) || (is_array($eventTypeIds) && empty($eventTypeIds))) {
            unset($this->EventTypeIds);
        } else {
            $this->EventTypeIds = $eventTypeIds;
        }
        return $this;
    }
    /**
     * Get FromRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromRow()
    {
        return isset($this->FromRow) ? $this->FromRow : null;
    }
    /**
     * Set FromRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromRow
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setFromRow($fromRow = null)
    {
        // validation for constraint: string
        if (!is_null($fromRow) && !is_string($fromRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromRow, true), gettype($fromRow)), __LINE__);
        }
        if (is_null($fromRow) || (is_array($fromRow) && empty($fromRow))) {
            unset($this->FromRow);
        } else {
            $this->FromRow = $fromRow;
        }
        return $this;
    }
    /**
     * Get FromSector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromSector()
    {
        return isset($this->FromSector) ? $this->FromSector : null;
    }
    /**
     * Set FromSector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromSector
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setFromSector($fromSector = null)
    {
        // validation for constraint: string
        if (!is_null($fromSector) && !is_string($fromSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromSector, true), gettype($fromSector)), __LINE__);
        }
        if (is_null($fromSector) || (is_array($fromSector) && empty($fromSector))) {
            unset($this->FromSector);
        } else {
            $this->FromSector = $fromSector;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IncludePartiallyAvailables value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludePartiallyAvailables()
    {
        return isset($this->IncludePartiallyAvailables) ? $this->IncludePartiallyAvailables : null;
    }
    /**
     * Set IncludePartiallyAvailables value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includePartiallyAvailables
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setIncludePartiallyAvailables($includePartiallyAvailables = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePartiallyAvailables) && !is_bool($includePartiallyAvailables)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePartiallyAvailables, true), gettype($includePartiallyAvailables)), __LINE__);
        }
        if (is_null($includePartiallyAvailables) || (is_array($includePartiallyAvailables) && empty($includePartiallyAvailables))) {
            unset($this->IncludePartiallyAvailables);
        } else {
            $this->IncludePartiallyAvailables = $includePartiallyAvailables;
        }
        return $this;
    }
    /**
     * Get IsResaleOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResaleOnly()
    {
        return isset($this->IsResaleOnly) ? $this->IsResaleOnly : null;
    }
    /**
     * Set IsResaleOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResaleOnly
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setIsResaleOnly($isResaleOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResaleOnly) && !is_bool($isResaleOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResaleOnly, true), gettype($isResaleOnly)), __LINE__);
        }
        if (is_null($isResaleOnly) || (is_array($isResaleOnly) && empty($isResaleOnly))) {
            unset($this->IsResaleOnly);
        } else {
            $this->IsResaleOnly = $isResaleOnly;
        }
        return $this;
    }
    /**
     * Get LockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockId()
    {
        return isset($this->LockId) ? $this->LockId : null;
    }
    /**
     * Set LockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockId
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setLockId($lockId = null)
    {
        // validation for constraint: string
        if (!is_null($lockId) && !is_string($lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockId, true), gettype($lockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockId, true)), __LINE__);
        }
        if (is_null($lockId) || (is_array($lockId) && empty($lockId))) {
            unset($this->LockId);
        } else {
            $this->LockId = $lockId;
        }
        return $this;
    }
    /**
     * Get LockNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockNames()
    {
        return isset($this->LockNames) ? $this->LockNames : null;
    }
    /**
     * Set LockNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockNames
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setLockNames($lockNames = null)
    {
        // validation for constraint: string
        if (!is_null($lockNames) && !is_string($lockNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockNames, true), gettype($lockNames)), __LINE__);
        }
        if (is_null($lockNames) || (is_array($lockNames) && empty($lockNames))) {
            unset($this->LockNames);
        } else {
            $this->LockNames = $lockNames;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PriceFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriceFrom()
    {
        return isset($this->PriceFrom) ? $this->PriceFrom : null;
    }
    /**
     * Set PriceFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priceFrom
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setPriceFrom($priceFrom = null)
    {
        // validation for constraint: float
        if (!is_null($priceFrom) && !(is_float($priceFrom) || is_numeric($priceFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceFrom, true), gettype($priceFrom)), __LINE__);
        }
        if (is_null($priceFrom) || (is_array($priceFrom) && empty($priceFrom))) {
            unset($this->PriceFrom);
        } else {
            $this->PriceFrom = $priceFrom;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setPriceLevelIds($priceLevelIds = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelIds) && !is_string($priceLevelIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelIds, true), gettype($priceLevelIds)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelIds) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelIds, true)), __LINE__);
        }
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get PriceLevelNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelNames()
    {
        return isset($this->PriceLevelNames) ? $this->PriceLevelNames : null;
    }
    /**
     * Set PriceLevelNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelNames
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setPriceLevelNames($priceLevelNames = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelNames) && !is_string($priceLevelNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelNames, true), gettype($priceLevelNames)), __LINE__);
        }
        if (is_null($priceLevelNames) || (is_array($priceLevelNames) && empty($priceLevelNames))) {
            unset($this->PriceLevelNames);
        } else {
            $this->PriceLevelNames = $priceLevelNames;
        }
        return $this;
    }
    /**
     * Get PriceTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriceTo()
    {
        return isset($this->PriceTo) ? $this->PriceTo : null;
    }
    /**
     * Set PriceTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priceTo
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setPriceTo($priceTo = null)
    {
        // validation for constraint: float
        if (!is_null($priceTo) && !(is_float($priceTo) || is_numeric($priceTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceTo, true), gettype($priceTo)), __LINE__);
        }
        if (is_null($priceTo) || (is_array($priceTo) && empty($priceTo))) {
            unset($this->PriceTo);
        } else {
            $this->PriceTo = $priceTo;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get QuantityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityType()
    {
        return isset($this->QuantityType) ? $this->QuantityType : null;
    }
    /**
     * Set QuantityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityType
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setQuantityType($quantityType = null)
    {
        // validation for constraint: int
        if (!is_null($quantityType) && !(is_int($quantityType) || ctype_digit($quantityType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityType, true), gettype($quantityType)), __LINE__);
        }
        if (is_null($quantityType) || (is_array($quantityType) && empty($quantityType))) {
            unset($this->QuantityType);
        } else {
            $this->QuantityType = $quantityType;
        }
        return $this;
    }
    /**
     * Get SeasonIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonIds()
    {
        return isset($this->SeasonIds) ? $this->SeasonIds : null;
    }
    /**
     * Set SeasonIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSeasonIds($seasonIds = null)
    {
        // validation for constraint: string
        if (!is_null($seasonIds) && !is_string($seasonIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonIds, true), gettype($seasonIds)), __LINE__);
        }
        if (is_null($seasonIds) || (is_array($seasonIds) && empty($seasonIds))) {
            unset($this->SeasonIds);
        } else {
            $this->SeasonIds = $seasonIds;
        }
        return $this;
    }
    /**
     * Get Seasons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Seasons|null
     */
    public function getSeasons()
    {
        return isset($this->Seasons) ? $this->Seasons : null;
    }
    /**
     * Set Seasons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Seasons $seasons
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSeasons(\patest\StructType\Seasons $seasons = null)
    {
        if (is_null($seasons) || (is_array($seasons) && empty($seasons))) {
            unset($this->Seasons);
        } else {
            $this->Seasons = $seasons;
        }
        return $this;
    }
    /**
     * Get SeatTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeIds()
    {
        return isset($this->SeatTypeIds) ? $this->SeatTypeIds : null;
    }
    /**
     * Set SeatTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSeatTypeIds($seatTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeIds) && !is_string($seatTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeIds, true), gettype($seatTypeIds)), __LINE__);
        }
        if (is_null($seatTypeIds) || (is_array($seatTypeIds) && empty($seatTypeIds))) {
            unset($this->SeatTypeIds);
        } else {
            $this->SeatTypeIds = $seatTypeIds;
        }
        return $this;
    }
    /**
     * Get SeatTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatTypes|null
     */
    public function getSeatTypes()
    {
        return isset($this->SeatTypes) ? $this->SeatTypes : null;
    }
    /**
     * Set SeatTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatTypes $seatTypes
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSeatTypes(\patest\StructType\SeatTypes $seatTypes = null)
    {
        if (is_null($seatTypes) || (is_array($seatTypes) && empty($seatTypes))) {
            unset($this->SeatTypes);
        } else {
            $this->SeatTypes = $seatTypes;
        }
        return $this;
    }
    /**
     * Get Sectors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectors()
    {
        return isset($this->Sectors) ? $this->Sectors : null;
    }
    /**
     * Set Sectors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectors
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSectors($sectors = null)
    {
        // validation for constraint: string
        if (!is_null($sectors) && !is_string($sectors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectors, true), gettype($sectors)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectors) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectors, true)), __LINE__);
        }
        if (is_null($sectors) || (is_array($sectors) && empty($sectors))) {
            unset($this->Sectors);
        } else {
            $this->Sectors = $sectors;
        }
        return $this;
    }
    /**
     * Get SelectedAreas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedAreas()
    {
        return isset($this->SelectedAreas) ? $this->SelectedAreas : null;
    }
    /**
     * Set SelectedAreas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedAreas
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSelectedAreas($selectedAreas = null)
    {
        // validation for constraint: string
        if (!is_null($selectedAreas) && !is_string($selectedAreas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedAreas, true), gettype($selectedAreas)), __LINE__);
        }
        if (is_null($selectedAreas) || (is_array($selectedAreas) && empty($selectedAreas))) {
            unset($this->SelectedAreas);
        } else {
            $this->SelectedAreas = $selectedAreas;
        }
        return $this;
    }
    /**
     * Get SelectedSeatQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectedSeatQuantity()
    {
        return isset($this->SelectedSeatQuantity) ? $this->SelectedSeatQuantity : null;
    }
    /**
     * Set SelectedSeatQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectedSeatQuantity
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSelectedSeatQuantity($selectedSeatQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($selectedSeatQuantity) && !(is_int($selectedSeatQuantity) || ctype_digit($selectedSeatQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedSeatQuantity, true), gettype($selectedSeatQuantity)), __LINE__);
        }
        if (is_null($selectedSeatQuantity) || (is_array($selectedSeatQuantity) && empty($selectedSeatQuantity))) {
            unset($this->SelectedSeatQuantity);
        } else {
            $this->SelectedSeatQuantity = $selectedSeatQuantity;
        }
        return $this;
    }
    /**
     * Get SelectionCriteriaType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectionCriteriaType()
    {
        return isset($this->SelectionCriteriaType) ? $this->SelectionCriteriaType : null;
    }
    /**
     * Set SelectionCriteriaType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectionCriteriaType
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSelectionCriteriaType($selectionCriteriaType = null)
    {
        // validation for constraint: int
        if (!is_null($selectionCriteriaType) && !(is_int($selectionCriteriaType) || ctype_digit($selectionCriteriaType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectionCriteriaType, true), gettype($selectionCriteriaType)), __LINE__);
        }
        if (is_null($selectionCriteriaType) || (is_array($selectionCriteriaType) && empty($selectionCriteriaType))) {
            unset($this->SelectionCriteriaType);
        } else {
            $this->SelectionCriteriaType = $selectionCriteriaType;
        }
        return $this;
    }
    /**
     * Get SeriesEntitiesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeriesEntitiesIds|null
     */
    public function getSeriesEntitiesIds()
    {
        return isset($this->SeriesEntitiesIds) ? $this->SeriesEntitiesIds : null;
    }
    /**
     * Set SeriesEntitiesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeriesEntitiesIds $seriesEntitiesIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSeriesEntitiesIds(\patest\StructType\SeriesEntitiesIds $seriesEntitiesIds = null)
    {
        if (is_null($seriesEntitiesIds) || (is_array($seriesEntitiesIds) && empty($seriesEntitiesIds))) {
            unset($this->SeriesEntitiesIds);
        } else {
            $this->SeriesEntitiesIds = $seriesEntitiesIds;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setSeriesIds($seriesIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIds) && !is_string($seriesIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIds, true), gettype($seriesIds)), __LINE__);
        }
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get ShowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowIds()
    {
        return isset($this->ShowIds) ? $this->ShowIds : null;
    }
    /**
     * Set ShowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setShowIds($showIds = null)
    {
        // validation for constraint: string
        if (!is_null($showIds) && !is_string($showIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showIds, true), gettype($showIds)), __LINE__);
        }
        if (is_null($showIds) || (is_array($showIds) && empty($showIds))) {
            unset($this->ShowIds);
        } else {
            $this->ShowIds = $showIds;
        }
        return $this;
    }
    /**
     * Get Shows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Shows|null
     */
    public function getShows()
    {
        return isset($this->Shows) ? $this->Shows : null;
    }
    /**
     * Set Shows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Shows $shows
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setShows(\patest\StructType\Shows $shows = null)
    {
        if (is_null($shows) || (is_array($shows) && empty($shows))) {
            unset($this->Shows);
        } else {
            $this->Shows = $shows;
        }
        return $this;
    }
    /**
     * Get ShowTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTypeIds()
    {
        return isset($this->ShowTypeIds) ? $this->ShowTypeIds : null;
    }
    /**
     * Set ShowTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTypeIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setShowTypeIds($showTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeIds) && !is_string($showTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeIds, true), gettype($showTypeIds)), __LINE__);
        }
        if (is_null($showTypeIds) || (is_array($showTypeIds) && empty($showTypeIds))) {
            unset($this->ShowTypeIds);
        } else {
            $this->ShowTypeIds = $showTypeIds;
        }
        return $this;
    }
    /**
     * Get ShowTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowTypes|null
     */
    public function getShowTypes()
    {
        return isset($this->ShowTypes) ? $this->ShowTypes : null;
    }
    /**
     * Set ShowTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowTypes $showTypes
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setShowTypes(\patest\StructType\ShowTypes $showTypes = null)
    {
        if (is_null($showTypes) || (is_array($showTypes) && empty($showTypes))) {
            unset($this->ShowTypes);
        } else {
            $this->ShowTypes = $showTypes;
        }
        return $this;
    }
    /**
     * Get StandIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandIds()
    {
        return isset($this->StandIds) ? $this->StandIds : null;
    }
    /**
     * Set StandIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standIds
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setStandIds($standIds = null)
    {
        // validation for constraint: string
        if (!is_null($standIds) && !is_string($standIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standIds, true), gettype($standIds)), __LINE__);
        }
        if (is_null($standIds) || (is_array($standIds) && empty($standIds))) {
            unset($this->StandIds);
        } else {
            $this->StandIds = $standIds;
        }
        return $this;
    }
    /**
     * Get Stands value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Stands|null
     */
    public function getStands()
    {
        return isset($this->Stands) ? $this->Stands : null;
    }
    /**
     * Set Stands value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Stands $stands
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setStands(\patest\StructType\Stands $stands = null)
    {
        if (is_null($stands) || (is_array($stands) && empty($stands))) {
            unset($this->Stands);
        } else {
            $this->Stands = $stands;
        }
        return $this;
    }
    /**
     * Get StartEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartEventDate()
    {
        return isset($this->StartEventDate) ? $this->StartEventDate : null;
    }
    /**
     * Set StartEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startEventDate
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setStartEventDate($startEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($startEventDate) && !is_string($startEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startEventDate, true), gettype($startEventDate)), __LINE__);
        }
        if (is_null($startEventDate) || (is_array($startEventDate) && empty($startEventDate))) {
            unset($this->StartEventDate);
        } else {
            $this->StartEventDate = $startEventDate;
        }
        return $this;
    }
    /**
     * Get UntilEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilEventDate()
    {
        return isset($this->UntilEventDate) ? $this->UntilEventDate : null;
    }
    /**
     * Set UntilEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilEventDate
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setUntilEventDate($untilEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilEventDate) && !is_string($untilEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilEventDate, true), gettype($untilEventDate)), __LINE__);
        }
        if (is_null($untilEventDate) || (is_array($untilEventDate) && empty($untilEventDate))) {
            unset($this->UntilEventDate);
        } else {
            $this->UntilEventDate = $untilEventDate;
        }
        return $this;
    }
    /**
     * Get UntilRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilRow()
    {
        return isset($this->UntilRow) ? $this->UntilRow : null;
    }
    /**
     * Set UntilRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilRow
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setUntilRow($untilRow = null)
    {
        // validation for constraint: string
        if (!is_null($untilRow) && !is_string($untilRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilRow, true), gettype($untilRow)), __LINE__);
        }
        if (is_null($untilRow) || (is_array($untilRow) && empty($untilRow))) {
            unset($this->UntilRow);
        } else {
            $this->UntilRow = $untilRow;
        }
        return $this;
    }
    /**
     * Get UntilSector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilSector()
    {
        return isset($this->UntilSector) ? $this->UntilSector : null;
    }
    /**
     * Set UntilSector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilSector
     * @return \patest\StructType\Sales_ManifestCriteria
     */
    public function setUntilSector($untilSector = null)
    {
        // validation for constraint: string
        if (!is_null($untilSector) && !is_string($untilSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilSector, true), gettype($untilSector)), __LINE__);
        }
        if (is_null($untilSector) || (is_array($untilSector) && empty($untilSector))) {
            unset($this->UntilSector);
        } else {
            $this->UntilSector = $untilSector;
        }
        return $this;
    }
}
