<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ItemChangeOfOwnership StructType
 * @subpackage Structs
 */
class Sales_ItemChangeOfOwnership extends AnyEntity
{
    /**
     * The ActionTextExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionTextExtension;
    /**
     * The DateOfTransfer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfTransfer;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The OwnerClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerClientId;
    /**
     * The OwnerCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerCrmId;
    /**
     * The OwnerEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerEmail;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The OwnershipChangeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnershipChangeType;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDetails;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PreviousOwnerClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreviousOwnerClientId;
    /**
     * The PreviousOwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreviousOwnerName;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The ResaleRequestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleRequestDate;
    /**
     * The StatusDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusDetails;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The VersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VersionId;
    /**
     * Constructor method for Sales.ItemChangeOfOwnership
     * @uses Sales_ItemChangeOfOwnership::setActionTextExtension()
     * @uses Sales_ItemChangeOfOwnership::setDateOfTransfer()
     * @uses Sales_ItemChangeOfOwnership::setIsValid()
     * @uses Sales_ItemChangeOfOwnership::setOwnerClientId()
     * @uses Sales_ItemChangeOfOwnership::setOwnerCrmId()
     * @uses Sales_ItemChangeOfOwnership::setOwnerEmail()
     * @uses Sales_ItemChangeOfOwnership::setOwnerName()
     * @uses Sales_ItemChangeOfOwnership::setOwnershipChangeType()
     * @uses Sales_ItemChangeOfOwnership::setPaymentDetails()
     * @uses Sales_ItemChangeOfOwnership::setPaymentMethodName()
     * @uses Sales_ItemChangeOfOwnership::setPreviousOwnerClientId()
     * @uses Sales_ItemChangeOfOwnership::setPreviousOwnerName()
     * @uses Sales_ItemChangeOfOwnership::setPrice()
     * @uses Sales_ItemChangeOfOwnership::setResaleRequestDate()
     * @uses Sales_ItemChangeOfOwnership::setStatusDetails()
     * @uses Sales_ItemChangeOfOwnership::setTransactionId()
     * @uses Sales_ItemChangeOfOwnership::setTransactionNumber()
     * @uses Sales_ItemChangeOfOwnership::setVersionId()
     * @param string $actionTextExtension
     * @param string $dateOfTransfer
     * @param bool $isValid
     * @param string $ownerClientId
     * @param string $ownerCrmId
     * @param string $ownerEmail
     * @param string $ownerName
     * @param string $ownershipChangeType
     * @param string $paymentDetails
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param string $previousOwnerClientId
     * @param string $previousOwnerName
     * @param \patest\StructType\Money $price
     * @param string $resaleRequestDate
     * @param string $statusDetails
     * @param string $transactionId
     * @param int $transactionNumber
     * @param string $versionId
     */
    public function __construct($actionTextExtension = null, $dateOfTransfer = null, $isValid = null, $ownerClientId = null, $ownerCrmId = null, $ownerEmail = null, $ownerName = null, $ownershipChangeType = null, $paymentDetails = null, \patest\StructType\GlobalString $paymentMethodName = null, $previousOwnerClientId = null, $previousOwnerName = null, \patest\StructType\Money $price = null, $resaleRequestDate = null, $statusDetails = null, $transactionId = null, $transactionNumber = null, $versionId = null)
    {
        $this
            ->setActionTextExtension($actionTextExtension)
            ->setDateOfTransfer($dateOfTransfer)
            ->setIsValid($isValid)
            ->setOwnerClientId($ownerClientId)
            ->setOwnerCrmId($ownerCrmId)
            ->setOwnerEmail($ownerEmail)
            ->setOwnerName($ownerName)
            ->setOwnershipChangeType($ownershipChangeType)
            ->setPaymentDetails($paymentDetails)
            ->setPaymentMethodName($paymentMethodName)
            ->setPreviousOwnerClientId($previousOwnerClientId)
            ->setPreviousOwnerName($previousOwnerName)
            ->setPrice($price)
            ->setResaleRequestDate($resaleRequestDate)
            ->setStatusDetails($statusDetails)
            ->setTransactionId($transactionId)
            ->setTransactionNumber($transactionNumber)
            ->setVersionId($versionId);
    }
    /**
     * Get ActionTextExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionTextExtension()
    {
        return isset($this->ActionTextExtension) ? $this->ActionTextExtension : null;
    }
    /**
     * Set ActionTextExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionTextExtension
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setActionTextExtension($actionTextExtension = null)
    {
        // validation for constraint: string
        if (!is_null($actionTextExtension) && !is_string($actionTextExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionTextExtension, true), gettype($actionTextExtension)), __LINE__);
        }
        if (is_null($actionTextExtension) || (is_array($actionTextExtension) && empty($actionTextExtension))) {
            unset($this->ActionTextExtension);
        } else {
            $this->ActionTextExtension = $actionTextExtension;
        }
        return $this;
    }
    /**
     * Get DateOfTransfer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfTransfer()
    {
        return isset($this->DateOfTransfer) ? $this->DateOfTransfer : null;
    }
    /**
     * Set DateOfTransfer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfTransfer
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setDateOfTransfer($dateOfTransfer = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfTransfer) && !is_string($dateOfTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfTransfer, true), gettype($dateOfTransfer)), __LINE__);
        }
        if (is_null($dateOfTransfer) || (is_array($dateOfTransfer) && empty($dateOfTransfer))) {
            unset($this->DateOfTransfer);
        } else {
            $this->DateOfTransfer = $dateOfTransfer;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get OwnerClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientId()
    {
        return isset($this->OwnerClientId) ? $this->OwnerClientId : null;
    }
    /**
     * Set OwnerClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientId
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setOwnerClientId($ownerClientId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientId) && !is_string($ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientId, true), gettype($ownerClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerClientId, true)), __LINE__);
        }
        if (is_null($ownerClientId) || (is_array($ownerClientId) && empty($ownerClientId))) {
            unset($this->OwnerClientId);
        } else {
            $this->OwnerClientId = $ownerClientId;
        }
        return $this;
    }
    /**
     * Get OwnerCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerCrmId()
    {
        return isset($this->OwnerCrmId) ? $this->OwnerCrmId : null;
    }
    /**
     * Set OwnerCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerCrmId
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setOwnerCrmId($ownerCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCrmId) && !is_string($ownerCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCrmId, true), gettype($ownerCrmId)), __LINE__);
        }
        if (is_null($ownerCrmId) || (is_array($ownerCrmId) && empty($ownerCrmId))) {
            unset($this->OwnerCrmId);
        } else {
            $this->OwnerCrmId = $ownerCrmId;
        }
        return $this;
    }
    /**
     * Get OwnerEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerEmail()
    {
        return isset($this->OwnerEmail) ? $this->OwnerEmail : null;
    }
    /**
     * Set OwnerEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerEmail
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setOwnerEmail($ownerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($ownerEmail) && !is_string($ownerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerEmail, true), gettype($ownerEmail)), __LINE__);
        }
        if (is_null($ownerEmail) || (is_array($ownerEmail) && empty($ownerEmail))) {
            unset($this->OwnerEmail);
        } else {
            $this->OwnerEmail = $ownerEmail;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get OwnershipChangeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnershipChangeType()
    {
        return isset($this->OwnershipChangeType) ? $this->OwnershipChangeType : null;
    }
    /**
     * Set OwnershipChangeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ChainOfCustodyActions::valueIsValid()
     * @uses \patest\EnumType\ChainOfCustodyActions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ownershipChangeType
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setOwnershipChangeType($ownershipChangeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ChainOfCustodyActions::valueIsValid($ownershipChangeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ChainOfCustodyActions', is_array($ownershipChangeType) ? implode(', ', $ownershipChangeType) : var_export($ownershipChangeType, true), implode(', ', \patest\EnumType\ChainOfCustodyActions::getValidValues())), __LINE__);
        }
        if (is_null($ownershipChangeType) || (is_array($ownershipChangeType) && empty($ownershipChangeType))) {
            unset($this->OwnershipChangeType);
        } else {
            $this->OwnershipChangeType = $ownershipChangeType;
        }
        return $this;
    }
    /**
     * Get PaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return isset($this->PaymentDetails) ? $this->PaymentDetails : null;
    }
    /**
     * Set PaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetails
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        if (is_null($paymentDetails) || (is_array($paymentDetails) && empty($paymentDetails))) {
            unset($this->PaymentDetails);
        } else {
            $this->PaymentDetails = $paymentDetails;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PreviousOwnerClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousOwnerClientId()
    {
        return isset($this->PreviousOwnerClientId) ? $this->PreviousOwnerClientId : null;
    }
    /**
     * Set PreviousOwnerClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousOwnerClientId
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setPreviousOwnerClientId($previousOwnerClientId = null)
    {
        // validation for constraint: string
        if (!is_null($previousOwnerClientId) && !is_string($previousOwnerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousOwnerClientId, true), gettype($previousOwnerClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($previousOwnerClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $previousOwnerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($previousOwnerClientId, true)), __LINE__);
        }
        if (is_null($previousOwnerClientId) || (is_array($previousOwnerClientId) && empty($previousOwnerClientId))) {
            unset($this->PreviousOwnerClientId);
        } else {
            $this->PreviousOwnerClientId = $previousOwnerClientId;
        }
        return $this;
    }
    /**
     * Get PreviousOwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousOwnerName()
    {
        return isset($this->PreviousOwnerName) ? $this->PreviousOwnerName : null;
    }
    /**
     * Set PreviousOwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousOwnerName
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setPreviousOwnerName($previousOwnerName = null)
    {
        // validation for constraint: string
        if (!is_null($previousOwnerName) && !is_string($previousOwnerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousOwnerName, true), gettype($previousOwnerName)), __LINE__);
        }
        if (is_null($previousOwnerName) || (is_array($previousOwnerName) && empty($previousOwnerName))) {
            unset($this->PreviousOwnerName);
        } else {
            $this->PreviousOwnerName = $previousOwnerName;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get ResaleRequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleRequestDate()
    {
        return isset($this->ResaleRequestDate) ? $this->ResaleRequestDate : null;
    }
    /**
     * Set ResaleRequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resaleRequestDate
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setResaleRequestDate($resaleRequestDate = null)
    {
        // validation for constraint: string
        if (!is_null($resaleRequestDate) && !is_string($resaleRequestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resaleRequestDate, true), gettype($resaleRequestDate)), __LINE__);
        }
        if (is_null($resaleRequestDate) || (is_array($resaleRequestDate) && empty($resaleRequestDate))) {
            unset($this->ResaleRequestDate);
        } else {
            $this->ResaleRequestDate = $resaleRequestDate;
        }
        return $this;
    }
    /**
     * Get StatusDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusDetails()
    {
        return isset($this->StatusDetails) ? $this->StatusDetails : null;
    }
    /**
     * Set StatusDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusDetails
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setStatusDetails($statusDetails = null)
    {
        // validation for constraint: string
        if (!is_null($statusDetails) && !is_string($statusDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDetails, true), gettype($statusDetails)), __LINE__);
        }
        if (is_null($statusDetails) || (is_array($statusDetails) && empty($statusDetails))) {
            unset($this->StatusDetails);
        } else {
            $this->StatusDetails = $statusDetails;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get VersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersionId()
    {
        return isset($this->VersionId) ? $this->VersionId : null;
    }
    /**
     * Set VersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $versionId
     * @return \patest\StructType\Sales_ItemChangeOfOwnership
     */
    public function setVersionId($versionId = null)
    {
        // validation for constraint: string
        if (!is_null($versionId) && !is_string($versionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionId, true), gettype($versionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($versionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $versionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($versionId, true)), __LINE__);
        }
        if (is_null($versionId) || (is_array($versionId) && empty($versionId))) {
            unset($this->VersionId);
        } else {
            $this->VersionId = $versionId;
        }
        return $this;
    }
}
