<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.GroupedUnpaidItem StructType
 * @subpackage Structs
 */
class Sales_GroupedUnpaidItem extends Sales_FinancialJournalTargetSummaryBase
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ItemName;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The SalesItemTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesItemTypeName;
    /**
     * The TargetId2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetId2;
    /**
     * Constructor method for Sales.GroupedUnpaidItem
     * @uses Sales_GroupedUnpaidItem::setEventDate()
     * @uses Sales_GroupedUnpaidItem::setItemName()
     * @uses Sales_GroupedUnpaidItem::setPaymentStatus()
     * @uses Sales_GroupedUnpaidItem::setQuantity()
     * @uses Sales_GroupedUnpaidItem::setSalesItemTypeName()
     * @uses Sales_GroupedUnpaidItem::setTargetId2()
     * @param string $eventDate
     * @param \patest\StructType\GlobalString $itemName
     * @param string $paymentStatus
     * @param int $quantity
     * @param string $salesItemTypeName
     * @param string $targetId2
     */
    public function __construct($eventDate = null, \patest\StructType\GlobalString $itemName = null, $paymentStatus = null, $quantity = null, $salesItemTypeName = null, $targetId2 = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setItemName($itemName)
            ->setPaymentStatus($paymentStatus)
            ->setQuantity($quantity)
            ->setSalesItemTypeName($salesItemTypeName)
            ->setTargetId2($targetId2);
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Sales_GroupedUnpaidItem
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $itemName
     * @return \patest\StructType\Sales_GroupedUnpaidItem
     */
    public function setItemName(\patest\StructType\GlobalString $itemName = null)
    {
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentPaidStatusType::valueIsValid()
     * @uses \patest\EnumType\PaymentPaidStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Sales_GroupedUnpaidItem
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentPaidStatusType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentPaidStatusType', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentPaidStatusType::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\Sales_GroupedUnpaidItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get SalesItemTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesItemTypeName()
    {
        return isset($this->SalesItemTypeName) ? $this->SalesItemTypeName : null;
    }
    /**
     * Set SalesItemTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesItemTypeName
     * @return \patest\StructType\Sales_GroupedUnpaidItem
     */
    public function setSalesItemTypeName($salesItemTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($salesItemTypeName) && !is_string($salesItemTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesItemTypeName, true), gettype($salesItemTypeName)), __LINE__);
        }
        if (is_null($salesItemTypeName) || (is_array($salesItemTypeName) && empty($salesItemTypeName))) {
            unset($this->SalesItemTypeName);
        } else {
            $this->SalesItemTypeName = $salesItemTypeName;
        }
        return $this;
    }
    /**
     * Get TargetId2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId2()
    {
        return isset($this->TargetId2) ? $this->TargetId2 : null;
    }
    /**
     * Set TargetId2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId2
     * @return \patest\StructType\Sales_GroupedUnpaidItem
     */
    public function setTargetId2($targetId2 = null)
    {
        // validation for constraint: string
        if (!is_null($targetId2) && !is_string($targetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId2, true), gettype($targetId2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetId2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetId2, true)), __LINE__);
        }
        if (is_null($targetId2) || (is_array($targetId2) && empty($targetId2))) {
            unset($this->TargetId2);
        } else {
            $this->TargetId2 = $targetId2;
        }
        return $this;
    }
}
