<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.GeneralFinancialPosting StructType
 * @subpackage Structs
 */
class Sales_GeneralFinancialPosting extends PersistableEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The AmountSign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AmountSign;
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The BusinessDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessDate;
    /**
     * The ErrorType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ErrorType;
    /**
     * The LedgerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LedgerCode;
    /**
     * The OperationDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationDescription;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OriginatorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginatorId;
    /**
     * The ProjectCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProjectCode;
    /**
     * Constructor method for Sales.GeneralFinancialPosting
     * @uses Sales_GeneralFinancialPosting::setAmount()
     * @uses Sales_GeneralFinancialPosting::setAmountSign()
     * @uses Sales_GeneralFinancialPosting::setBatchId()
     * @uses Sales_GeneralFinancialPosting::setBusinessDate()
     * @uses Sales_GeneralFinancialPosting::setErrorType()
     * @uses Sales_GeneralFinancialPosting::setLedgerCode()
     * @uses Sales_GeneralFinancialPosting::setOperationDescription()
     * @uses Sales_GeneralFinancialPosting::setOrganizationUnitId()
     * @uses Sales_GeneralFinancialPosting::setOriginatorId()
     * @uses Sales_GeneralFinancialPosting::setProjectCode()
     * @param \patest\StructType\Money $amount
     * @param int $amountSign
     * @param string $batchId
     * @param string $businessDate
     * @param string[] $errorType
     * @param string $ledgerCode
     * @param string $operationDescription
     * @param string $organizationUnitId
     * @param string $originatorId
     * @param string $projectCode
     */
    public function __construct(\patest\StructType\Money $amount = null, $amountSign = null, $batchId = null, $businessDate = null, array $errorType = array(), $ledgerCode = null, $operationDescription = null, $organizationUnitId = null, $originatorId = null, $projectCode = null)
    {
        $this
            ->setAmount($amount)
            ->setAmountSign($amountSign)
            ->setBatchId($batchId)
            ->setBusinessDate($businessDate)
            ->setErrorType($errorType)
            ->setLedgerCode($ledgerCode)
            ->setOperationDescription($operationDescription)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOriginatorId($originatorId)
            ->setProjectCode($projectCode);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get AmountSign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAmountSign()
    {
        return isset($this->AmountSign) ? $this->AmountSign : null;
    }
    /**
     * Set AmountSign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $amountSign
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setAmountSign($amountSign = null)
    {
        // validation for constraint: int
        if (!is_null($amountSign) && !(is_int($amountSign) || ctype_digit($amountSign))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amountSign, true), gettype($amountSign)), __LINE__);
        }
        if (is_null($amountSign) || (is_array($amountSign) && empty($amountSign))) {
            unset($this->AmountSign);
        } else {
            $this->AmountSign = $amountSign;
        }
        return $this;
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get BusinessDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessDate()
    {
        return isset($this->BusinessDate) ? $this->BusinessDate : null;
    }
    /**
     * Set BusinessDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessDate
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setBusinessDate($businessDate = null)
    {
        // validation for constraint: string
        if (!is_null($businessDate) && !is_string($businessDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessDate, true), gettype($businessDate)), __LINE__);
        }
        if (is_null($businessDate) || (is_array($businessDate) && empty($businessDate))) {
            unset($this->BusinessDate);
        } else {
            $this->BusinessDate = $businessDate;
        }
        return $this;
    }
    /**
     * Get ErrorType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getErrorType()
    {
        return isset($this->ErrorType) ? $this->ErrorType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorTypeForArrayConstraintsFromSetErrorType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sales_GeneralFinancialPostingErrorTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\FinancialPostingErrorType::valueIsValid($sales_GeneralFinancialPostingErrorTypeItem)) {
                $invalidValues[] = is_object($sales_GeneralFinancialPostingErrorTypeItem) ? get_class($sales_GeneralFinancialPostingErrorTypeItem) : sprintf('%s(%s)', gettype($sales_GeneralFinancialPostingErrorTypeItem), var_export($sales_GeneralFinancialPostingErrorTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialPostingErrorType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\FinancialPostingErrorType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ErrorType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialPostingErrorType::valueIsValid()
     * @uses \patest\EnumType\FinancialPostingErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $errorType
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setErrorType(array $errorType = array())
    {
        // validation for constraint: list
        if ('' !== ($errorTypeArrayErrorMessage = self::validateErrorTypeForArrayConstraintsFromSetErrorType($errorType))) {
            throw new \InvalidArgumentException($errorTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($errorType) || (is_array($errorType) && empty($errorType))) {
            unset($this->ErrorType);
        } else {
            $this->ErrorType = is_array($errorType) ? implode(' ', $errorType) : null;
        }
        return $this;
    }
    /**
     * Get LedgerCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerCode()
    {
        return isset($this->LedgerCode) ? $this->LedgerCode : null;
    }
    /**
     * Set LedgerCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerCode
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setLedgerCode($ledgerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerCode) && !is_string($ledgerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerCode, true), gettype($ledgerCode)), __LINE__);
        }
        if (is_null($ledgerCode) || (is_array($ledgerCode) && empty($ledgerCode))) {
            unset($this->LedgerCode);
        } else {
            $this->LedgerCode = $ledgerCode;
        }
        return $this;
    }
    /**
     * Get OperationDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationDescription()
    {
        return isset($this->OperationDescription) ? $this->OperationDescription : null;
    }
    /**
     * Set OperationDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationDescription
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setOperationDescription($operationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($operationDescription) && !is_string($operationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationDescription, true), gettype($operationDescription)), __LINE__);
        }
        if (is_null($operationDescription) || (is_array($operationDescription) && empty($operationDescription))) {
            unset($this->OperationDescription);
        } else {
            $this->OperationDescription = $operationDescription;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OriginatorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorId()
    {
        return isset($this->OriginatorId) ? $this->OriginatorId : null;
    }
    /**
     * Set OriginatorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorId
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setOriginatorId($originatorId = null)
    {
        // validation for constraint: string
        if (!is_null($originatorId) && !is_string($originatorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorId, true), gettype($originatorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originatorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originatorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originatorId, true)), __LINE__);
        }
        if (is_null($originatorId) || (is_array($originatorId) && empty($originatorId))) {
            unset($this->OriginatorId);
        } else {
            $this->OriginatorId = $originatorId;
        }
        return $this;
    }
    /**
     * Get ProjectCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectCode()
    {
        return isset($this->ProjectCode) ? $this->ProjectCode : null;
    }
    /**
     * Set ProjectCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectCode
     * @return \patest\StructType\Sales_GeneralFinancialPosting
     */
    public function setProjectCode($projectCode = null)
    {
        // validation for constraint: string
        if (!is_null($projectCode) && !is_string($projectCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectCode, true), gettype($projectCode)), __LINE__);
        }
        if (is_null($projectCode) || (is_array($projectCode) && empty($projectCode))) {
            unset($this->ProjectCode);
        } else {
            $this->ProjectCode = $projectCode;
        }
        return $this;
    }
}
