<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.FinancialSystemTransaction StructType
 * @subpackage Structs
 */
class Sales_FinancialSystemTransaction extends PersistableEntity
{
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The BusinessCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessCategories;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientLedgerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientLedgerCode;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The ClientProjectCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientProjectCode;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The CompanyCommitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCommitDate;
    /**
     * The Credit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Credit;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Debit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Debit;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EntityId;
    /**
     * The ErrorType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ErrorType;
    /**
     * The GlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalNumber;
    /**
     * The HasErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasErrors;
    /**
     * The IgnoreReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IgnoreReason;
    /**
     * The IsClientAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClientAccount;
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_FinancialSystemPayment
     */
    public $Payments;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier
     */
    public $PriceModifiers;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_FinancialSystemProduct
     */
    public $Products;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The SaleModeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeId;
    /**
     * The SaleModeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleModeName;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointName;
    /**
     * The SiteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SiteId;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteName;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for Sales.FinancialSystemTransaction
     * @uses Sales_FinancialSystemTransaction::setBatchId()
     * @uses Sales_FinancialSystemTransaction::setBusinessCategories()
     * @uses Sales_FinancialSystemTransaction::setClientId()
     * @uses Sales_FinancialSystemTransaction::setClientLedgerCode()
     * @uses Sales_FinancialSystemTransaction::setClientName()
     * @uses Sales_FinancialSystemTransaction::setClientProjectCode()
     * @uses Sales_FinancialSystemTransaction::setCommitDate()
     * @uses Sales_FinancialSystemTransaction::setCompanyCommitDate()
     * @uses Sales_FinancialSystemTransaction::setCredit()
     * @uses Sales_FinancialSystemTransaction::setCrmId()
     * @uses Sales_FinancialSystemTransaction::setCurrencyCode()
     * @uses Sales_FinancialSystemTransaction::setDebit()
     * @uses Sales_FinancialSystemTransaction::setEntityId()
     * @uses Sales_FinancialSystemTransaction::setErrorType()
     * @uses Sales_FinancialSystemTransaction::setGlobalNumber()
     * @uses Sales_FinancialSystemTransaction::setHasErrors()
     * @uses Sales_FinancialSystemTransaction::setIgnoreReason()
     * @uses Sales_FinancialSystemTransaction::setIsClientAccount()
     * @uses Sales_FinancialSystemTransaction::setPayments()
     * @uses Sales_FinancialSystemTransaction::setPriceModifiers()
     * @uses Sales_FinancialSystemTransaction::setProducts()
     * @uses Sales_FinancialSystemTransaction::setReferenceNumber()
     * @uses Sales_FinancialSystemTransaction::setSaleModeId()
     * @uses Sales_FinancialSystemTransaction::setSaleModeName()
     * @uses Sales_FinancialSystemTransaction::setSalePointId()
     * @uses Sales_FinancialSystemTransaction::setSalePointName()
     * @uses Sales_FinancialSystemTransaction::setSiteId()
     * @uses Sales_FinancialSystemTransaction::setSiteName()
     * @uses Sales_FinancialSystemTransaction::setUsername()
     * @param string $batchId
     * @param string $businessCategories
     * @param string $clientId
     * @param string $clientLedgerCode
     * @param string $clientName
     * @param string $clientProjectCode
     * @param string $commitDate
     * @param string $companyCommitDate
     * @param \patest\StructType\Money $credit
     * @param string $crmId
     * @param string $currencyCode
     * @param \patest\StructType\Money $debit
     * @param int $entityId
     * @param string[] $errorType
     * @param int $globalNumber
     * @param bool $hasErrors
     * @param string $ignoreReason
     * @param bool $isClientAccount
     * @param \patest\StructType\RecordSetOfSales_FinancialSystemPayment $payments
     * @param \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier $priceModifiers
     * @param \patest\StructType\RecordSetOfSales_FinancialSystemProduct $products
     * @param int $referenceNumber
     * @param string $saleModeId
     * @param string $saleModeName
     * @param string $salePointId
     * @param string $salePointName
     * @param string $siteId
     * @param string $siteName
     * @param string $username
     */
    public function __construct($batchId = null, $businessCategories = null, $clientId = null, $clientLedgerCode = null, $clientName = null, $clientProjectCode = null, $commitDate = null, $companyCommitDate = null, \patest\StructType\Money $credit = null, $crmId = null, $currencyCode = null, \patest\StructType\Money $debit = null, $entityId = null, array $errorType = array(), $globalNumber = null, $hasErrors = null, $ignoreReason = null, $isClientAccount = null, \patest\StructType\RecordSetOfSales_FinancialSystemPayment $payments = null, \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier $priceModifiers = null, \patest\StructType\RecordSetOfSales_FinancialSystemProduct $products = null, $referenceNumber = null, $saleModeId = null, $saleModeName = null, $salePointId = null, $salePointName = null, $siteId = null, $siteName = null, $username = null)
    {
        $this
            ->setBatchId($batchId)
            ->setBusinessCategories($businessCategories)
            ->setClientId($clientId)
            ->setClientLedgerCode($clientLedgerCode)
            ->setClientName($clientName)
            ->setClientProjectCode($clientProjectCode)
            ->setCommitDate($commitDate)
            ->setCompanyCommitDate($companyCommitDate)
            ->setCredit($credit)
            ->setCrmId($crmId)
            ->setCurrencyCode($currencyCode)
            ->setDebit($debit)
            ->setEntityId($entityId)
            ->setErrorType($errorType)
            ->setGlobalNumber($globalNumber)
            ->setHasErrors($hasErrors)
            ->setIgnoreReason($ignoreReason)
            ->setIsClientAccount($isClientAccount)
            ->setPayments($payments)
            ->setPriceModifiers($priceModifiers)
            ->setProducts($products)
            ->setReferenceNumber($referenceNumber)
            ->setSaleModeId($saleModeId)
            ->setSaleModeName($saleModeName)
            ->setSalePointId($salePointId)
            ->setSalePointName($salePointName)
            ->setSiteId($siteId)
            ->setSiteName($siteName)
            ->setUsername($username);
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get BusinessCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessCategories()
    {
        return isset($this->BusinessCategories) ? $this->BusinessCategories : null;
    }
    /**
     * Set BusinessCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessCategories
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setBusinessCategories($businessCategories = null)
    {
        // validation for constraint: string
        if (!is_null($businessCategories) && !is_string($businessCategories)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessCategories, true), gettype($businessCategories)), __LINE__);
        }
        if (is_null($businessCategories) || (is_array($businessCategories) && empty($businessCategories))) {
            unset($this->BusinessCategories);
        } else {
            $this->BusinessCategories = $businessCategories;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientLedgerCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientLedgerCode()
    {
        return isset($this->ClientLedgerCode) ? $this->ClientLedgerCode : null;
    }
    /**
     * Set ClientLedgerCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientLedgerCode
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setClientLedgerCode($clientLedgerCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientLedgerCode) && !is_string($clientLedgerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientLedgerCode, true), gettype($clientLedgerCode)), __LINE__);
        }
        if (is_null($clientLedgerCode) || (is_array($clientLedgerCode) && empty($clientLedgerCode))) {
            unset($this->ClientLedgerCode);
        } else {
            $this->ClientLedgerCode = $clientLedgerCode;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get ClientProjectCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientProjectCode()
    {
        return isset($this->ClientProjectCode) ? $this->ClientProjectCode : null;
    }
    /**
     * Set ClientProjectCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientProjectCode
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setClientProjectCode($clientProjectCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientProjectCode) && !is_string($clientProjectCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientProjectCode, true), gettype($clientProjectCode)), __LINE__);
        }
        if (is_null($clientProjectCode) || (is_array($clientProjectCode) && empty($clientProjectCode))) {
            unset($this->ClientProjectCode);
        } else {
            $this->ClientProjectCode = $clientProjectCode;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get CompanyCommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCommitDate()
    {
        return isset($this->CompanyCommitDate) ? $this->CompanyCommitDate : null;
    }
    /**
     * Set CompanyCommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCommitDate
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setCompanyCommitDate($companyCommitDate = null)
    {
        // validation for constraint: string
        if (!is_null($companyCommitDate) && !is_string($companyCommitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCommitDate, true), gettype($companyCommitDate)), __LINE__);
        }
        if (is_null($companyCommitDate) || (is_array($companyCommitDate) && empty($companyCommitDate))) {
            unset($this->CompanyCommitDate);
        } else {
            $this->CompanyCommitDate = $companyCommitDate;
        }
        return $this;
    }
    /**
     * Get Credit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCredit()
    {
        return isset($this->Credit) ? $this->Credit : null;
    }
    /**
     * Set Credit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $credit
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setCredit(\patest\StructType\Money $credit = null)
    {
        if (is_null($credit) || (is_array($credit) && empty($credit))) {
            unset($this->Credit);
        } else {
            $this->Credit = $credit;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get Debit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDebit()
    {
        return isset($this->Debit) ? $this->Debit : null;
    }
    /**
     * Set Debit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $debit
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setDebit(\patest\StructType\Money $debit = null)
    {
        if (is_null($debit) || (is_array($debit) && empty($debit))) {
            unset($this->Debit);
        } else {
            $this->Debit = $debit;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $entityId
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get ErrorType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getErrorType()
    {
        return isset($this->ErrorType) ? $this->ErrorType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorTypeForArrayConstraintsFromSetErrorType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sales_FinancialSystemTransactionErrorTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\FinancialSystemTransactionErrorType::valueIsValid($sales_FinancialSystemTransactionErrorTypeItem)) {
                $invalidValues[] = is_object($sales_FinancialSystemTransactionErrorTypeItem) ? get_class($sales_FinancialSystemTransactionErrorTypeItem) : sprintf('%s(%s)', gettype($sales_FinancialSystemTransactionErrorTypeItem), var_export($sales_FinancialSystemTransactionErrorTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialSystemTransactionErrorType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\FinancialSystemTransactionErrorType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ErrorType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialSystemTransactionErrorType::valueIsValid()
     * @uses \patest\EnumType\FinancialSystemTransactionErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $errorType
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setErrorType(array $errorType = array())
    {
        // validation for constraint: list
        if ('' !== ($errorTypeArrayErrorMessage = self::validateErrorTypeForArrayConstraintsFromSetErrorType($errorType))) {
            throw new \InvalidArgumentException($errorTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($errorType) || (is_array($errorType) && empty($errorType))) {
            unset($this->ErrorType);
        } else {
            $this->ErrorType = is_array($errorType) ? implode(' ', $errorType) : null;
        }
        return $this;
    }
    /**
     * Get GlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalNumber()
    {
        return isset($this->GlobalNumber) ? $this->GlobalNumber : null;
    }
    /**
     * Set GlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalNumber
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setGlobalNumber($globalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($globalNumber) && !(is_int($globalNumber) || ctype_digit($globalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalNumber, true), gettype($globalNumber)), __LINE__);
        }
        if (is_null($globalNumber) || (is_array($globalNumber) && empty($globalNumber))) {
            unset($this->GlobalNumber);
        } else {
            $this->GlobalNumber = $globalNumber;
        }
        return $this;
    }
    /**
     * Get HasErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasErrors()
    {
        return isset($this->HasErrors) ? $this->HasErrors : null;
    }
    /**
     * Set HasErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasErrors
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setHasErrors($hasErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasErrors) && !is_bool($hasErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasErrors, true), gettype($hasErrors)), __LINE__);
        }
        if (is_null($hasErrors) || (is_array($hasErrors) && empty($hasErrors))) {
            unset($this->HasErrors);
        } else {
            $this->HasErrors = $hasErrors;
        }
        return $this;
    }
    /**
     * Get IgnoreReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIgnoreReason()
    {
        return isset($this->IgnoreReason) ? $this->IgnoreReason : null;
    }
    /**
     * Set IgnoreReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ignoreReason
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setIgnoreReason($ignoreReason = null)
    {
        // validation for constraint: string
        if (!is_null($ignoreReason) && !is_string($ignoreReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ignoreReason, true), gettype($ignoreReason)), __LINE__);
        }
        if (is_null($ignoreReason) || (is_array($ignoreReason) && empty($ignoreReason))) {
            unset($this->IgnoreReason);
        } else {
            $this->IgnoreReason = $ignoreReason;
        }
        return $this;
    }
    /**
     * Get IsClientAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClientAccount()
    {
        return isset($this->IsClientAccount) ? $this->IsClientAccount : null;
    }
    /**
     * Set IsClientAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClientAccount
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setIsClientAccount($isClientAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClientAccount) && !is_bool($isClientAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClientAccount, true), gettype($isClientAccount)), __LINE__);
        }
        if (is_null($isClientAccount) || (is_array($isClientAccount) && empty($isClientAccount))) {
            unset($this->IsClientAccount);
        } else {
            $this->IsClientAccount = $isClientAccount;
        }
        return $this;
    }
    /**
     * Get Payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_FinancialSystemPayment|null
     */
    public function getPayments()
    {
        return isset($this->Payments) ? $this->Payments : null;
    }
    /**
     * Set Payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_FinancialSystemPayment $payments
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setPayments(\patest\StructType\RecordSetOfSales_FinancialSystemPayment $payments = null)
    {
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->Payments);
        } else {
            $this->Payments = $payments;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier $priceModifiers
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setPriceModifiers(\patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get Products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_FinancialSystemProduct|null
     */
    public function getProducts()
    {
        return isset($this->Products) ? $this->Products : null;
    }
    /**
     * Set Products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_FinancialSystemProduct $products
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setProducts(\patest\StructType\RecordSetOfSales_FinancialSystemProduct $products = null)
    {
        if (is_null($products) || (is_array($products) && empty($products))) {
            unset($this->Products);
        } else {
            $this->Products = $products;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $referenceNumber
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get SaleModeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeId()
    {
        return isset($this->SaleModeId) ? $this->SaleModeId : null;
    }
    /**
     * Set SaleModeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeId
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setSaleModeId($saleModeId = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeId) && !is_string($saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeId, true), gettype($saleModeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeId, true)), __LINE__);
        }
        if (is_null($saleModeId) || (is_array($saleModeId) && empty($saleModeId))) {
            unset($this->SaleModeId);
        } else {
            $this->SaleModeId = $saleModeId;
        }
        return $this;
    }
    /**
     * Get SaleModeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeName()
    {
        return isset($this->SaleModeName) ? $this->SaleModeName : null;
    }
    /**
     * Set SaleModeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeName
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setSaleModeName($saleModeName = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeName) && !is_string($saleModeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeName, true), gettype($saleModeName)), __LINE__);
        }
        if (is_null($saleModeName) || (is_array($saleModeName) && empty($saleModeName))) {
            unset($this->SaleModeName);
        } else {
            $this->SaleModeName = $saleModeName;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointName
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setSalePointName($salePointName = null)
    {
        // validation for constraint: string
        if (!is_null($salePointName) && !is_string($salePointName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointName, true), gettype($salePointName)), __LINE__);
        }
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SiteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteId()
    {
        return isset($this->SiteId) ? $this->SiteId : null;
    }
    /**
     * Set SiteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteId
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: string
        if (!is_null($siteId) && !is_string($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteId, true), gettype($siteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($siteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($siteId, true)), __LINE__);
        }
        if (is_null($siteId) || (is_array($siteId) && empty($siteId))) {
            unset($this->SiteId);
        } else {
            $this->SiteId = $siteId;
        }
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteName
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteName, true), gettype($siteName)), __LINE__);
        }
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \patest\StructType\Sales_FinancialSystemTransaction
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
}
