<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.FinancialSystemPriceModifier StructType
 * @subpackage Structs
 */
class Sales_FinancialSystemPriceModifier extends PersistableEntity
{
    /**
     * The ActualNominalValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ActualNominalValue;
    /**
     * The AmountSign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AmountSign;
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The DefinitionPercentValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DefinitionPercentValue;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EntityId;
    /**
     * The IdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInTransaction;
    /**
     * The IsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncluded;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The LedgerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LedgerCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ParentIdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentIdInTransaction;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier
     */
    public $PriceModifiers;
    /**
     * The ProjectCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProjectCode;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionItemId;
    /**
     * Constructor method for Sales.FinancialSystemPriceModifier
     * @uses Sales_FinancialSystemPriceModifier::setActualNominalValue()
     * @uses Sales_FinancialSystemPriceModifier::setAmountSign()
     * @uses Sales_FinancialSystemPriceModifier::setBatchId()
     * @uses Sales_FinancialSystemPriceModifier::setDefinitionPercentValue()
     * @uses Sales_FinancialSystemPriceModifier::setEntityId()
     * @uses Sales_FinancialSystemPriceModifier::setIdInTransaction()
     * @uses Sales_FinancialSystemPriceModifier::setIsIncluded()
     * @uses Sales_FinancialSystemPriceModifier::setItemType()
     * @uses Sales_FinancialSystemPriceModifier::setLedgerCode()
     * @uses Sales_FinancialSystemPriceModifier::setName()
     * @uses Sales_FinancialSystemPriceModifier::setParentIdInTransaction()
     * @uses Sales_FinancialSystemPriceModifier::setPriceModifiers()
     * @uses Sales_FinancialSystemPriceModifier::setProjectCode()
     * @uses Sales_FinancialSystemPriceModifier::setTransactionId()
     * @uses Sales_FinancialSystemPriceModifier::setTransactionItemId()
     * @param \patest\StructType\Money $actualNominalValue
     * @param int $amountSign
     * @param string $batchId
     * @param float $definitionPercentValue
     * @param int $entityId
     * @param int $idInTransaction
     * @param bool $isIncluded
     * @param int $itemType
     * @param string $ledgerCode
     * @param string $name
     * @param int $parentIdInTransaction
     * @param \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier $priceModifiers
     * @param string $projectCode
     * @param string $transactionId
     * @param string $transactionItemId
     */
    public function __construct(\patest\StructType\Money $actualNominalValue = null, $amountSign = null, $batchId = null, $definitionPercentValue = null, $entityId = null, $idInTransaction = null, $isIncluded = null, $itemType = null, $ledgerCode = null, $name = null, $parentIdInTransaction = null, \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier $priceModifiers = null, $projectCode = null, $transactionId = null, $transactionItemId = null)
    {
        $this
            ->setActualNominalValue($actualNominalValue)
            ->setAmountSign($amountSign)
            ->setBatchId($batchId)
            ->setDefinitionPercentValue($definitionPercentValue)
            ->setEntityId($entityId)
            ->setIdInTransaction($idInTransaction)
            ->setIsIncluded($isIncluded)
            ->setItemType($itemType)
            ->setLedgerCode($ledgerCode)
            ->setName($name)
            ->setParentIdInTransaction($parentIdInTransaction)
            ->setPriceModifiers($priceModifiers)
            ->setProjectCode($projectCode)
            ->setTransactionId($transactionId)
            ->setTransactionItemId($transactionItemId);
    }
    /**
     * Get ActualNominalValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getActualNominalValue()
    {
        return isset($this->ActualNominalValue) ? $this->ActualNominalValue : null;
    }
    /**
     * Set ActualNominalValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $actualNominalValue
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setActualNominalValue(\patest\StructType\Money $actualNominalValue = null)
    {
        if (is_null($actualNominalValue) || (is_array($actualNominalValue) && empty($actualNominalValue))) {
            unset($this->ActualNominalValue);
        } else {
            $this->ActualNominalValue = $actualNominalValue;
        }
        return $this;
    }
    /**
     * Get AmountSign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAmountSign()
    {
        return isset($this->AmountSign) ? $this->AmountSign : null;
    }
    /**
     * Set AmountSign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $amountSign
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setAmountSign($amountSign = null)
    {
        // validation for constraint: int
        if (!is_null($amountSign) && !(is_int($amountSign) || ctype_digit($amountSign))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amountSign, true), gettype($amountSign)), __LINE__);
        }
        if (is_null($amountSign) || (is_array($amountSign) && empty($amountSign))) {
            unset($this->AmountSign);
        } else {
            $this->AmountSign = $amountSign;
        }
        return $this;
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get DefinitionPercentValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDefinitionPercentValue()
    {
        return isset($this->DefinitionPercentValue) ? $this->DefinitionPercentValue : null;
    }
    /**
     * Set DefinitionPercentValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $definitionPercentValue
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setDefinitionPercentValue($definitionPercentValue = null)
    {
        // validation for constraint: float
        if (!is_null($definitionPercentValue) && !(is_float($definitionPercentValue) || is_numeric($definitionPercentValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($definitionPercentValue, true), gettype($definitionPercentValue)), __LINE__);
        }
        if (is_null($definitionPercentValue) || (is_array($definitionPercentValue) && empty($definitionPercentValue))) {
            unset($this->DefinitionPercentValue);
        } else {
            $this->DefinitionPercentValue = $definitionPercentValue;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $entityId
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get IdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInTransaction()
    {
        return isset($this->IdInTransaction) ? $this->IdInTransaction : null;
    }
    /**
     * Set IdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInTransaction
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setIdInTransaction($idInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInTransaction) && !(is_int($idInTransaction) || ctype_digit($idInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInTransaction, true), gettype($idInTransaction)), __LINE__);
        }
        if (is_null($idInTransaction) || (is_array($idInTransaction) && empty($idInTransaction))) {
            unset($this->IdInTransaction);
        } else {
            $this->IdInTransaction = $idInTransaction;
        }
        return $this;
    }
    /**
     * Get IsIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncluded()
    {
        return isset($this->IsIncluded) ? $this->IsIncluded : null;
    }
    /**
     * Set IsIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncluded
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setIsIncluded($isIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncluded) && !is_bool($isIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncluded, true), gettype($isIncluded)), __LINE__);
        }
        if (is_null($isIncluded) || (is_array($isIncluded) && empty($isIncluded))) {
            unset($this->IsIncluded);
        } else {
            $this->IsIncluded = $isIncluded;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LedgerCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerCode()
    {
        return isset($this->LedgerCode) ? $this->LedgerCode : null;
    }
    /**
     * Set LedgerCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerCode
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setLedgerCode($ledgerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerCode) && !is_string($ledgerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerCode, true), gettype($ledgerCode)), __LINE__);
        }
        if (is_null($ledgerCode) || (is_array($ledgerCode) && empty($ledgerCode))) {
            unset($this->LedgerCode);
        } else {
            $this->LedgerCode = $ledgerCode;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ParentIdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentIdInTransaction()
    {
        return isset($this->ParentIdInTransaction) ? $this->ParentIdInTransaction : null;
    }
    /**
     * Set ParentIdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentIdInTransaction
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setParentIdInTransaction($parentIdInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($parentIdInTransaction) && !(is_int($parentIdInTransaction) || ctype_digit($parentIdInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentIdInTransaction, true), gettype($parentIdInTransaction)), __LINE__);
        }
        if (is_null($parentIdInTransaction) || (is_array($parentIdInTransaction) && empty($parentIdInTransaction))) {
            unset($this->ParentIdInTransaction);
        } else {
            $this->ParentIdInTransaction = $parentIdInTransaction;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier $priceModifiers
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setPriceModifiers(\patest\StructType\RecordSetOfSales_FinancialSystemPriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get ProjectCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectCode()
    {
        return isset($this->ProjectCode) ? $this->ProjectCode : null;
    }
    /**
     * Set ProjectCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectCode
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setProjectCode($projectCode = null)
    {
        // validation for constraint: string
        if (!is_null($projectCode) && !is_string($projectCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectCode, true), gettype($projectCode)), __LINE__);
        }
        if (is_null($projectCode) || (is_array($projectCode) && empty($projectCode))) {
            unset($this->ProjectCode);
        } else {
            $this->ProjectCode = $projectCode;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionItemId()
    {
        return isset($this->TransactionItemId) ? $this->TransactionItemId : null;
    }
    /**
     * Set TransactionItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionItemId
     * @return \patest\StructType\Sales_FinancialSystemPriceModifier
     */
    public function setTransactionItemId($transactionItemId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionItemId) && !is_string($transactionItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionItemId, true), gettype($transactionItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionItemId, true)), __LINE__);
        }
        if (is_null($transactionItemId) || (is_array($transactionItemId) && empty($transactionItemId))) {
            unset($this->TransactionItemId);
        } else {
            $this->TransactionItemId = $transactionItemId;
        }
        return $this;
    }
}
