<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.FinancialSystemBatch StructType
 * @subpackage Structs
 */
class Sales_FinancialSystemBatch extends PersistableEntity
{
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ErroneousTransactionsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ErroneousTransactionsCount;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The HasGeneralPostingErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasGeneralPostingErrors;
    /**
     * The HasGeneralPostings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasGeneralPostings;
    /**
     * The IntegrationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntegrationDate;
    /**
     * The IsDraft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDraft;
    /**
     * The IsInProcess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInProcess;
    /**
     * The IsIntegrated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIntegrated;
    /**
     * The IsLockedByAnotherBatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLockedByAnotherBatch;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Number;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The TransactionsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionsCount;
    /**
     * The UnexpectedFailureMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnexpectedFailureMessage;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Sales.FinancialSystemBatch
     * @uses Sales_FinancialSystemBatch::setCreationDate()
     * @uses Sales_FinancialSystemBatch::setErroneousTransactionsCount()
     * @uses Sales_FinancialSystemBatch::setFromDate()
     * @uses Sales_FinancialSystemBatch::setHasGeneralPostingErrors()
     * @uses Sales_FinancialSystemBatch::setHasGeneralPostings()
     * @uses Sales_FinancialSystemBatch::setIntegrationDate()
     * @uses Sales_FinancialSystemBatch::setIsDraft()
     * @uses Sales_FinancialSystemBatch::setIsInProcess()
     * @uses Sales_FinancialSystemBatch::setIsIntegrated()
     * @uses Sales_FinancialSystemBatch::setIsLockedByAnotherBatch()
     * @uses Sales_FinancialSystemBatch::setNumber()
     * @uses Sales_FinancialSystemBatch::setOrganizationUnitId()
     * @uses Sales_FinancialSystemBatch::setToDate()
     * @uses Sales_FinancialSystemBatch::setTransactionsCount()
     * @uses Sales_FinancialSystemBatch::setUnexpectedFailureMessage()
     * @uses Sales_FinancialSystemBatch::setUserId()
     * @param string $creationDate
     * @param int $erroneousTransactionsCount
     * @param string $fromDate
     * @param bool $hasGeneralPostingErrors
     * @param bool $hasGeneralPostings
     * @param string $integrationDate
     * @param bool $isDraft
     * @param bool $isInProcess
     * @param bool $isIntegrated
     * @param bool $isLockedByAnotherBatch
     * @param int $number
     * @param string $organizationUnitId
     * @param string $toDate
     * @param int $transactionsCount
     * @param string $unexpectedFailureMessage
     * @param string $userId
     */
    public function __construct($creationDate = null, $erroneousTransactionsCount = null, $fromDate = null, $hasGeneralPostingErrors = null, $hasGeneralPostings = null, $integrationDate = null, $isDraft = null, $isInProcess = null, $isIntegrated = null, $isLockedByAnotherBatch = null, $number = null, $organizationUnitId = null, $toDate = null, $transactionsCount = null, $unexpectedFailureMessage = null, $userId = null)
    {
        $this
            ->setCreationDate($creationDate)
            ->setErroneousTransactionsCount($erroneousTransactionsCount)
            ->setFromDate($fromDate)
            ->setHasGeneralPostingErrors($hasGeneralPostingErrors)
            ->setHasGeneralPostings($hasGeneralPostings)
            ->setIntegrationDate($integrationDate)
            ->setIsDraft($isDraft)
            ->setIsInProcess($isInProcess)
            ->setIsIntegrated($isIntegrated)
            ->setIsLockedByAnotherBatch($isLockedByAnotherBatch)
            ->setNumber($number)
            ->setOrganizationUnitId($organizationUnitId)
            ->setToDate($toDate)
            ->setTransactionsCount($transactionsCount)
            ->setUnexpectedFailureMessage($unexpectedFailureMessage)
            ->setUserId($userId);
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get ErroneousTransactionsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getErroneousTransactionsCount()
    {
        return isset($this->ErroneousTransactionsCount) ? $this->ErroneousTransactionsCount : null;
    }
    /**
     * Set ErroneousTransactionsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $erroneousTransactionsCount
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setErroneousTransactionsCount($erroneousTransactionsCount = null)
    {
        // validation for constraint: int
        if (!is_null($erroneousTransactionsCount) && !(is_int($erroneousTransactionsCount) || ctype_digit($erroneousTransactionsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($erroneousTransactionsCount, true), gettype($erroneousTransactionsCount)), __LINE__);
        }
        if (is_null($erroneousTransactionsCount) || (is_array($erroneousTransactionsCount) && empty($erroneousTransactionsCount))) {
            unset($this->ErroneousTransactionsCount);
        } else {
            $this->ErroneousTransactionsCount = $erroneousTransactionsCount;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get HasGeneralPostingErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasGeneralPostingErrors()
    {
        return isset($this->HasGeneralPostingErrors) ? $this->HasGeneralPostingErrors : null;
    }
    /**
     * Set HasGeneralPostingErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasGeneralPostingErrors
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setHasGeneralPostingErrors($hasGeneralPostingErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasGeneralPostingErrors) && !is_bool($hasGeneralPostingErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasGeneralPostingErrors, true), gettype($hasGeneralPostingErrors)), __LINE__);
        }
        if (is_null($hasGeneralPostingErrors) || (is_array($hasGeneralPostingErrors) && empty($hasGeneralPostingErrors))) {
            unset($this->HasGeneralPostingErrors);
        } else {
            $this->HasGeneralPostingErrors = $hasGeneralPostingErrors;
        }
        return $this;
    }
    /**
     * Get HasGeneralPostings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasGeneralPostings()
    {
        return isset($this->HasGeneralPostings) ? $this->HasGeneralPostings : null;
    }
    /**
     * Set HasGeneralPostings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasGeneralPostings
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setHasGeneralPostings($hasGeneralPostings = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasGeneralPostings) && !is_bool($hasGeneralPostings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasGeneralPostings, true), gettype($hasGeneralPostings)), __LINE__);
        }
        if (is_null($hasGeneralPostings) || (is_array($hasGeneralPostings) && empty($hasGeneralPostings))) {
            unset($this->HasGeneralPostings);
        } else {
            $this->HasGeneralPostings = $hasGeneralPostings;
        }
        return $this;
    }
    /**
     * Get IntegrationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntegrationDate()
    {
        return isset($this->IntegrationDate) ? $this->IntegrationDate : null;
    }
    /**
     * Set IntegrationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $integrationDate
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setIntegrationDate($integrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($integrationDate) && !is_string($integrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationDate, true), gettype($integrationDate)), __LINE__);
        }
        if (is_null($integrationDate) || (is_array($integrationDate) && empty($integrationDate))) {
            unset($this->IntegrationDate);
        } else {
            $this->IntegrationDate = $integrationDate;
        }
        return $this;
    }
    /**
     * Get IsDraft value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDraft()
    {
        return isset($this->IsDraft) ? $this->IsDraft : null;
    }
    /**
     * Set IsDraft value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDraft
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setIsDraft($isDraft = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDraft) && !is_bool($isDraft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDraft, true), gettype($isDraft)), __LINE__);
        }
        if (is_null($isDraft) || (is_array($isDraft) && empty($isDraft))) {
            unset($this->IsDraft);
        } else {
            $this->IsDraft = $isDraft;
        }
        return $this;
    }
    /**
     * Get IsInProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInProcess()
    {
        return isset($this->IsInProcess) ? $this->IsInProcess : null;
    }
    /**
     * Set IsInProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInProcess
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setIsInProcess($isInProcess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInProcess) && !is_bool($isInProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInProcess, true), gettype($isInProcess)), __LINE__);
        }
        if (is_null($isInProcess) || (is_array($isInProcess) && empty($isInProcess))) {
            unset($this->IsInProcess);
        } else {
            $this->IsInProcess = $isInProcess;
        }
        return $this;
    }
    /**
     * Get IsIntegrated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIntegrated()
    {
        return isset($this->IsIntegrated) ? $this->IsIntegrated : null;
    }
    /**
     * Set IsIntegrated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIntegrated
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setIsIntegrated($isIntegrated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIntegrated) && !is_bool($isIntegrated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIntegrated, true), gettype($isIntegrated)), __LINE__);
        }
        if (is_null($isIntegrated) || (is_array($isIntegrated) && empty($isIntegrated))) {
            unset($this->IsIntegrated);
        } else {
            $this->IsIntegrated = $isIntegrated;
        }
        return $this;
    }
    /**
     * Get IsLockedByAnotherBatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLockedByAnotherBatch()
    {
        return isset($this->IsLockedByAnotherBatch) ? $this->IsLockedByAnotherBatch : null;
    }
    /**
     * Set IsLockedByAnotherBatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLockedByAnotherBatch
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setIsLockedByAnotherBatch($isLockedByAnotherBatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLockedByAnotherBatch) && !is_bool($isLockedByAnotherBatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLockedByAnotherBatch, true), gettype($isLockedByAnotherBatch)), __LINE__);
        }
        if (is_null($isLockedByAnotherBatch) || (is_array($isLockedByAnotherBatch) && empty($isLockedByAnotherBatch))) {
            unset($this->IsLockedByAnotherBatch);
        } else {
            $this->IsLockedByAnotherBatch = $isLockedByAnotherBatch;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $number
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get TransactionsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionsCount()
    {
        return isset($this->TransactionsCount) ? $this->TransactionsCount : null;
    }
    /**
     * Set TransactionsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionsCount
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setTransactionsCount($transactionsCount = null)
    {
        // validation for constraint: int
        if (!is_null($transactionsCount) && !(is_int($transactionsCount) || ctype_digit($transactionsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionsCount, true), gettype($transactionsCount)), __LINE__);
        }
        if (is_null($transactionsCount) || (is_array($transactionsCount) && empty($transactionsCount))) {
            unset($this->TransactionsCount);
        } else {
            $this->TransactionsCount = $transactionsCount;
        }
        return $this;
    }
    /**
     * Get UnexpectedFailureMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnexpectedFailureMessage()
    {
        return isset($this->UnexpectedFailureMessage) ? $this->UnexpectedFailureMessage : null;
    }
    /**
     * Set UnexpectedFailureMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unexpectedFailureMessage
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setUnexpectedFailureMessage($unexpectedFailureMessage = null)
    {
        // validation for constraint: string
        if (!is_null($unexpectedFailureMessage) && !is_string($unexpectedFailureMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unexpectedFailureMessage, true), gettype($unexpectedFailureMessage)), __LINE__);
        }
        if (is_null($unexpectedFailureMessage) || (is_array($unexpectedFailureMessage) && empty($unexpectedFailureMessage))) {
            unset($this->UnexpectedFailureMessage);
        } else {
            $this->UnexpectedFailureMessage = $unexpectedFailureMessage;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Sales_FinancialSystemBatch
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
