<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.FinancialOperation StructType
 * @subpackage Structs
 */
class Sales_FinancialOperation extends PersistableEntity
{
    /**
     * The BusinessDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessDate;
    /**
     * The CreatedByAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreatedByAuditId;
    /**
     * The IsCompleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCompleted;
    /**
     * The OperationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationCode;
    /**
     * The OperationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationDetails;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProcessedByBatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessedByBatchId;
    /**
     * Constructor method for Sales.FinancialOperation
     * @uses Sales_FinancialOperation::setBusinessDate()
     * @uses Sales_FinancialOperation::setCreatedByAuditId()
     * @uses Sales_FinancialOperation::setIsCompleted()
     * @uses Sales_FinancialOperation::setOperationCode()
     * @uses Sales_FinancialOperation::setOperationDetails()
     * @uses Sales_FinancialOperation::setOrganizationUnitId()
     * @uses Sales_FinancialOperation::setProcessedByBatchId()
     * @param string $businessDate
     * @param int $createdByAuditId
     * @param bool $isCompleted
     * @param string $operationCode
     * @param string $operationDetails
     * @param string $organizationUnitId
     * @param string $processedByBatchId
     */
    public function __construct($businessDate = null, $createdByAuditId = null, $isCompleted = null, $operationCode = null, $operationDetails = null, $organizationUnitId = null, $processedByBatchId = null)
    {
        $this
            ->setBusinessDate($businessDate)
            ->setCreatedByAuditId($createdByAuditId)
            ->setIsCompleted($isCompleted)
            ->setOperationCode($operationCode)
            ->setOperationDetails($operationDetails)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProcessedByBatchId($processedByBatchId);
    }
    /**
     * Get BusinessDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessDate()
    {
        return isset($this->BusinessDate) ? $this->BusinessDate : null;
    }
    /**
     * Set BusinessDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessDate
     * @return \patest\StructType\Sales_FinancialOperation
     */
    public function setBusinessDate($businessDate = null)
    {
        // validation for constraint: string
        if (!is_null($businessDate) && !is_string($businessDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessDate, true), gettype($businessDate)), __LINE__);
        }
        if (is_null($businessDate) || (is_array($businessDate) && empty($businessDate))) {
            unset($this->BusinessDate);
        } else {
            $this->BusinessDate = $businessDate;
        }
        return $this;
    }
    /**
     * Get CreatedByAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreatedByAuditId()
    {
        return isset($this->CreatedByAuditId) ? $this->CreatedByAuditId : null;
    }
    /**
     * Set CreatedByAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $createdByAuditId
     * @return \patest\StructType\Sales_FinancialOperation
     */
    public function setCreatedByAuditId($createdByAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($createdByAuditId) && !(is_int($createdByAuditId) || ctype_digit($createdByAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createdByAuditId, true), gettype($createdByAuditId)), __LINE__);
        }
        if (is_null($createdByAuditId) || (is_array($createdByAuditId) && empty($createdByAuditId))) {
            unset($this->CreatedByAuditId);
        } else {
            $this->CreatedByAuditId = $createdByAuditId;
        }
        return $this;
    }
    /**
     * Get IsCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCompleted()
    {
        return isset($this->IsCompleted) ? $this->IsCompleted : null;
    }
    /**
     * Set IsCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCompleted
     * @return \patest\StructType\Sales_FinancialOperation
     */
    public function setIsCompleted($isCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCompleted) && !is_bool($isCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCompleted, true), gettype($isCompleted)), __LINE__);
        }
        if (is_null($isCompleted) || (is_array($isCompleted) && empty($isCompleted))) {
            unset($this->IsCompleted);
        } else {
            $this->IsCompleted = $isCompleted;
        }
        return $this;
    }
    /**
     * Get OperationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationCode()
    {
        return isset($this->OperationCode) ? $this->OperationCode : null;
    }
    /**
     * Set OperationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationCode
     * @return \patest\StructType\Sales_FinancialOperation
     */
    public function setOperationCode($operationCode = null)
    {
        // validation for constraint: string
        if (!is_null($operationCode) && !is_string($operationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationCode, true), gettype($operationCode)), __LINE__);
        }
        if (is_null($operationCode) || (is_array($operationCode) && empty($operationCode))) {
            unset($this->OperationCode);
        } else {
            $this->OperationCode = $operationCode;
        }
        return $this;
    }
    /**
     * Get OperationDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationDetails()
    {
        return isset($this->OperationDetails) ? $this->OperationDetails : null;
    }
    /**
     * Set OperationDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationDetails
     * @return \patest\StructType\Sales_FinancialOperation
     */
    public function setOperationDetails($operationDetails = null)
    {
        // validation for constraint: string
        if (!is_null($operationDetails) && !is_string($operationDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationDetails, true), gettype($operationDetails)), __LINE__);
        }
        if (is_null($operationDetails) || (is_array($operationDetails) && empty($operationDetails))) {
            unset($this->OperationDetails);
        } else {
            $this->OperationDetails = $operationDetails;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_FinancialOperation
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProcessedByBatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedByBatchId()
    {
        return isset($this->ProcessedByBatchId) ? $this->ProcessedByBatchId : null;
    }
    /**
     * Set ProcessedByBatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedByBatchId
     * @return \patest\StructType\Sales_FinancialOperation
     */
    public function setProcessedByBatchId($processedByBatchId = null)
    {
        // validation for constraint: string
        if (!is_null($processedByBatchId) && !is_string($processedByBatchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedByBatchId, true), gettype($processedByBatchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processedByBatchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processedByBatchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processedByBatchId, true)), __LINE__);
        }
        if (is_null($processedByBatchId) || (is_array($processedByBatchId) && empty($processedByBatchId))) {
            unset($this->ProcessedByBatchId);
        } else {
            $this->ProcessedByBatchId = $processedByBatchId;
        }
        return $this;
    }
}
