<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.FinancialJournal StructType
 * @subpackage Structs
 */
class Sales_FinancialJournal extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreditAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CreditAmount;
    /**
     * The CreditAppliedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CreditAppliedAmount;
    /**
     * The CreditKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditKind;
    /**
     * The DateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeUtc;
    /**
     * The DebitAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DebitAmount;
    /**
     * The DebitCommissionsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DebitCommissionsAmount;
    /**
     * The DebitNetCommissionsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DebitNetCommissionsAmount;
    /**
     * The DebitQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DebitQty;
    /**
     * The IsFutureCommitmentRelated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFutureCommitmentRelated;
    /**
     * The LineDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineDescription;
    /**
     * The LineKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineKind;
    /**
     * The OperationElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperationElementId;
    /**
     * The OperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperationId;
    /**
     * The OperationKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationKind;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentId;
    /**
     * The PaymentDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDescription;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDetails;
    /**
     * The PaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentInstallmentsScheduleId;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodName;
    /**
     * The PeerDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeerDescription;
    /**
     * The PeerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PeerId;
    /**
     * The PeerTargetId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PeerTargetId;
    /**
     * The PeerTargetId2
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PeerTargetId2;
    /**
     * The PeerTargetKind
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeerTargetKind;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductName;
    /**
     * The ReconciledPaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReconciledPaymentItemId;
    /**
     * The RelatedLineId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedLineId;
    /**
     * The SeqNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeqNo;
    /**
     * The SubTargetDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubTargetDescription;
    /**
     * The SubTargetDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_AbstractItemDetails
     */
    public $SubTargetDetails;
    /**
     * The SubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubTargetId;
    /**
     * The SubTargetId2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubTargetId2;
    /**
     * The TargetDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetDescription;
    /**
     * The TargetDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_AbstractItemDetails
     */
    public $TargetDetails;
    /**
     * The TargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetId;
    /**
     * The TargetId2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetId2;
    /**
     * The TargetItemType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetItemType;
    /**
     * The TargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetKind;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Sales.FinancialJournal
     * @uses Sales_FinancialJournal::setClientId()
     * @uses Sales_FinancialJournal::setCreditAmount()
     * @uses Sales_FinancialJournal::setCreditAppliedAmount()
     * @uses Sales_FinancialJournal::setCreditKind()
     * @uses Sales_FinancialJournal::setDateTimeUtc()
     * @uses Sales_FinancialJournal::setDebitAmount()
     * @uses Sales_FinancialJournal::setDebitCommissionsAmount()
     * @uses Sales_FinancialJournal::setDebitNetCommissionsAmount()
     * @uses Sales_FinancialJournal::setDebitQty()
     * @uses Sales_FinancialJournal::setIsFutureCommitmentRelated()
     * @uses Sales_FinancialJournal::setLineDescription()
     * @uses Sales_FinancialJournal::setLineKind()
     * @uses Sales_FinancialJournal::setOperationElementId()
     * @uses Sales_FinancialJournal::setOperationId()
     * @uses Sales_FinancialJournal::setOperationKind()
     * @uses Sales_FinancialJournal::setParentId()
     * @uses Sales_FinancialJournal::setPaymentDescription()
     * @uses Sales_FinancialJournal::setPaymentDetails()
     * @uses Sales_FinancialJournal::setPaymentInstallmentsScheduleId()
     * @uses Sales_FinancialJournal::setPaymentItemId()
     * @uses Sales_FinancialJournal::setPaymentMethodId()
     * @uses Sales_FinancialJournal::setPaymentMethodName()
     * @uses Sales_FinancialJournal::setPeerDescription()
     * @uses Sales_FinancialJournal::setPeerId()
     * @uses Sales_FinancialJournal::setPeerTargetId()
     * @uses Sales_FinancialJournal::setPeerTargetId2()
     * @uses Sales_FinancialJournal::setPeerTargetKind()
     * @uses Sales_FinancialJournal::setProductName()
     * @uses Sales_FinancialJournal::setReconciledPaymentItemId()
     * @uses Sales_FinancialJournal::setRelatedLineId()
     * @uses Sales_FinancialJournal::setSeqNo()
     * @uses Sales_FinancialJournal::setSubTargetDescription()
     * @uses Sales_FinancialJournal::setSubTargetDetails()
     * @uses Sales_FinancialJournal::setSubTargetId()
     * @uses Sales_FinancialJournal::setSubTargetId2()
     * @uses Sales_FinancialJournal::setTargetDescription()
     * @uses Sales_FinancialJournal::setTargetDetails()
     * @uses Sales_FinancialJournal::setTargetId()
     * @uses Sales_FinancialJournal::setTargetId2()
     * @uses Sales_FinancialJournal::setTargetItemType()
     * @uses Sales_FinancialJournal::setTargetKind()
     * @uses Sales_FinancialJournal::setTransactionNumber()
     * @param string $clientId
     * @param \patest\StructType\Money $creditAmount
     * @param \patest\StructType\Money $creditAppliedAmount
     * @param string $creditKind
     * @param string $dateTimeUtc
     * @param \patest\StructType\Money $debitAmount
     * @param \patest\StructType\Money $debitCommissionsAmount
     * @param \patest\StructType\Money $debitNetCommissionsAmount
     * @param int $debitQty
     * @param bool $isFutureCommitmentRelated
     * @param string $lineDescription
     * @param string $lineKind
     * @param string $operationElementId
     * @param string $operationId
     * @param string $operationKind
     * @param string $parentId
     * @param string $paymentDescription
     * @param string $paymentDetails
     * @param string $paymentInstallmentsScheduleId
     * @param string $paymentItemId
     * @param string $paymentMethodId
     * @param string $paymentMethodName
     * @param string $peerDescription
     * @param string $peerId
     * @param string $peerTargetId
     * @param string $peerTargetId2
     * @param string $peerTargetKind
     * @param string $productName
     * @param string $reconciledPaymentItemId
     * @param string $relatedLineId
     * @param int $seqNo
     * @param string $subTargetDescription
     * @param \patest\StructType\Sales_AbstractItemDetails $subTargetDetails
     * @param string $subTargetId
     * @param string $subTargetId2
     * @param string $targetDescription
     * @param \patest\StructType\Sales_AbstractItemDetails $targetDetails
     * @param string $targetId
     * @param string $targetId2
     * @param string $targetItemType
     * @param string $targetKind
     * @param int $transactionNumber
     */
    public function __construct($clientId = null, \patest\StructType\Money $creditAmount = null, \patest\StructType\Money $creditAppliedAmount = null, $creditKind = null, $dateTimeUtc = null, \patest\StructType\Money $debitAmount = null, \patest\StructType\Money $debitCommissionsAmount = null, \patest\StructType\Money $debitNetCommissionsAmount = null, $debitQty = null, $isFutureCommitmentRelated = null, $lineDescription = null, $lineKind = null, $operationElementId = null, $operationId = null, $operationKind = null, $parentId = null, $paymentDescription = null, $paymentDetails = null, $paymentInstallmentsScheduleId = null, $paymentItemId = null, $paymentMethodId = null, $paymentMethodName = null, $peerDescription = null, $peerId = null, $peerTargetId = null, $peerTargetId2 = null, $peerTargetKind = null, $productName = null, $reconciledPaymentItemId = null, $relatedLineId = null, $seqNo = null, $subTargetDescription = null, \patest\StructType\Sales_AbstractItemDetails $subTargetDetails = null, $subTargetId = null, $subTargetId2 = null, $targetDescription = null, \patest\StructType\Sales_AbstractItemDetails $targetDetails = null, $targetId = null, $targetId2 = null, $targetItemType = null, $targetKind = null, $transactionNumber = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreditAmount($creditAmount)
            ->setCreditAppliedAmount($creditAppliedAmount)
            ->setCreditKind($creditKind)
            ->setDateTimeUtc($dateTimeUtc)
            ->setDebitAmount($debitAmount)
            ->setDebitCommissionsAmount($debitCommissionsAmount)
            ->setDebitNetCommissionsAmount($debitNetCommissionsAmount)
            ->setDebitQty($debitQty)
            ->setIsFutureCommitmentRelated($isFutureCommitmentRelated)
            ->setLineDescription($lineDescription)
            ->setLineKind($lineKind)
            ->setOperationElementId($operationElementId)
            ->setOperationId($operationId)
            ->setOperationKind($operationKind)
            ->setParentId($parentId)
            ->setPaymentDescription($paymentDescription)
            ->setPaymentDetails($paymentDetails)
            ->setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId)
            ->setPaymentItemId($paymentItemId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodName($paymentMethodName)
            ->setPeerDescription($peerDescription)
            ->setPeerId($peerId)
            ->setPeerTargetId($peerTargetId)
            ->setPeerTargetId2($peerTargetId2)
            ->setPeerTargetKind($peerTargetKind)
            ->setProductName($productName)
            ->setReconciledPaymentItemId($reconciledPaymentItemId)
            ->setRelatedLineId($relatedLineId)
            ->setSeqNo($seqNo)
            ->setSubTargetDescription($subTargetDescription)
            ->setSubTargetDetails($subTargetDetails)
            ->setSubTargetId($subTargetId)
            ->setSubTargetId2($subTargetId2)
            ->setTargetDescription($targetDescription)
            ->setTargetDetails($targetDetails)
            ->setTargetId($targetId)
            ->setTargetId2($targetId2)
            ->setTargetItemType($targetItemType)
            ->setTargetKind($targetKind)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreditAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCreditAmount()
    {
        return isset($this->CreditAmount) ? $this->CreditAmount : null;
    }
    /**
     * Set CreditAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $creditAmount
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setCreditAmount(\patest\StructType\Money $creditAmount = null)
    {
        if (is_null($creditAmount) || (is_array($creditAmount) && empty($creditAmount))) {
            unset($this->CreditAmount);
        } else {
            $this->CreditAmount = $creditAmount;
        }
        return $this;
    }
    /**
     * Get CreditAppliedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCreditAppliedAmount()
    {
        return isset($this->CreditAppliedAmount) ? $this->CreditAppliedAmount : null;
    }
    /**
     * Set CreditAppliedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $creditAppliedAmount
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setCreditAppliedAmount(\patest\StructType\Money $creditAppliedAmount = null)
    {
        if (is_null($creditAppliedAmount) || (is_array($creditAppliedAmount) && empty($creditAppliedAmount))) {
            unset($this->CreditAppliedAmount);
        } else {
            $this->CreditAppliedAmount = $creditAppliedAmount;
        }
        return $this;
    }
    /**
     * Get CreditKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditKind()
    {
        return isset($this->CreditKind) ? $this->CreditKind : null;
    }
    /**
     * Set CreditKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalCreditKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalCreditKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditKind
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setCreditKind($creditKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalCreditKind::valueIsValid($creditKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalCreditKind', is_array($creditKind) ? implode(', ', $creditKind) : var_export($creditKind, true), implode(', ', \patest\EnumType\FinancialJournalCreditKind::getValidValues())), __LINE__);
        }
        if (is_null($creditKind) || (is_array($creditKind) && empty($creditKind))) {
            unset($this->CreditKind);
        } else {
            $this->CreditKind = $creditKind;
        }
        return $this;
    }
    /**
     * Get DateTimeUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeUtc()
    {
        return isset($this->DateTimeUtc) ? $this->DateTimeUtc : null;
    }
    /**
     * Set DateTimeUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeUtc
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setDateTimeUtc($dateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeUtc) && !is_string($dateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeUtc, true), gettype($dateTimeUtc)), __LINE__);
        }
        if (is_null($dateTimeUtc) || (is_array($dateTimeUtc) && empty($dateTimeUtc))) {
            unset($this->DateTimeUtc);
        } else {
            $this->DateTimeUtc = $dateTimeUtc;
        }
        return $this;
    }
    /**
     * Get DebitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDebitAmount()
    {
        return isset($this->DebitAmount) ? $this->DebitAmount : null;
    }
    /**
     * Set DebitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $debitAmount
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setDebitAmount(\patest\StructType\Money $debitAmount = null)
    {
        if (is_null($debitAmount) || (is_array($debitAmount) && empty($debitAmount))) {
            unset($this->DebitAmount);
        } else {
            $this->DebitAmount = $debitAmount;
        }
        return $this;
    }
    /**
     * Get DebitCommissionsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDebitCommissionsAmount()
    {
        return isset($this->DebitCommissionsAmount) ? $this->DebitCommissionsAmount : null;
    }
    /**
     * Set DebitCommissionsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $debitCommissionsAmount
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setDebitCommissionsAmount(\patest\StructType\Money $debitCommissionsAmount = null)
    {
        if (is_null($debitCommissionsAmount) || (is_array($debitCommissionsAmount) && empty($debitCommissionsAmount))) {
            unset($this->DebitCommissionsAmount);
        } else {
            $this->DebitCommissionsAmount = $debitCommissionsAmount;
        }
        return $this;
    }
    /**
     * Get DebitNetCommissionsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDebitNetCommissionsAmount()
    {
        return isset($this->DebitNetCommissionsAmount) ? $this->DebitNetCommissionsAmount : null;
    }
    /**
     * Set DebitNetCommissionsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $debitNetCommissionsAmount
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setDebitNetCommissionsAmount(\patest\StructType\Money $debitNetCommissionsAmount = null)
    {
        if (is_null($debitNetCommissionsAmount) || (is_array($debitNetCommissionsAmount) && empty($debitNetCommissionsAmount))) {
            unset($this->DebitNetCommissionsAmount);
        } else {
            $this->DebitNetCommissionsAmount = $debitNetCommissionsAmount;
        }
        return $this;
    }
    /**
     * Get DebitQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDebitQty()
    {
        return isset($this->DebitQty) ? $this->DebitQty : null;
    }
    /**
     * Set DebitQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $debitQty
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setDebitQty($debitQty = null)
    {
        // validation for constraint: int
        if (!is_null($debitQty) && !(is_int($debitQty) || ctype_digit($debitQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($debitQty, true), gettype($debitQty)), __LINE__);
        }
        if (is_null($debitQty) || (is_array($debitQty) && empty($debitQty))) {
            unset($this->DebitQty);
        } else {
            $this->DebitQty = $debitQty;
        }
        return $this;
    }
    /**
     * Get IsFutureCommitmentRelated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFutureCommitmentRelated()
    {
        return isset($this->IsFutureCommitmentRelated) ? $this->IsFutureCommitmentRelated : null;
    }
    /**
     * Set IsFutureCommitmentRelated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFutureCommitmentRelated
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setIsFutureCommitmentRelated($isFutureCommitmentRelated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFutureCommitmentRelated) && !is_bool($isFutureCommitmentRelated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFutureCommitmentRelated, true), gettype($isFutureCommitmentRelated)), __LINE__);
        }
        if (is_null($isFutureCommitmentRelated) || (is_array($isFutureCommitmentRelated) && empty($isFutureCommitmentRelated))) {
            unset($this->IsFutureCommitmentRelated);
        } else {
            $this->IsFutureCommitmentRelated = $isFutureCommitmentRelated;
        }
        return $this;
    }
    /**
     * Get LineDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineDescription()
    {
        return isset($this->LineDescription) ? $this->LineDescription : null;
    }
    /**
     * Set LineDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lineDescription
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setLineDescription($lineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($lineDescription) && !is_string($lineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineDescription, true), gettype($lineDescription)), __LINE__);
        }
        if (is_null($lineDescription) || (is_array($lineDescription) && empty($lineDescription))) {
            unset($this->LineDescription);
        } else {
            $this->LineDescription = $lineDescription;
        }
        return $this;
    }
    /**
     * Get LineKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineKind()
    {
        return isset($this->LineKind) ? $this->LineKind : null;
    }
    /**
     * Set LineKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalLineKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalLineKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineKind
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setLineKind($lineKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalLineKind::valueIsValid($lineKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalLineKind', is_array($lineKind) ? implode(', ', $lineKind) : var_export($lineKind, true), implode(', ', \patest\EnumType\FinancialJournalLineKind::getValidValues())), __LINE__);
        }
        if (is_null($lineKind) || (is_array($lineKind) && empty($lineKind))) {
            unset($this->LineKind);
        } else {
            $this->LineKind = $lineKind;
        }
        return $this;
    }
    /**
     * Get OperationElementId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationElementId()
    {
        return isset($this->OperationElementId) ? $this->OperationElementId : null;
    }
    /**
     * Set OperationElementId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationElementId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setOperationElementId($operationElementId = null)
    {
        // validation for constraint: string
        if (!is_null($operationElementId) && !is_string($operationElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationElementId, true), gettype($operationElementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($operationElementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operationElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($operationElementId, true)), __LINE__);
        }
        if (is_null($operationElementId) || (is_array($operationElementId) && empty($operationElementId))) {
            unset($this->OperationElementId);
        } else {
            $this->OperationElementId = $operationElementId;
        }
        return $this;
    }
    /**
     * Get OperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationId()
    {
        return isset($this->OperationId) ? $this->OperationId : null;
    }
    /**
     * Set OperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationId, true), gettype($operationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($operationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($operationId, true)), __LINE__);
        }
        if (is_null($operationId) || (is_array($operationId) && empty($operationId))) {
            unset($this->OperationId);
        } else {
            $this->OperationId = $operationId;
        }
        return $this;
    }
    /**
     * Get OperationKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationKind()
    {
        return isset($this->OperationKind) ? $this->OperationKind : null;
    }
    /**
     * Set OperationKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalOperationKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalOperationKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operationKind
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setOperationKind($operationKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalOperationKind::valueIsValid($operationKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalOperationKind', is_array($operationKind) ? implode(', ', $operationKind) : var_export($operationKind, true), implode(', ', \patest\EnumType\FinancialJournalOperationKind::getValidValues())), __LINE__);
        }
        if (is_null($operationKind) || (is_array($operationKind) && empty($operationKind))) {
            unset($this->OperationKind);
        } else {
            $this->OperationKind = $operationKind;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get PaymentDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDescription()
    {
        return isset($this->PaymentDescription) ? $this->PaymentDescription : null;
    }
    /**
     * Set PaymentDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDescription
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPaymentDescription($paymentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDescription) && !is_string($paymentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDescription, true), gettype($paymentDescription)), __LINE__);
        }
        if (is_null($paymentDescription) || (is_array($paymentDescription) && empty($paymentDescription))) {
            unset($this->PaymentDescription);
        } else {
            $this->PaymentDescription = $paymentDescription;
        }
        return $this;
    }
    /**
     * Get PaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return isset($this->PaymentDetails) ? $this->PaymentDetails : null;
    }
    /**
     * Set PaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetails
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        if (is_null($paymentDetails) || (is_array($paymentDetails) && empty($paymentDetails))) {
            unset($this->PaymentDetails);
        } else {
            $this->PaymentDetails = $paymentDetails;
        }
        return $this;
    }
    /**
     * Get PaymentInstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentInstallmentsScheduleId()
    {
        return isset($this->PaymentInstallmentsScheduleId) ? $this->PaymentInstallmentsScheduleId : null;
    }
    /**
     * Set PaymentInstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentInstallmentsScheduleId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstallmentsScheduleId) && !is_string($paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstallmentsScheduleId, true), gettype($paymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentInstallmentsScheduleId, true)), __LINE__);
        }
        if (is_null($paymentInstallmentsScheduleId) || (is_array($paymentInstallmentsScheduleId) && empty($paymentInstallmentsScheduleId))) {
            unset($this->PaymentInstallmentsScheduleId);
        } else {
            $this->PaymentInstallmentsScheduleId = $paymentInstallmentsScheduleId;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodName
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPaymentMethodName($paymentMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodName) && !is_string($paymentMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodName, true), gettype($paymentMethodName)), __LINE__);
        }
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PeerDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeerDescription()
    {
        return isset($this->PeerDescription) ? $this->PeerDescription : null;
    }
    /**
     * Set PeerDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $peerDescription
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPeerDescription($peerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($peerDescription) && !is_string($peerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($peerDescription, true), gettype($peerDescription)), __LINE__);
        }
        if (is_null($peerDescription) || (is_array($peerDescription) && empty($peerDescription))) {
            unset($this->PeerDescription);
        } else {
            $this->PeerDescription = $peerDescription;
        }
        return $this;
    }
    /**
     * Get PeerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeerId()
    {
        return isset($this->PeerId) ? $this->PeerId : null;
    }
    /**
     * Set PeerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $peerId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPeerId($peerId = null)
    {
        // validation for constraint: string
        if (!is_null($peerId) && !is_string($peerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($peerId, true), gettype($peerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($peerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $peerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($peerId, true)), __LINE__);
        }
        if (is_null($peerId) || (is_array($peerId) && empty($peerId))) {
            unset($this->PeerId);
        } else {
            $this->PeerId = $peerId;
        }
        return $this;
    }
    /**
     * Get PeerTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeerTargetId()
    {
        return isset($this->PeerTargetId) ? $this->PeerTargetId : null;
    }
    /**
     * Set PeerTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $peerTargetId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPeerTargetId($peerTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($peerTargetId) && !is_string($peerTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($peerTargetId, true), gettype($peerTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($peerTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $peerTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($peerTargetId, true)), __LINE__);
        }
        if (is_null($peerTargetId) || (is_array($peerTargetId) && empty($peerTargetId))) {
            unset($this->PeerTargetId);
        } else {
            $this->PeerTargetId = $peerTargetId;
        }
        return $this;
    }
    /**
     * Get PeerTargetId2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeerTargetId2()
    {
        return isset($this->PeerTargetId2) ? $this->PeerTargetId2 : null;
    }
    /**
     * Set PeerTargetId2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $peerTargetId2
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPeerTargetId2($peerTargetId2 = null)
    {
        // validation for constraint: string
        if (!is_null($peerTargetId2) && !is_string($peerTargetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($peerTargetId2, true), gettype($peerTargetId2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($peerTargetId2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $peerTargetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($peerTargetId2, true)), __LINE__);
        }
        if (is_null($peerTargetId2) || (is_array($peerTargetId2) && empty($peerTargetId2))) {
            unset($this->PeerTargetId2);
        } else {
            $this->PeerTargetId2 = $peerTargetId2;
        }
        return $this;
    }
    /**
     * Get PeerTargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeerTargetKind()
    {
        return isset($this->PeerTargetKind) ? $this->PeerTargetKind : null;
    }
    /**
     * Set PeerTargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $peerTargetKind
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setPeerTargetKind($peerTargetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($peerTargetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($peerTargetKind) ? implode(', ', $peerTargetKind) : var_export($peerTargetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($peerTargetKind) || (is_array($peerTargetKind) && empty($peerTargetKind))) {
            unset($this->PeerTargetKind);
        } else {
            $this->PeerTargetKind = $peerTargetKind;
        }
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productName
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
    /**
     * Get ReconciledPaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReconciledPaymentItemId()
    {
        return isset($this->ReconciledPaymentItemId) ? $this->ReconciledPaymentItemId : null;
    }
    /**
     * Set ReconciledPaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reconciledPaymentItemId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setReconciledPaymentItemId($reconciledPaymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($reconciledPaymentItemId) && !is_string($reconciledPaymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reconciledPaymentItemId, true), gettype($reconciledPaymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reconciledPaymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reconciledPaymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reconciledPaymentItemId, true)), __LINE__);
        }
        if (is_null($reconciledPaymentItemId) || (is_array($reconciledPaymentItemId) && empty($reconciledPaymentItemId))) {
            unset($this->ReconciledPaymentItemId);
        } else {
            $this->ReconciledPaymentItemId = $reconciledPaymentItemId;
        }
        return $this;
    }
    /**
     * Get RelatedLineId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedLineId()
    {
        return isset($this->RelatedLineId) ? $this->RelatedLineId : null;
    }
    /**
     * Set RelatedLineId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedLineId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setRelatedLineId($relatedLineId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedLineId) && !is_string($relatedLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedLineId, true), gettype($relatedLineId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedLineId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedLineId, true)), __LINE__);
        }
        if (is_null($relatedLineId) || (is_array($relatedLineId) && empty($relatedLineId))) {
            unset($this->RelatedLineId);
        } else {
            $this->RelatedLineId = $relatedLineId;
        }
        return $this;
    }
    /**
     * Get SeqNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeqNo()
    {
        return isset($this->SeqNo) ? $this->SeqNo : null;
    }
    /**
     * Set SeqNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seqNo
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setSeqNo($seqNo = null)
    {
        // validation for constraint: int
        if (!is_null($seqNo) && !(is_int($seqNo) || ctype_digit($seqNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seqNo, true), gettype($seqNo)), __LINE__);
        }
        if (is_null($seqNo) || (is_array($seqNo) && empty($seqNo))) {
            unset($this->SeqNo);
        } else {
            $this->SeqNo = $seqNo;
        }
        return $this;
    }
    /**
     * Get SubTargetDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTargetDescription()
    {
        return isset($this->SubTargetDescription) ? $this->SubTargetDescription : null;
    }
    /**
     * Set SubTargetDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTargetDescription
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setSubTargetDescription($subTargetDescription = null)
    {
        // validation for constraint: string
        if (!is_null($subTargetDescription) && !is_string($subTargetDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTargetDescription, true), gettype($subTargetDescription)), __LINE__);
        }
        if (is_null($subTargetDescription) || (is_array($subTargetDescription) && empty($subTargetDescription))) {
            unset($this->SubTargetDescription);
        } else {
            $this->SubTargetDescription = $subTargetDescription;
        }
        return $this;
    }
    /**
     * Get SubTargetDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_AbstractItemDetails|null
     */
    public function getSubTargetDetails()
    {
        return isset($this->SubTargetDetails) ? $this->SubTargetDetails : null;
    }
    /**
     * Set SubTargetDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_AbstractItemDetails $subTargetDetails
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setSubTargetDetails(\patest\StructType\Sales_AbstractItemDetails $subTargetDetails = null)
    {
        if (is_null($subTargetDetails) || (is_array($subTargetDetails) && empty($subTargetDetails))) {
            unset($this->SubTargetDetails);
        } else {
            $this->SubTargetDetails = $subTargetDetails;
        }
        return $this;
    }
    /**
     * Get SubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTargetId()
    {
        return isset($this->SubTargetId) ? $this->SubTargetId : null;
    }
    /**
     * Set SubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTargetId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setSubTargetId($subTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($subTargetId) && !is_string($subTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTargetId, true), gettype($subTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subTargetId, true)), __LINE__);
        }
        if (is_null($subTargetId) || (is_array($subTargetId) && empty($subTargetId))) {
            unset($this->SubTargetId);
        } else {
            $this->SubTargetId = $subTargetId;
        }
        return $this;
    }
    /**
     * Get SubTargetId2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTargetId2()
    {
        return isset($this->SubTargetId2) ? $this->SubTargetId2 : null;
    }
    /**
     * Set SubTargetId2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTargetId2
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setSubTargetId2($subTargetId2 = null)
    {
        // validation for constraint: string
        if (!is_null($subTargetId2) && !is_string($subTargetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTargetId2, true), gettype($subTargetId2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subTargetId2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subTargetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subTargetId2, true)), __LINE__);
        }
        if (is_null($subTargetId2) || (is_array($subTargetId2) && empty($subTargetId2))) {
            unset($this->SubTargetId2);
        } else {
            $this->SubTargetId2 = $subTargetId2;
        }
        return $this;
    }
    /**
     * Get TargetDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetDescription()
    {
        return isset($this->TargetDescription) ? $this->TargetDescription : null;
    }
    /**
     * Set TargetDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetDescription
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setTargetDescription($targetDescription = null)
    {
        // validation for constraint: string
        if (!is_null($targetDescription) && !is_string($targetDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetDescription, true), gettype($targetDescription)), __LINE__);
        }
        if (is_null($targetDescription) || (is_array($targetDescription) && empty($targetDescription))) {
            unset($this->TargetDescription);
        } else {
            $this->TargetDescription = $targetDescription;
        }
        return $this;
    }
    /**
     * Get TargetDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_AbstractItemDetails|null
     */
    public function getTargetDetails()
    {
        return isset($this->TargetDetails) ? $this->TargetDetails : null;
    }
    /**
     * Set TargetDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_AbstractItemDetails $targetDetails
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setTargetDetails(\patest\StructType\Sales_AbstractItemDetails $targetDetails = null)
    {
        if (is_null($targetDetails) || (is_array($targetDetails) && empty($targetDetails))) {
            unset($this->TargetDetails);
        } else {
            $this->TargetDetails = $targetDetails;
        }
        return $this;
    }
    /**
     * Get TargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId()
    {
        return isset($this->TargetId) ? $this->TargetId : null;
    }
    /**
     * Set TargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setTargetId($targetId = null)
    {
        // validation for constraint: string
        if (!is_null($targetId) && !is_string($targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId, true), gettype($targetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetId, true)), __LINE__);
        }
        if (is_null($targetId) || (is_array($targetId) && empty($targetId))) {
            unset($this->TargetId);
        } else {
            $this->TargetId = $targetId;
        }
        return $this;
    }
    /**
     * Get TargetId2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId2()
    {
        return isset($this->TargetId2) ? $this->TargetId2 : null;
    }
    /**
     * Set TargetId2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId2
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setTargetId2($targetId2 = null)
    {
        // validation for constraint: string
        if (!is_null($targetId2) && !is_string($targetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId2, true), gettype($targetId2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetId2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetId2, true)), __LINE__);
        }
        if (is_null($targetId2) || (is_array($targetId2) && empty($targetId2))) {
            unset($this->TargetId2);
        } else {
            $this->TargetId2 = $targetId2;
        }
        return $this;
    }
    /**
     * Get TargetItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetItemType()
    {
        return isset($this->TargetItemType) ? $this->TargetItemType : null;
    }
    /**
     * Set TargetItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetItemType
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setTargetItemType($targetItemType = null)
    {
        // validation for constraint: string
        if (!is_null($targetItemType) && !is_string($targetItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetItemType, true), gettype($targetItemType)), __LINE__);
        }
        if (is_null($targetItemType) || (is_array($targetItemType) && empty($targetItemType))) {
            unset($this->TargetItemType);
        } else {
            $this->TargetItemType = $targetItemType;
        }
        return $this;
    }
    /**
     * Get TargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetKind()
    {
        return isset($this->TargetKind) ? $this->TargetKind : null;
    }
    /**
     * Set TargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetKind
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setTargetKind($targetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($targetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($targetKind) ? implode(', ', $targetKind) : var_export($targetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($targetKind) || (is_array($targetKind) && empty($targetKind))) {
            unset($this->TargetKind);
        } else {
            $this->TargetKind = $targetKind;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_FinancialJournal
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
