<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.EventPromptElement StructType
 * @subpackage Structs
 */
class Sales_EventPromptElement extends Sales_ProductPromptElement
{
    /**
     * The MinTicketsPerEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinTicketsPerEvent;
    /**
     * Constructor method for Sales.EventPromptElement
     * @uses Sales_EventPromptElement::setMinTicketsPerEvent()
     * @param int $minTicketsPerEvent
     */
    public function __construct($minTicketsPerEvent = null)
    {
        $this
            ->setMinTicketsPerEvent($minTicketsPerEvent);
    }
    /**
     * Get MinTicketsPerEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinTicketsPerEvent()
    {
        return isset($this->MinTicketsPerEvent) ? $this->MinTicketsPerEvent : null;
    }
    /**
     * Set MinTicketsPerEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minTicketsPerEvent
     * @return \patest\StructType\Sales_EventPromptElement
     */
    public function setMinTicketsPerEvent($minTicketsPerEvent = null)
    {
        // validation for constraint: int
        if (!is_null($minTicketsPerEvent) && !(is_int($minTicketsPerEvent) || ctype_digit($minTicketsPerEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTicketsPerEvent, true), gettype($minTicketsPerEvent)), __LINE__);
        }
        if (is_null($minTicketsPerEvent) || (is_array($minTicketsPerEvent) && empty($minTicketsPerEvent))) {
            unset($this->MinTicketsPerEvent);
        } else {
            $this->MinTicketsPerEvent = $minTicketsPerEvent;
        }
        return $this;
    }
}
