<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.DraftInvoiceHistoryFilter StructType
 * @subpackage Structs
 */
class Sales_DraftInvoiceHistoryFilter extends FilterEntity
{
    /**
     * The CreationDateTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTimeFrom;
    /**
     * The CreationDateTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTimeTo;
    /**
     * The CreationUser
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreationUser;
    /**
     * The DraftInvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DraftInvoiceNumber;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The PurposeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurposeId;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Sales.DraftInvoiceHistoryFilter
     * @uses Sales_DraftInvoiceHistoryFilter::setCreationDateTimeFrom()
     * @uses Sales_DraftInvoiceHistoryFilter::setCreationDateTimeTo()
     * @uses Sales_DraftInvoiceHistoryFilter::setCreationUser()
     * @uses Sales_DraftInvoiceHistoryFilter::setDraftInvoiceNumber()
     * @uses Sales_DraftInvoiceHistoryFilter::setIsActive()
     * @uses Sales_DraftInvoiceHistoryFilter::setPurposeId()
     * @uses Sales_DraftInvoiceHistoryFilter::setRemark()
     * @uses Sales_DraftInvoiceHistoryFilter::setStatus()
     * @param string $creationDateTimeFrom
     * @param string $creationDateTimeTo
     * @param string $creationUser
     * @param int $draftInvoiceNumber
     * @param bool $isActive
     * @param string $purposeId
     * @param string $remark
     * @param string $status
     */
    public function __construct($creationDateTimeFrom = null, $creationDateTimeTo = null, $creationUser = null, $draftInvoiceNumber = null, $isActive = null, $purposeId = null, $remark = null, $status = null)
    {
        $this
            ->setCreationDateTimeFrom($creationDateTimeFrom)
            ->setCreationDateTimeTo($creationDateTimeTo)
            ->setCreationUser($creationUser)
            ->setDraftInvoiceNumber($draftInvoiceNumber)
            ->setIsActive($isActive)
            ->setPurposeId($purposeId)
            ->setRemark($remark)
            ->setStatus($status);
    }
    /**
     * Get CreationDateTimeFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTimeFrom()
    {
        return isset($this->CreationDateTimeFrom) ? $this->CreationDateTimeFrom : null;
    }
    /**
     * Set CreationDateTimeFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTimeFrom
     * @return \patest\StructType\Sales_DraftInvoiceHistoryFilter
     */
    public function setCreationDateTimeFrom($creationDateTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTimeFrom) && !is_string($creationDateTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTimeFrom, true), gettype($creationDateTimeFrom)), __LINE__);
        }
        if (is_null($creationDateTimeFrom) || (is_array($creationDateTimeFrom) && empty($creationDateTimeFrom))) {
            unset($this->CreationDateTimeFrom);
        } else {
            $this->CreationDateTimeFrom = $creationDateTimeFrom;
        }
        return $this;
    }
    /**
     * Get CreationDateTimeTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTimeTo()
    {
        return isset($this->CreationDateTimeTo) ? $this->CreationDateTimeTo : null;
    }
    /**
     * Set CreationDateTimeTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTimeTo
     * @return \patest\StructType\Sales_DraftInvoiceHistoryFilter
     */
    public function setCreationDateTimeTo($creationDateTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTimeTo) && !is_string($creationDateTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTimeTo, true), gettype($creationDateTimeTo)), __LINE__);
        }
        if (is_null($creationDateTimeTo) || (is_array($creationDateTimeTo) && empty($creationDateTimeTo))) {
            unset($this->CreationDateTimeTo);
        } else {
            $this->CreationDateTimeTo = $creationDateTimeTo;
        }
        return $this;
    }
    /**
     * Get CreationUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationUser()
    {
        return isset($this->CreationUser) ? $this->CreationUser : null;
    }
    /**
     * Set CreationUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationUser
     * @return \patest\StructType\Sales_DraftInvoiceHistoryFilter
     */
    public function setCreationUser($creationUser = null)
    {
        // validation for constraint: string
        if (!is_null($creationUser) && !is_string($creationUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationUser, true), gettype($creationUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creationUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creationUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creationUser, true)), __LINE__);
        }
        if (is_null($creationUser) || (is_array($creationUser) && empty($creationUser))) {
            unset($this->CreationUser);
        } else {
            $this->CreationUser = $creationUser;
        }
        return $this;
    }
    /**
     * Get DraftInvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDraftInvoiceNumber()
    {
        return isset($this->DraftInvoiceNumber) ? $this->DraftInvoiceNumber : null;
    }
    /**
     * Set DraftInvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $draftInvoiceNumber
     * @return \patest\StructType\Sales_DraftInvoiceHistoryFilter
     */
    public function setDraftInvoiceNumber($draftInvoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($draftInvoiceNumber) && !(is_int($draftInvoiceNumber) || ctype_digit($draftInvoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($draftInvoiceNumber, true), gettype($draftInvoiceNumber)), __LINE__);
        }
        if (is_null($draftInvoiceNumber) || (is_array($draftInvoiceNumber) && empty($draftInvoiceNumber))) {
            unset($this->DraftInvoiceNumber);
        } else {
            $this->DraftInvoiceNumber = $draftInvoiceNumber;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Sales_DraftInvoiceHistoryFilter
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get PurposeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurposeId()
    {
        return isset($this->PurposeId) ? $this->PurposeId : null;
    }
    /**
     * Set PurposeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purposeId
     * @return \patest\StructType\Sales_DraftInvoiceHistoryFilter
     */
    public function setPurposeId($purposeId = null)
    {
        // validation for constraint: string
        if (!is_null($purposeId) && !is_string($purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purposeId, true), gettype($purposeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purposeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purposeId, true)), __LINE__);
        }
        if (is_null($purposeId) || (is_array($purposeId) && empty($purposeId))) {
            unset($this->PurposeId);
        } else {
            $this->PurposeId = $purposeId;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\Sales_DraftInvoiceHistoryFilter
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DraftInvoiceStatus::valueIsValid()
     * @uses \patest\EnumType\DraftInvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Sales_DraftInvoiceHistoryFilter
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DraftInvoiceStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DraftInvoiceStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\DraftInvoiceStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
