<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.DraftInvoiceHistory StructType
 * @subpackage Structs
 */
class Sales_DraftInvoiceHistory extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The DeactivateNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeactivateNote;
    /**
     * The FileData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileData;
    /**
     * The GlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalNumber;
    /**
     * The GroupByFullPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GroupByFullPrice;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_DraftInvoiceItem
     */
    public $Items;
    /**
     * The OriginalDueAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalDueAmount;
    /**
     * The OriginalPaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalPaidAmount;
    /**
     * The OriginalTotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalTotalAmount;
    /**
     * The PurposeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurposeId;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TotalApproximateCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalApproximateCommission;
    /**
     * The TotalItemCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalItemCommissionAmount;
    /**
     * The TotalItemFacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalItemFacePrice;
    /**
     * Constructor method for Sales.DraftInvoiceHistory
     * @uses Sales_DraftInvoiceHistory::setClientId()
     * @uses Sales_DraftInvoiceHistory::setCreationAuditId()
     * @uses Sales_DraftInvoiceHistory::setCreationDateTime()
     * @uses Sales_DraftInvoiceHistory::setDeactivateNote()
     * @uses Sales_DraftInvoiceHistory::setFileData()
     * @uses Sales_DraftInvoiceHistory::setGlobalNumber()
     * @uses Sales_DraftInvoiceHistory::setGroupByFullPrice()
     * @uses Sales_DraftInvoiceHistory::setIsActive()
     * @uses Sales_DraftInvoiceHistory::setItems()
     * @uses Sales_DraftInvoiceHistory::setOriginalDueAmount()
     * @uses Sales_DraftInvoiceHistory::setOriginalPaidAmount()
     * @uses Sales_DraftInvoiceHistory::setOriginalTotalAmount()
     * @uses Sales_DraftInvoiceHistory::setPurposeId()
     * @uses Sales_DraftInvoiceHistory::setRemark()
     * @uses Sales_DraftInvoiceHistory::setStatus()
     * @uses Sales_DraftInvoiceHistory::setTotalApproximateCommission()
     * @uses Sales_DraftInvoiceHistory::setTotalItemCommissionAmount()
     * @uses Sales_DraftInvoiceHistory::setTotalItemFacePrice()
     * @param string $clientId
     * @param int $creationAuditId
     * @param string $creationDateTime
     * @param string $deactivateNote
     * @param string $fileData
     * @param int $globalNumber
     * @param bool $groupByFullPrice
     * @param bool $isActive
     * @param \patest\StructType\RecordSetOfSales_DraftInvoiceItem $items
     * @param \patest\StructType\Money $originalDueAmount
     * @param \patest\StructType\Money $originalPaidAmount
     * @param \patest\StructType\Money $originalTotalAmount
     * @param string $purposeId
     * @param string $remark
     * @param string $status
     * @param \patest\StructType\Money $totalApproximateCommission
     * @param \patest\StructType\Money $totalItemCommissionAmount
     * @param \patest\StructType\Money $totalItemFacePrice
     */
    public function __construct($clientId = null, $creationAuditId = null, $creationDateTime = null, $deactivateNote = null, $fileData = null, $globalNumber = null, $groupByFullPrice = null, $isActive = null, \patest\StructType\RecordSetOfSales_DraftInvoiceItem $items = null, \patest\StructType\Money $originalDueAmount = null, \patest\StructType\Money $originalPaidAmount = null, \patest\StructType\Money $originalTotalAmount = null, $purposeId = null, $remark = null, $status = null, \patest\StructType\Money $totalApproximateCommission = null, \patest\StructType\Money $totalItemCommissionAmount = null, \patest\StructType\Money $totalItemFacePrice = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreationAuditId($creationAuditId)
            ->setCreationDateTime($creationDateTime)
            ->setDeactivateNote($deactivateNote)
            ->setFileData($fileData)
            ->setGlobalNumber($globalNumber)
            ->setGroupByFullPrice($groupByFullPrice)
            ->setIsActive($isActive)
            ->setItems($items)
            ->setOriginalDueAmount($originalDueAmount)
            ->setOriginalPaidAmount($originalPaidAmount)
            ->setOriginalTotalAmount($originalTotalAmount)
            ->setPurposeId($purposeId)
            ->setRemark($remark)
            ->setStatus($status)
            ->setTotalApproximateCommission($totalApproximateCommission)
            ->setTotalItemCommissionAmount($totalItemCommissionAmount)
            ->setTotalItemFacePrice($totalItemFacePrice);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get DeactivateNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeactivateNote()
    {
        return isset($this->DeactivateNote) ? $this->DeactivateNote : null;
    }
    /**
     * Set DeactivateNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deactivateNote
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setDeactivateNote($deactivateNote = null)
    {
        // validation for constraint: string
        if (!is_null($deactivateNote) && !is_string($deactivateNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deactivateNote, true), gettype($deactivateNote)), __LINE__);
        }
        if (is_null($deactivateNote) || (is_array($deactivateNote) && empty($deactivateNote))) {
            unset($this->DeactivateNote);
        } else {
            $this->DeactivateNote = $deactivateNote;
        }
        return $this;
    }
    /**
     * Get FileData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileData()
    {
        return isset($this->FileData) ? $this->FileData : null;
    }
    /**
     * Set FileData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileData
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        if (is_null($fileData) || (is_array($fileData) && empty($fileData))) {
            unset($this->FileData);
        } else {
            $this->FileData = $fileData;
        }
        return $this;
    }
    /**
     * Get GlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalNumber()
    {
        return isset($this->GlobalNumber) ? $this->GlobalNumber : null;
    }
    /**
     * Set GlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalNumber
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setGlobalNumber($globalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($globalNumber) && !(is_int($globalNumber) || ctype_digit($globalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalNumber, true), gettype($globalNumber)), __LINE__);
        }
        if (is_null($globalNumber) || (is_array($globalNumber) && empty($globalNumber))) {
            unset($this->GlobalNumber);
        } else {
            $this->GlobalNumber = $globalNumber;
        }
        return $this;
    }
    /**
     * Get GroupByFullPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGroupByFullPrice()
    {
        return isset($this->GroupByFullPrice) ? $this->GroupByFullPrice : null;
    }
    /**
     * Set GroupByFullPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $groupByFullPrice
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setGroupByFullPrice($groupByFullPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupByFullPrice) && !is_bool($groupByFullPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupByFullPrice, true), gettype($groupByFullPrice)), __LINE__);
        }
        if (is_null($groupByFullPrice) || (is_array($groupByFullPrice) && empty($groupByFullPrice))) {
            unset($this->GroupByFullPrice);
        } else {
            $this->GroupByFullPrice = $groupByFullPrice;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_DraftInvoiceItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_DraftInvoiceItem $items
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setItems(\patest\StructType\RecordSetOfSales_DraftInvoiceItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get OriginalDueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalDueAmount()
    {
        return isset($this->OriginalDueAmount) ? $this->OriginalDueAmount : null;
    }
    /**
     * Set OriginalDueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalDueAmount
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setOriginalDueAmount(\patest\StructType\Money $originalDueAmount = null)
    {
        if (is_null($originalDueAmount) || (is_array($originalDueAmount) && empty($originalDueAmount))) {
            unset($this->OriginalDueAmount);
        } else {
            $this->OriginalDueAmount = $originalDueAmount;
        }
        return $this;
    }
    /**
     * Get OriginalPaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalPaidAmount()
    {
        return isset($this->OriginalPaidAmount) ? $this->OriginalPaidAmount : null;
    }
    /**
     * Set OriginalPaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalPaidAmount
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setOriginalPaidAmount(\patest\StructType\Money $originalPaidAmount = null)
    {
        if (is_null($originalPaidAmount) || (is_array($originalPaidAmount) && empty($originalPaidAmount))) {
            unset($this->OriginalPaidAmount);
        } else {
            $this->OriginalPaidAmount = $originalPaidAmount;
        }
        return $this;
    }
    /**
     * Get OriginalTotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalTotalAmount()
    {
        return isset($this->OriginalTotalAmount) ? $this->OriginalTotalAmount : null;
    }
    /**
     * Set OriginalTotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalTotalAmount
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setOriginalTotalAmount(\patest\StructType\Money $originalTotalAmount = null)
    {
        if (is_null($originalTotalAmount) || (is_array($originalTotalAmount) && empty($originalTotalAmount))) {
            unset($this->OriginalTotalAmount);
        } else {
            $this->OriginalTotalAmount = $originalTotalAmount;
        }
        return $this;
    }
    /**
     * Get PurposeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurposeId()
    {
        return isset($this->PurposeId) ? $this->PurposeId : null;
    }
    /**
     * Set PurposeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purposeId
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setPurposeId($purposeId = null)
    {
        // validation for constraint: string
        if (!is_null($purposeId) && !is_string($purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purposeId, true), gettype($purposeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purposeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purposeId, true)), __LINE__);
        }
        if (is_null($purposeId) || (is_array($purposeId) && empty($purposeId))) {
            unset($this->PurposeId);
        } else {
            $this->PurposeId = $purposeId;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DraftInvoiceStatus::valueIsValid()
     * @uses \patest\EnumType\DraftInvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DraftInvoiceStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DraftInvoiceStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\DraftInvoiceStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalApproximateCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalApproximateCommission()
    {
        return isset($this->TotalApproximateCommission) ? $this->TotalApproximateCommission : null;
    }
    /**
     * Set TotalApproximateCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalApproximateCommission
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setTotalApproximateCommission(\patest\StructType\Money $totalApproximateCommission = null)
    {
        if (is_null($totalApproximateCommission) || (is_array($totalApproximateCommission) && empty($totalApproximateCommission))) {
            unset($this->TotalApproximateCommission);
        } else {
            $this->TotalApproximateCommission = $totalApproximateCommission;
        }
        return $this;
    }
    /**
     * Get TotalItemCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalItemCommissionAmount()
    {
        return isset($this->TotalItemCommissionAmount) ? $this->TotalItemCommissionAmount : null;
    }
    /**
     * Set TotalItemCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalItemCommissionAmount
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setTotalItemCommissionAmount(\patest\StructType\Money $totalItemCommissionAmount = null)
    {
        if (is_null($totalItemCommissionAmount) || (is_array($totalItemCommissionAmount) && empty($totalItemCommissionAmount))) {
            unset($this->TotalItemCommissionAmount);
        } else {
            $this->TotalItemCommissionAmount = $totalItemCommissionAmount;
        }
        return $this;
    }
    /**
     * Get TotalItemFacePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalItemFacePrice()
    {
        return isset($this->TotalItemFacePrice) ? $this->TotalItemFacePrice : null;
    }
    /**
     * Set TotalItemFacePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalItemFacePrice
     * @return \patest\StructType\Sales_DraftInvoiceHistory
     */
    public function setTotalItemFacePrice(\patest\StructType\Money $totalItemFacePrice = null)
    {
        if (is_null($totalItemFacePrice) || (is_array($totalItemFacePrice) && empty($totalItemFacePrice))) {
            unset($this->TotalItemFacePrice);
        } else {
            $this->TotalItemFacePrice = $totalItemFacePrice;
        }
        return $this;
    }
}
