<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.DeductionOperation StructType
 * @subpackage Structs
 */
class Sales_DeductionOperation extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DeductionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeductionAuditId;
    /**
     * The DeductionDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeductionDateTime;
    /**
     * The Deductions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_Deduction
     */
    public $Deductions;
    /**
     * The DepositId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositId;
    /**
     * The LiaStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LiaStatus;
    /**
     * Constructor method for Sales.DeductionOperation
     * @uses Sales_DeductionOperation::setClientId()
     * @uses Sales_DeductionOperation::setDeductionAuditId()
     * @uses Sales_DeductionOperation::setDeductionDateTime()
     * @uses Sales_DeductionOperation::setDeductions()
     * @uses Sales_DeductionOperation::setDepositId()
     * @uses Sales_DeductionOperation::setLiaStatus()
     * @param string $clientId
     * @param int $deductionAuditId
     * @param string $deductionDateTime
     * @param \patest\StructType\RecordSetOfSales_Deduction $deductions
     * @param string $depositId
     * @param string $liaStatus
     */
    public function __construct($clientId = null, $deductionAuditId = null, $deductionDateTime = null, \patest\StructType\RecordSetOfSales_Deduction $deductions = null, $depositId = null, $liaStatus = null)
    {
        $this
            ->setClientId($clientId)
            ->setDeductionAuditId($deductionAuditId)
            ->setDeductionDateTime($deductionDateTime)
            ->setDeductions($deductions)
            ->setDepositId($depositId)
            ->setLiaStatus($liaStatus);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_DeductionOperation
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DeductionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeductionAuditId()
    {
        return isset($this->DeductionAuditId) ? $this->DeductionAuditId : null;
    }
    /**
     * Set DeductionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deductionAuditId
     * @return \patest\StructType\Sales_DeductionOperation
     */
    public function setDeductionAuditId($deductionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($deductionAuditId) && !(is_int($deductionAuditId) || ctype_digit($deductionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deductionAuditId, true), gettype($deductionAuditId)), __LINE__);
        }
        if (is_null($deductionAuditId) || (is_array($deductionAuditId) && empty($deductionAuditId))) {
            unset($this->DeductionAuditId);
        } else {
            $this->DeductionAuditId = $deductionAuditId;
        }
        return $this;
    }
    /**
     * Get DeductionDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeductionDateTime()
    {
        return isset($this->DeductionDateTime) ? $this->DeductionDateTime : null;
    }
    /**
     * Set DeductionDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deductionDateTime
     * @return \patest\StructType\Sales_DeductionOperation
     */
    public function setDeductionDateTime($deductionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($deductionDateTime) && !is_string($deductionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deductionDateTime, true), gettype($deductionDateTime)), __LINE__);
        }
        if (is_null($deductionDateTime) || (is_array($deductionDateTime) && empty($deductionDateTime))) {
            unset($this->DeductionDateTime);
        } else {
            $this->DeductionDateTime = $deductionDateTime;
        }
        return $this;
    }
    /**
     * Get Deductions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_Deduction|null
     */
    public function getDeductions()
    {
        return isset($this->Deductions) ? $this->Deductions : null;
    }
    /**
     * Set Deductions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_Deduction $deductions
     * @return \patest\StructType\Sales_DeductionOperation
     */
    public function setDeductions(\patest\StructType\RecordSetOfSales_Deduction $deductions = null)
    {
        if (is_null($deductions) || (is_array($deductions) && empty($deductions))) {
            unset($this->Deductions);
        } else {
            $this->Deductions = $deductions;
        }
        return $this;
    }
    /**
     * Get DepositId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositId()
    {
        return isset($this->DepositId) ? $this->DepositId : null;
    }
    /**
     * Set DepositId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositId
     * @return \patest\StructType\Sales_DeductionOperation
     */
    public function setDepositId($depositId = null)
    {
        // validation for constraint: string
        if (!is_null($depositId) && !is_string($depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositId, true), gettype($depositId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositId, true)), __LINE__);
        }
        if (is_null($depositId) || (is_array($depositId) && empty($depositId))) {
            unset($this->DepositId);
        } else {
            $this->DepositId = $depositId;
        }
        return $this;
    }
    /**
     * Get LiaStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiaStatus()
    {
        return isset($this->LiaStatus) ? $this->LiaStatus : null;
    }
    /**
     * Set LiaStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BusinessOperationLiaStatus::valueIsValid()
     * @uses \patest\EnumType\BusinessOperationLiaStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $liaStatus
     * @return \patest\StructType\Sales_DeductionOperation
     */
    public function setLiaStatus($liaStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BusinessOperationLiaStatus::valueIsValid($liaStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BusinessOperationLiaStatus', is_array($liaStatus) ? implode(', ', $liaStatus) : var_export($liaStatus, true), implode(', ', \patest\EnumType\BusinessOperationLiaStatus::getValidValues())), __LINE__);
        }
        if (is_null($liaStatus) || (is_array($liaStatus) && empty($liaStatus))) {
            unset($this->LiaStatus);
        } else {
            $this->LiaStatus = $liaStatus;
        }
        return $this;
    }
}
