<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.CombinationElement StructType
 * @subpackage Structs
 */
class Sales_CombinationElement extends PersistableEntity
{
    /**
     * The CombinationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CombinationId;
    /**
     * The ElementTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ElementTypeName;
    /**
     * The Exclusive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Exclusive;
    /**
     * The ExtraDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraDetails;
    /**
     * The IsProductElement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProductElement;
    /**
     * The MaxQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxQuantity;
    /**
     * The MinQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinQuantity;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The RelatedItemTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RelatedItemTypeId;
    /**
     * Constructor method for Sales.CombinationElement
     * @uses Sales_CombinationElement::setCombinationId()
     * @uses Sales_CombinationElement::setElementTypeName()
     * @uses Sales_CombinationElement::setExclusive()
     * @uses Sales_CombinationElement::setExtraDetails()
     * @uses Sales_CombinationElement::setIsProductElement()
     * @uses Sales_CombinationElement::setMaxQuantity()
     * @uses Sales_CombinationElement::setMinQuantity()
     * @uses Sales_CombinationElement::setName()
     * @uses Sales_CombinationElement::setRelatedItemTypeId()
     * @param string $combinationId
     * @param string $elementTypeName
     * @param bool $exclusive
     * @param string $extraDetails
     * @param bool $isProductElement
     * @param int $maxQuantity
     * @param int $minQuantity
     * @param \patest\StructType\GlobalString $name
     * @param int $relatedItemTypeId
     */
    public function __construct($combinationId = null, $elementTypeName = null, $exclusive = null, $extraDetails = null, $isProductElement = null, $maxQuantity = null, $minQuantity = null, \patest\StructType\GlobalString $name = null, $relatedItemTypeId = null)
    {
        $this
            ->setCombinationId($combinationId)
            ->setElementTypeName($elementTypeName)
            ->setExclusive($exclusive)
            ->setExtraDetails($extraDetails)
            ->setIsProductElement($isProductElement)
            ->setMaxQuantity($maxQuantity)
            ->setMinQuantity($minQuantity)
            ->setName($name)
            ->setRelatedItemTypeId($relatedItemTypeId);
    }
    /**
     * Get CombinationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCombinationId()
    {
        return isset($this->CombinationId) ? $this->CombinationId : null;
    }
    /**
     * Set CombinationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $combinationId
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setCombinationId($combinationId = null)
    {
        // validation for constraint: string
        if (!is_null($combinationId) && !is_string($combinationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combinationId, true), gettype($combinationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($combinationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $combinationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($combinationId, true)), __LINE__);
        }
        if (is_null($combinationId) || (is_array($combinationId) && empty($combinationId))) {
            unset($this->CombinationId);
        } else {
            $this->CombinationId = $combinationId;
        }
        return $this;
    }
    /**
     * Get ElementTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getElementTypeName()
    {
        return isset($this->ElementTypeName) ? $this->ElementTypeName : null;
    }
    /**
     * Set ElementTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $elementTypeName
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setElementTypeName($elementTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($elementTypeName) && !is_string($elementTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementTypeName, true), gettype($elementTypeName)), __LINE__);
        }
        if (is_null($elementTypeName) || (is_array($elementTypeName) && empty($elementTypeName))) {
            unset($this->ElementTypeName);
        } else {
            $this->ElementTypeName = $elementTypeName;
        }
        return $this;
    }
    /**
     * Get Exclusive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclusive()
    {
        return isset($this->Exclusive) ? $this->Exclusive : null;
    }
    /**
     * Set Exclusive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclusive
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setExclusive($exclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclusive) && !is_bool($exclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclusive, true), gettype($exclusive)), __LINE__);
        }
        if (is_null($exclusive) || (is_array($exclusive) && empty($exclusive))) {
            unset($this->Exclusive);
        } else {
            $this->Exclusive = $exclusive;
        }
        return $this;
    }
    /**
     * Get ExtraDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraDetails()
    {
        return isset($this->ExtraDetails) ? $this->ExtraDetails : null;
    }
    /**
     * Set ExtraDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraDetails
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setExtraDetails($extraDetails = null)
    {
        // validation for constraint: string
        if (!is_null($extraDetails) && !is_string($extraDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraDetails, true), gettype($extraDetails)), __LINE__);
        }
        if (is_null($extraDetails) || (is_array($extraDetails) && empty($extraDetails))) {
            unset($this->ExtraDetails);
        } else {
            $this->ExtraDetails = $extraDetails;
        }
        return $this;
    }
    /**
     * Get IsProductElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProductElement()
    {
        return isset($this->IsProductElement) ? $this->IsProductElement : null;
    }
    /**
     * Set IsProductElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProductElement
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setIsProductElement($isProductElement = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductElement) && !is_bool($isProductElement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductElement, true), gettype($isProductElement)), __LINE__);
        }
        if (is_null($isProductElement) || (is_array($isProductElement) && empty($isProductElement))) {
            unset($this->IsProductElement);
        } else {
            $this->IsProductElement = $isProductElement;
        }
        return $this;
    }
    /**
     * Get MaxQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxQuantity()
    {
        return isset($this->MaxQuantity) ? $this->MaxQuantity : null;
    }
    /**
     * Set MaxQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxQuantity
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setMaxQuantity($maxQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuantity) && !(is_int($maxQuantity) || ctype_digit($maxQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxQuantity, true), gettype($maxQuantity)), __LINE__);
        }
        if (is_null($maxQuantity) || (is_array($maxQuantity) && empty($maxQuantity))) {
            unset($this->MaxQuantity);
        } else {
            $this->MaxQuantity = $maxQuantity;
        }
        return $this;
    }
    /**
     * Get MinQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinQuantity()
    {
        return isset($this->MinQuantity) ? $this->MinQuantity : null;
    }
    /**
     * Set MinQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minQuantity
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setMinQuantity($minQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($minQuantity) && !(is_int($minQuantity) || ctype_digit($minQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minQuantity, true), gettype($minQuantity)), __LINE__);
        }
        if (is_null($minQuantity) || (is_array($minQuantity) && empty($minQuantity))) {
            unset($this->MinQuantity);
        } else {
            $this->MinQuantity = $minQuantity;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RelatedItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatedItemTypeId()
    {
        return isset($this->RelatedItemTypeId) ? $this->RelatedItemTypeId : null;
    }
    /**
     * Set RelatedItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatedItemTypeId
     * @return \patest\StructType\Sales_CombinationElement
     */
    public function setRelatedItemTypeId($relatedItemTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($relatedItemTypeId) && !(is_int($relatedItemTypeId) || ctype_digit($relatedItemTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatedItemTypeId, true), gettype($relatedItemTypeId)), __LINE__);
        }
        if (is_null($relatedItemTypeId) || (is_array($relatedItemTypeId) && empty($relatedItemTypeId))) {
            unset($this->RelatedItemTypeId);
        } else {
            $this->RelatedItemTypeId = $relatedItemTypeId;
        }
        return $this;
    }
}
