<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.CancellationTransactionBatch StructType
 * @subpackage Structs
 */
class Sales_CancellationTransactionBatch extends PersistableEntity
{
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditId;
    /**
     * The BatchDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchDateTime;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventIds;
    /**
     * The FailedDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_FailedCancellationTransactionDetail
     */
    public $FailedDetails;
    /**
     * The FailedTransactionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedTransactionCount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SuccessDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_SuccessCancellationTransactionDetail
     */
    public $SuccessDetails;
    /**
     * The SuccesTransactionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SuccesTransactionCount;
    /**
     * Constructor method for Sales.CancellationTransactionBatch
     * @uses Sales_CancellationTransactionBatch::setAuditId()
     * @uses Sales_CancellationTransactionBatch::setBatchDateTime()
     * @uses Sales_CancellationTransactionBatch::setEventIds()
     * @uses Sales_CancellationTransactionBatch::setFailedDetails()
     * @uses Sales_CancellationTransactionBatch::setFailedTransactionCount()
     * @uses Sales_CancellationTransactionBatch::setStatus()
     * @uses Sales_CancellationTransactionBatch::setSuccessDetails()
     * @uses Sales_CancellationTransactionBatch::setSuccesTransactionCount()
     * @param int $auditId
     * @param string $batchDateTime
     * @param string $eventIds
     * @param \patest\StructType\RecordSetOfSales_FailedCancellationTransactionDetail $failedDetails
     * @param int $failedTransactionCount
     * @param string $status
     * @param \patest\StructType\RecordSetOfSales_SuccessCancellationTransactionDetail $successDetails
     * @param int $succesTransactionCount
     */
    public function __construct($auditId = null, $batchDateTime = null, $eventIds = null, \patest\StructType\RecordSetOfSales_FailedCancellationTransactionDetail $failedDetails = null, $failedTransactionCount = null, $status = null, \patest\StructType\RecordSetOfSales_SuccessCancellationTransactionDetail $successDetails = null, $succesTransactionCount = null)
    {
        $this
            ->setAuditId($auditId)
            ->setBatchDateTime($batchDateTime)
            ->setEventIds($eventIds)
            ->setFailedDetails($failedDetails)
            ->setFailedTransactionCount($failedTransactionCount)
            ->setStatus($status)
            ->setSuccessDetails($successDetails)
            ->setSuccesTransactionCount($succesTransactionCount);
    }
    /**
     * Get AuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditId()
    {
        return isset($this->AuditId) ? $this->AuditId : null;
    }
    /**
     * Set AuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditId
     * @return \patest\StructType\Sales_CancellationTransactionBatch
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        if (is_null($auditId) || (is_array($auditId) && empty($auditId))) {
            unset($this->AuditId);
        } else {
            $this->AuditId = $auditId;
        }
        return $this;
    }
    /**
     * Get BatchDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchDateTime()
    {
        return isset($this->BatchDateTime) ? $this->BatchDateTime : null;
    }
    /**
     * Set BatchDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchDateTime
     * @return \patest\StructType\Sales_CancellationTransactionBatch
     */
    public function setBatchDateTime($batchDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($batchDateTime) && !is_string($batchDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchDateTime, true), gettype($batchDateTime)), __LINE__);
        }
        if (is_null($batchDateTime) || (is_array($batchDateTime) && empty($batchDateTime))) {
            unset($this->BatchDateTime);
        } else {
            $this->BatchDateTime = $batchDateTime;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventIds
     * @return \patest\StructType\Sales_CancellationTransactionBatch
     */
    public function setEventIds($eventIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventIds) && !is_string($eventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventIds, true), gettype($eventIds)), __LINE__);
        }
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get FailedDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_FailedCancellationTransactionDetail|null
     */
    public function getFailedDetails()
    {
        return isset($this->FailedDetails) ? $this->FailedDetails : null;
    }
    /**
     * Set FailedDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_FailedCancellationTransactionDetail $failedDetails
     * @return \patest\StructType\Sales_CancellationTransactionBatch
     */
    public function setFailedDetails(\patest\StructType\RecordSetOfSales_FailedCancellationTransactionDetail $failedDetails = null)
    {
        if (is_null($failedDetails) || (is_array($failedDetails) && empty($failedDetails))) {
            unset($this->FailedDetails);
        } else {
            $this->FailedDetails = $failedDetails;
        }
        return $this;
    }
    /**
     * Get FailedTransactionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedTransactionCount()
    {
        return isset($this->FailedTransactionCount) ? $this->FailedTransactionCount : null;
    }
    /**
     * Set FailedTransactionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedTransactionCount
     * @return \patest\StructType\Sales_CancellationTransactionBatch
     */
    public function setFailedTransactionCount($failedTransactionCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedTransactionCount) && !(is_int($failedTransactionCount) || ctype_digit($failedTransactionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedTransactionCount, true), gettype($failedTransactionCount)), __LINE__);
        }
        if (is_null($failedTransactionCount) || (is_array($failedTransactionCount) && empty($failedTransactionCount))) {
            unset($this->FailedTransactionCount);
        } else {
            $this->FailedTransactionCount = $failedTransactionCount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CancellationTransactionBatchStatus::valueIsValid()
     * @uses \patest\EnumType\CancellationTransactionBatchStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Sales_CancellationTransactionBatch
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CancellationTransactionBatchStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CancellationTransactionBatchStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\CancellationTransactionBatchStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SuccessDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_SuccessCancellationTransactionDetail|null
     */
    public function getSuccessDetails()
    {
        return isset($this->SuccessDetails) ? $this->SuccessDetails : null;
    }
    /**
     * Set SuccessDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_SuccessCancellationTransactionDetail $successDetails
     * @return \patest\StructType\Sales_CancellationTransactionBatch
     */
    public function setSuccessDetails(\patest\StructType\RecordSetOfSales_SuccessCancellationTransactionDetail $successDetails = null)
    {
        if (is_null($successDetails) || (is_array($successDetails) && empty($successDetails))) {
            unset($this->SuccessDetails);
        } else {
            $this->SuccessDetails = $successDetails;
        }
        return $this;
    }
    /**
     * Get SuccesTransactionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuccesTransactionCount()
    {
        return isset($this->SuccesTransactionCount) ? $this->SuccesTransactionCount : null;
    }
    /**
     * Set SuccesTransactionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $succesTransactionCount
     * @return \patest\StructType\Sales_CancellationTransactionBatch
     */
    public function setSuccesTransactionCount($succesTransactionCount = null)
    {
        // validation for constraint: int
        if (!is_null($succesTransactionCount) && !(is_int($succesTransactionCount) || ctype_digit($succesTransactionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($succesTransactionCount, true), gettype($succesTransactionCount)), __LINE__);
        }
        if (is_null($succesTransactionCount) || (is_array($succesTransactionCount) && empty($succesTransactionCount))) {
            unset($this->SuccesTransactionCount);
        } else {
            $this->SuccesTransactionCount = $succesTransactionCount;
        }
        return $this;
    }
}
