<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.CancellationCandidateTransaction StructType
 * @subpackage Structs
 */
class Sales_CancellationCandidateTransaction extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IssuerTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IssuerTenantId;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_CancellationCandidateItem
     */
    public $Items;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Sales.CancellationCandidateTransaction
     * @uses Sales_CancellationCandidateTransaction::setClientId()
     * @uses Sales_CancellationCandidateTransaction::setEventIds()
     * @uses Sales_CancellationCandidateTransaction::setHolderTenantId()
     * @uses Sales_CancellationCandidateTransaction::setId()
     * @uses Sales_CancellationCandidateTransaction::setIssuerTenantId()
     * @uses Sales_CancellationCandidateTransaction::setItems()
     * @uses Sales_CancellationCandidateTransaction::setLocalId()
     * @uses Sales_CancellationCandidateTransaction::setState()
     * @uses Sales_CancellationCandidateTransaction::setTransactionNumber()
     * @param string $clientId
     * @param \patest\StructType\EventIds $eventIds
     * @param int $holderTenantId
     * @param string $id
     * @param int $issuerTenantId
     * @param \patest\StructType\RecordSetOfSales_CancellationCandidateItem $items
     * @param int $localId
     * @param string $state
     * @param int $transactionNumber
     */
    public function __construct($clientId = null, \patest\StructType\EventIds $eventIds = null, $holderTenantId = null, $id = null, $issuerTenantId = null, \patest\StructType\RecordSetOfSales_CancellationCandidateItem $items = null, $localId = null, $state = null, $transactionNumber = null)
    {
        $this
            ->setClientId($clientId)
            ->setEventIds($eventIds)
            ->setHolderTenantId($holderTenantId)
            ->setId($id)
            ->setIssuerTenantId($issuerTenantId)
            ->setItems($items)
            ->setLocalId($localId)
            ->setState($state)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IssuerTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIssuerTenantId()
    {
        return isset($this->IssuerTenantId) ? $this->IssuerTenantId : null;
    }
    /**
     * Set IssuerTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $issuerTenantId
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setIssuerTenantId($issuerTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerTenantId) && !(is_int($issuerTenantId) || ctype_digit($issuerTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerTenantId, true), gettype($issuerTenantId)), __LINE__);
        }
        if (is_null($issuerTenantId) || (is_array($issuerTenantId) && empty($issuerTenantId))) {
            unset($this->IssuerTenantId);
        } else {
            $this->IssuerTenantId = $issuerTenantId;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_CancellationCandidateItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_CancellationCandidateItem $items
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setItems(\patest\StructType\RecordSetOfSales_CancellationCandidateItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionState::valueIsValid()
     * @uses \patest\EnumType\TransactionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\TransactionState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_CancellationCandidateTransaction
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
