<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.BundlePriceTypeEntry StructType
 * @subpackage Structs
 */
class Sales_BundlePriceTypeEntry extends PersistableEntity
{
    /**
     * The ActualPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActualPriceTypeId;
    /**
     * The ActualPriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ActualPriceTypeName;
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleId;
    /**
     * The FromPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FromPrice;
    /**
     * The NewPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceTypeId;
    /**
     * The NewPriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $NewPriceTypeName;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The ToPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ToPrice;
    /**
     * Constructor method for Sales.BundlePriceTypeEntry
     * @uses Sales_BundlePriceTypeEntry::setActualPriceTypeId()
     * @uses Sales_BundlePriceTypeEntry::setActualPriceTypeName()
     * @uses Sales_BundlePriceTypeEntry::setBundleId()
     * @uses Sales_BundlePriceTypeEntry::setFromPrice()
     * @uses Sales_BundlePriceTypeEntry::setNewPriceTypeId()
     * @uses Sales_BundlePriceTypeEntry::setNewPriceTypeName()
     * @uses Sales_BundlePriceTypeEntry::setPriority()
     * @uses Sales_BundlePriceTypeEntry::setToPrice()
     * @param string $actualPriceTypeId
     * @param \patest\StructType\GlobalString $actualPriceTypeName
     * @param string $bundleId
     * @param \patest\StructType\Money $fromPrice
     * @param string $newPriceTypeId
     * @param \patest\StructType\GlobalString $newPriceTypeName
     * @param int $priority
     * @param \patest\StructType\Money $toPrice
     */
    public function __construct($actualPriceTypeId = null, \patest\StructType\GlobalString $actualPriceTypeName = null, $bundleId = null, \patest\StructType\Money $fromPrice = null, $newPriceTypeId = null, \patest\StructType\GlobalString $newPriceTypeName = null, $priority = null, \patest\StructType\Money $toPrice = null)
    {
        $this
            ->setActualPriceTypeId($actualPriceTypeId)
            ->setActualPriceTypeName($actualPriceTypeName)
            ->setBundleId($bundleId)
            ->setFromPrice($fromPrice)
            ->setNewPriceTypeId($newPriceTypeId)
            ->setNewPriceTypeName($newPriceTypeName)
            ->setPriority($priority)
            ->setToPrice($toPrice);
    }
    /**
     * Get ActualPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActualPriceTypeId()
    {
        return isset($this->ActualPriceTypeId) ? $this->ActualPriceTypeId : null;
    }
    /**
     * Set ActualPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actualPriceTypeId
     * @return \patest\StructType\Sales_BundlePriceTypeEntry
     */
    public function setActualPriceTypeId($actualPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($actualPriceTypeId) && !is_string($actualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualPriceTypeId, true), gettype($actualPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($actualPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $actualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($actualPriceTypeId, true)), __LINE__);
        }
        if (is_null($actualPriceTypeId) || (is_array($actualPriceTypeId) && empty($actualPriceTypeId))) {
            unset($this->ActualPriceTypeId);
        } else {
            $this->ActualPriceTypeId = $actualPriceTypeId;
        }
        return $this;
    }
    /**
     * Get ActualPriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getActualPriceTypeName()
    {
        return isset($this->ActualPriceTypeName) ? $this->ActualPriceTypeName : null;
    }
    /**
     * Set ActualPriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $actualPriceTypeName
     * @return \patest\StructType\Sales_BundlePriceTypeEntry
     */
    public function setActualPriceTypeName(\patest\StructType\GlobalString $actualPriceTypeName = null)
    {
        if (is_null($actualPriceTypeName) || (is_array($actualPriceTypeName) && empty($actualPriceTypeName))) {
            unset($this->ActualPriceTypeName);
        } else {
            $this->ActualPriceTypeName = $actualPriceTypeName;
        }
        return $this;
    }
    /**
     * Get BundleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleId()
    {
        return isset($this->BundleId) ? $this->BundleId : null;
    }
    /**
     * Set BundleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleId
     * @return \patest\StructType\Sales_BundlePriceTypeEntry
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleId) && !is_string($bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleId, true)), __LINE__);
        }
        if (is_null($bundleId) || (is_array($bundleId) && empty($bundleId))) {
            unset($this->BundleId);
        } else {
            $this->BundleId = $bundleId;
        }
        return $this;
    }
    /**
     * Get FromPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFromPrice()
    {
        return isset($this->FromPrice) ? $this->FromPrice : null;
    }
    /**
     * Set FromPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $fromPrice
     * @return \patest\StructType\Sales_BundlePriceTypeEntry
     */
    public function setFromPrice(\patest\StructType\Money $fromPrice = null)
    {
        if (is_null($fromPrice) || (is_array($fromPrice) && empty($fromPrice))) {
            unset($this->FromPrice);
        } else {
            $this->FromPrice = $fromPrice;
        }
        return $this;
    }
    /**
     * Get NewPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceTypeId()
    {
        return isset($this->NewPriceTypeId) ? $this->NewPriceTypeId : null;
    }
    /**
     * Set NewPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceTypeId
     * @return \patest\StructType\Sales_BundlePriceTypeEntry
     */
    public function setNewPriceTypeId($newPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceTypeId) && !is_string($newPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceTypeId, true), gettype($newPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceTypeId, true)), __LINE__);
        }
        if (is_null($newPriceTypeId) || (is_array($newPriceTypeId) && empty($newPriceTypeId))) {
            unset($this->NewPriceTypeId);
        } else {
            $this->NewPriceTypeId = $newPriceTypeId;
        }
        return $this;
    }
    /**
     * Get NewPriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNewPriceTypeName()
    {
        return isset($this->NewPriceTypeName) ? $this->NewPriceTypeName : null;
    }
    /**
     * Set NewPriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $newPriceTypeName
     * @return \patest\StructType\Sales_BundlePriceTypeEntry
     */
    public function setNewPriceTypeName(\patest\StructType\GlobalString $newPriceTypeName = null)
    {
        if (is_null($newPriceTypeName) || (is_array($newPriceTypeName) && empty($newPriceTypeName))) {
            unset($this->NewPriceTypeName);
        } else {
            $this->NewPriceTypeName = $newPriceTypeName;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Sales_BundlePriceTypeEntry
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ToPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getToPrice()
    {
        return isset($this->ToPrice) ? $this->ToPrice : null;
    }
    /**
     * Set ToPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $toPrice
     * @return \patest\StructType\Sales_BundlePriceTypeEntry
     */
    public function setToPrice(\patest\StructType\Money $toPrice = null)
    {
        if (is_null($toPrice) || (is_array($toPrice) && empty($toPrice))) {
            unset($this->ToPrice);
        } else {
            $this->ToPrice = $toPrice;
        }
        return $this;
    }
}
