<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.BenefitPackageElement StructType
 * @subpackage Structs
 */
class Sales_BenefitPackageElement extends PersistableEntity
{
    /**
     * The BenefitDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BenefitDescription;
    /**
     * The BenefitPackageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitPackageId;
    /**
     * The BenefitType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BenefitType;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The MaxQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxQuantity;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * Constructor method for Sales.BenefitPackageElement
     * @uses Sales_BenefitPackageElement::setBenefitDescription()
     * @uses Sales_BenefitPackageElement::setBenefitPackageId()
     * @uses Sales_BenefitPackageElement::setBenefitType()
     * @uses Sales_BenefitPackageElement::setIsActive()
     * @uses Sales_BenefitPackageElement::setMaxQuantity()
     * @uses Sales_BenefitPackageElement::setName()
     * @uses Sales_BenefitPackageElement::setPriority()
     * @param string $benefitDescription
     * @param string $benefitPackageId
     * @param string $benefitType
     * @param bool $isActive
     * @param int $maxQuantity
     * @param \patest\StructType\GlobalString $name
     * @param int $priority
     */
    public function __construct($benefitDescription = null, $benefitPackageId = null, $benefitType = null, $isActive = null, $maxQuantity = null, \patest\StructType\GlobalString $name = null, $priority = null)
    {
        $this
            ->setBenefitDescription($benefitDescription)
            ->setBenefitPackageId($benefitPackageId)
            ->setBenefitType($benefitType)
            ->setIsActive($isActive)
            ->setMaxQuantity($maxQuantity)
            ->setName($name)
            ->setPriority($priority);
    }
    /**
     * Get BenefitDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitDescription()
    {
        return isset($this->BenefitDescription) ? $this->BenefitDescription : null;
    }
    /**
     * Set BenefitDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitDescription
     * @return \patest\StructType\Sales_BenefitPackageElement
     */
    public function setBenefitDescription($benefitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($benefitDescription) && !is_string($benefitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitDescription, true), gettype($benefitDescription)), __LINE__);
        }
        if (is_null($benefitDescription) || (is_array($benefitDescription) && empty($benefitDescription))) {
            unset($this->BenefitDescription);
        } else {
            $this->BenefitDescription = $benefitDescription;
        }
        return $this;
    }
    /**
     * Get BenefitPackageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitPackageId()
    {
        return isset($this->BenefitPackageId) ? $this->BenefitPackageId : null;
    }
    /**
     * Set BenefitPackageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitPackageId
     * @return \patest\StructType\Sales_BenefitPackageElement
     */
    public function setBenefitPackageId($benefitPackageId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitPackageId) && !is_string($benefitPackageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitPackageId, true), gettype($benefitPackageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitPackageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitPackageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitPackageId, true)), __LINE__);
        }
        if (is_null($benefitPackageId) || (is_array($benefitPackageId) && empty($benefitPackageId))) {
            unset($this->BenefitPackageId);
        } else {
            $this->BenefitPackageId = $benefitPackageId;
        }
        return $this;
    }
    /**
     * Get BenefitType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitType()
    {
        return isset($this->BenefitType) ? $this->BenefitType : null;
    }
    /**
     * Set BenefitType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BenefitType::valueIsValid()
     * @uses \patest\EnumType\BenefitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $benefitType
     * @return \patest\StructType\Sales_BenefitPackageElement
     */
    public function setBenefitType($benefitType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BenefitType::valueIsValid($benefitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BenefitType', is_array($benefitType) ? implode(', ', $benefitType) : var_export($benefitType, true), implode(', ', \patest\EnumType\BenefitType::getValidValues())), __LINE__);
        }
        if (is_null($benefitType) || (is_array($benefitType) && empty($benefitType))) {
            unset($this->BenefitType);
        } else {
            $this->BenefitType = $benefitType;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Sales_BenefitPackageElement
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get MaxQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxQuantity()
    {
        return isset($this->MaxQuantity) ? $this->MaxQuantity : null;
    }
    /**
     * Set MaxQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxQuantity
     * @return \patest\StructType\Sales_BenefitPackageElement
     */
    public function setMaxQuantity($maxQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuantity) && !(is_int($maxQuantity) || ctype_digit($maxQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxQuantity, true), gettype($maxQuantity)), __LINE__);
        }
        if (is_null($maxQuantity) || (is_array($maxQuantity) && empty($maxQuantity))) {
            unset($this->MaxQuantity);
        } else {
            $this->MaxQuantity = $maxQuantity;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_BenefitPackageElement
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Sales_BenefitPackageElement
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
}
