<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.AccountingJournalStatus StructType
 * @subpackage Structs
 */
class Sales_AccountingJournalStatus extends AnyEntity
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The FailedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedCount;
    /**
     * The PendingCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PendingCount;
    /**
     * The SuccessCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SuccessCount;
    /**
     * The TransactionsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionsCount;
    /**
     * Constructor method for Sales.AccountingJournalStatus
     * @uses Sales_AccountingJournalStatus::setDate()
     * @uses Sales_AccountingJournalStatus::setFailedCount()
     * @uses Sales_AccountingJournalStatus::setPendingCount()
     * @uses Sales_AccountingJournalStatus::setSuccessCount()
     * @uses Sales_AccountingJournalStatus::setTransactionsCount()
     * @param string $date
     * @param int $failedCount
     * @param int $pendingCount
     * @param int $successCount
     * @param int $transactionsCount
     */
    public function __construct($date = null, $failedCount = null, $pendingCount = null, $successCount = null, $transactionsCount = null)
    {
        $this
            ->setDate($date)
            ->setFailedCount($failedCount)
            ->setPendingCount($pendingCount)
            ->setSuccessCount($successCount)
            ->setTransactionsCount($transactionsCount);
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Sales_AccountingJournalStatus
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get FailedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedCount()
    {
        return isset($this->FailedCount) ? $this->FailedCount : null;
    }
    /**
     * Set FailedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedCount
     * @return \patest\StructType\Sales_AccountingJournalStatus
     */
    public function setFailedCount($failedCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedCount) && !(is_int($failedCount) || ctype_digit($failedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedCount, true), gettype($failedCount)), __LINE__);
        }
        if (is_null($failedCount) || (is_array($failedCount) && empty($failedCount))) {
            unset($this->FailedCount);
        } else {
            $this->FailedCount = $failedCount;
        }
        return $this;
    }
    /**
     * Get PendingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPendingCount()
    {
        return isset($this->PendingCount) ? $this->PendingCount : null;
    }
    /**
     * Set PendingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pendingCount
     * @return \patest\StructType\Sales_AccountingJournalStatus
     */
    public function setPendingCount($pendingCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingCount) && !(is_int($pendingCount) || ctype_digit($pendingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingCount, true), gettype($pendingCount)), __LINE__);
        }
        if (is_null($pendingCount) || (is_array($pendingCount) && empty($pendingCount))) {
            unset($this->PendingCount);
        } else {
            $this->PendingCount = $pendingCount;
        }
        return $this;
    }
    /**
     * Get SuccessCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuccessCount()
    {
        return isset($this->SuccessCount) ? $this->SuccessCount : null;
    }
    /**
     * Set SuccessCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $successCount
     * @return \patest\StructType\Sales_AccountingJournalStatus
     */
    public function setSuccessCount($successCount = null)
    {
        // validation for constraint: int
        if (!is_null($successCount) && !(is_int($successCount) || ctype_digit($successCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($successCount, true), gettype($successCount)), __LINE__);
        }
        if (is_null($successCount) || (is_array($successCount) && empty($successCount))) {
            unset($this->SuccessCount);
        } else {
            $this->SuccessCount = $successCount;
        }
        return $this;
    }
    /**
     * Get TransactionsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionsCount()
    {
        return isset($this->TransactionsCount) ? $this->TransactionsCount : null;
    }
    /**
     * Set TransactionsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionsCount
     * @return \patest\StructType\Sales_AccountingJournalStatus
     */
    public function setTransactionsCount($transactionsCount = null)
    {
        // validation for constraint: int
        if (!is_null($transactionsCount) && !(is_int($transactionsCount) || ctype_digit($transactionsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionsCount, true), gettype($transactionsCount)), __LINE__);
        }
        if (is_null($transactionsCount) || (is_array($transactionsCount) && empty($transactionsCount))) {
            unset($this->TransactionsCount);
        } else {
            $this->TransactionsCount = $transactionsCount;
        }
        return $this;
    }
}
