<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sale.Processes.OriginSaleItemIdBackfillWorkItem StructType
 * @subpackage Structs
 */
class Sale_Processes_OriginSaleItemIdBackfillWorkItem extends Foundation_QueuedWorkItem
{
    /**
     * The BatchSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BatchSize;
    /**
     * The DelayBetweenBatches
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DelayBetweenBatches;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The ServiceSpecificExtraField
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificExtraField;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for Sale.Processes.OriginSaleItemIdBackfillWorkItem
     * @uses Sale_Processes_OriginSaleItemIdBackfillWorkItem::setBatchSize()
     * @uses Sale_Processes_OriginSaleItemIdBackfillWorkItem::setDelayBetweenBatches()
     * @uses Sale_Processes_OriginSaleItemIdBackfillWorkItem::setFromDate()
     * @uses Sale_Processes_OriginSaleItemIdBackfillWorkItem::setServiceSpecificExtraField()
     * @uses Sale_Processes_OriginSaleItemIdBackfillWorkItem::setToDate()
     * @param int $batchSize
     * @param int $delayBetweenBatches
     * @param string $fromDate
     * @param string $serviceSpecificExtraField
     * @param string $toDate
     */
    public function __construct($batchSize = null, $delayBetweenBatches = null, $fromDate = null, $serviceSpecificExtraField = null, $toDate = null)
    {
        $this
            ->setBatchSize($batchSize)
            ->setDelayBetweenBatches($delayBetweenBatches)
            ->setFromDate($fromDate)
            ->setServiceSpecificExtraField($serviceSpecificExtraField)
            ->setToDate($toDate);
    }
    /**
     * Get BatchSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBatchSize()
    {
        return isset($this->BatchSize) ? $this->BatchSize : null;
    }
    /**
     * Set BatchSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $batchSize
     * @return \patest\StructType\Sale_Processes_OriginSaleItemIdBackfillWorkItem
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !(is_int($batchSize) || ctype_digit($batchSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchSize, true), gettype($batchSize)), __LINE__);
        }
        if (is_null($batchSize) || (is_array($batchSize) && empty($batchSize))) {
            unset($this->BatchSize);
        } else {
            $this->BatchSize = $batchSize;
        }
        return $this;
    }
    /**
     * Get DelayBetweenBatches value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDelayBetweenBatches()
    {
        return isset($this->DelayBetweenBatches) ? $this->DelayBetweenBatches : null;
    }
    /**
     * Set DelayBetweenBatches value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $delayBetweenBatches
     * @return \patest\StructType\Sale_Processes_OriginSaleItemIdBackfillWorkItem
     */
    public function setDelayBetweenBatches($delayBetweenBatches = null)
    {
        // validation for constraint: int
        if (!is_null($delayBetweenBatches) && !(is_int($delayBetweenBatches) || ctype_digit($delayBetweenBatches))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($delayBetweenBatches, true), gettype($delayBetweenBatches)), __LINE__);
        }
        if (is_null($delayBetweenBatches) || (is_array($delayBetweenBatches) && empty($delayBetweenBatches))) {
            unset($this->DelayBetweenBatches);
        } else {
            $this->DelayBetweenBatches = $delayBetweenBatches;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Sale_Processes_OriginSaleItemIdBackfillWorkItem
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificExtraField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificExtraField()
    {
        return isset($this->ServiceSpecificExtraField) ? $this->ServiceSpecificExtraField : null;
    }
    /**
     * Set ServiceSpecificExtraField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificExtraField
     * @return \patest\StructType\Sale_Processes_OriginSaleItemIdBackfillWorkItem
     */
    public function setServiceSpecificExtraField($serviceSpecificExtraField = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificExtraField) && !is_string($serviceSpecificExtraField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificExtraField, true), gettype($serviceSpecificExtraField)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificExtraField) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificExtraField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificExtraField, true)), __LINE__);
        }
        if (is_null($serviceSpecificExtraField) || (is_array($serviceSpecificExtraField) && empty($serviceSpecificExtraField))) {
            unset($this->ServiceSpecificExtraField);
        } else {
            $this->ServiceSpecificExtraField = $serviceSpecificExtraField;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Sale_Processes_OriginSaleItemIdBackfillWorkItem
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
