<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sale.Processes.FinancialSystemBatchWorkItem StructType
 * @subpackage Structs
 */
class Sale_Processes_FinancialSystemBatchWorkItem extends Foundation_QueuedWorkItem
{
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The IsReprocess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReprocess;
    /**
     * Constructor method for Sale.Processes.FinancialSystemBatchWorkItem
     * @uses Sale_Processes_FinancialSystemBatchWorkItem::setBatchId()
     * @uses Sale_Processes_FinancialSystemBatchWorkItem::setIsReprocess()
     * @param string $batchId
     * @param bool $isReprocess
     */
    public function __construct($batchId = null, $isReprocess = null)
    {
        $this
            ->setBatchId($batchId)
            ->setIsReprocess($isReprocess);
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Sale_Processes_FinancialSystemBatchWorkItem
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get IsReprocess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReprocess()
    {
        return isset($this->IsReprocess) ? $this->IsReprocess : null;
    }
    /**
     * Set IsReprocess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReprocess
     * @return \patest\StructType\Sale_Processes_FinancialSystemBatchWorkItem
     */
    public function setIsReprocess($isReprocess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReprocess) && !is_bool($isReprocess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReprocess, true), gettype($isReprocess)), __LINE__);
        }
        if (is_null($isReprocess) || (is_array($isReprocess) && empty($isReprocess))) {
            unset($this->IsReprocess);
        } else {
            $this->IsReprocess = $isReprocess;
        }
        return $this;
    }
}
