<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SGAccountContextResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SGAccountContextResponse
 * @subpackage Structs
 */
class SGAccountContextResponse extends AbstractStructBase
{
    /**
     * The AccountEmailVerified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AccountEmailVerified;
    /**
     * The HasSGAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasSGAccount;
    /**
     * The IsLockedAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLockedAccount;
    /**
     * The LinkedAccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LinkedAccountId;
    /**
     * Constructor method for SGAccountContextResponse
     * @uses SGAccountContextResponse::setAccountEmailVerified()
     * @uses SGAccountContextResponse::setHasSGAccount()
     * @uses SGAccountContextResponse::setIsLockedAccount()
     * @uses SGAccountContextResponse::setLinkedAccountId()
     * @param bool $accountEmailVerified
     * @param bool $hasSGAccount
     * @param bool $isLockedAccount
     * @param int $linkedAccountId
     */
    public function __construct($accountEmailVerified = null, $hasSGAccount = null, $isLockedAccount = null, $linkedAccountId = null)
    {
        $this
            ->setAccountEmailVerified($accountEmailVerified)
            ->setHasSGAccount($hasSGAccount)
            ->setIsLockedAccount($isLockedAccount)
            ->setLinkedAccountId($linkedAccountId);
    }
    /**
     * Get AccountEmailVerified value
     * @return bool|null
     */
    public function getAccountEmailVerified()
    {
        return $this->AccountEmailVerified;
    }
    /**
     * Set AccountEmailVerified value
     * @param bool $accountEmailVerified
     * @return \patest\StructType\SGAccountContextResponse
     */
    public function setAccountEmailVerified($accountEmailVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountEmailVerified) && !is_bool($accountEmailVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accountEmailVerified, true), gettype($accountEmailVerified)), __LINE__);
        }
        $this->AccountEmailVerified = $accountEmailVerified;
        return $this;
    }
    /**
     * Get HasSGAccount value
     * @return bool|null
     */
    public function getHasSGAccount()
    {
        return $this->HasSGAccount;
    }
    /**
     * Set HasSGAccount value
     * @param bool $hasSGAccount
     * @return \patest\StructType\SGAccountContextResponse
     */
    public function setHasSGAccount($hasSGAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasSGAccount) && !is_bool($hasSGAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasSGAccount, true), gettype($hasSGAccount)), __LINE__);
        }
        $this->HasSGAccount = $hasSGAccount;
        return $this;
    }
    /**
     * Get IsLockedAccount value
     * @return bool|null
     */
    public function getIsLockedAccount()
    {
        return $this->IsLockedAccount;
    }
    /**
     * Set IsLockedAccount value
     * @param bool $isLockedAccount
     * @return \patest\StructType\SGAccountContextResponse
     */
    public function setIsLockedAccount($isLockedAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLockedAccount) && !is_bool($isLockedAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLockedAccount, true), gettype($isLockedAccount)), __LINE__);
        }
        $this->IsLockedAccount = $isLockedAccount;
        return $this;
    }
    /**
     * Get LinkedAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLinkedAccountId()
    {
        return isset($this->LinkedAccountId) ? $this->LinkedAccountId : null;
    }
    /**
     * Set LinkedAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $linkedAccountId
     * @return \patest\StructType\SGAccountContextResponse
     */
    public function setLinkedAccountId($linkedAccountId = null)
    {
        // validation for constraint: int
        if (!is_null($linkedAccountId) && !(is_int($linkedAccountId) || ctype_digit($linkedAccountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkedAccountId, true), gettype($linkedAccountId)), __LINE__);
        }
        if (is_null($linkedAccountId) || (is_array($linkedAccountId) && empty($linkedAccountId))) {
            unset($this->LinkedAccountId);
        } else {
            $this->LinkedAccountId = $linkedAccountId;
        }
        return $this;
    }
}
