<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleEngine._RuleEsqlCriterions StructType
 * @subpackage Structs
 */
class RuleEngine__RuleEsqlCriterions extends AnyEntity
{
    /**
     * The EsqlCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EsqlCriteria;
    /**
     * The RuleLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RuleLocalId;
    /**
     * Constructor method for RuleEngine._RuleEsqlCriterions
     * @uses RuleEngine__RuleEsqlCriterions::setEsqlCriteria()
     * @uses RuleEngine__RuleEsqlCriterions::setRuleLocalId()
     * @param string $esqlCriteria
     * @param int $ruleLocalId
     */
    public function __construct($esqlCriteria = null, $ruleLocalId = null)
    {
        $this
            ->setEsqlCriteria($esqlCriteria)
            ->setRuleLocalId($ruleLocalId);
    }
    /**
     * Get EsqlCriteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsqlCriteria()
    {
        return isset($this->EsqlCriteria) ? $this->EsqlCriteria : null;
    }
    /**
     * Set EsqlCriteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esqlCriteria
     * @return \patest\StructType\RuleEngine__RuleEsqlCriterions
     */
    public function setEsqlCriteria($esqlCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($esqlCriteria) && !is_string($esqlCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esqlCriteria, true), gettype($esqlCriteria)), __LINE__);
        }
        if (is_null($esqlCriteria) || (is_array($esqlCriteria) && empty($esqlCriteria))) {
            unset($this->EsqlCriteria);
        } else {
            $this->EsqlCriteria = $esqlCriteria;
        }
        return $this;
    }
    /**
     * Get RuleLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRuleLocalId()
    {
        return isset($this->RuleLocalId) ? $this->RuleLocalId : null;
    }
    /**
     * Set RuleLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ruleLocalId
     * @return \patest\StructType\RuleEngine__RuleEsqlCriterions
     */
    public function setRuleLocalId($ruleLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($ruleLocalId) && !(is_int($ruleLocalId) || ctype_digit($ruleLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ruleLocalId, true), gettype($ruleLocalId)), __LINE__);
        }
        if (is_null($ruleLocalId) || (is_array($ruleLocalId) && empty($ruleLocalId))) {
            unset($this->RuleLocalId);
        } else {
            $this->RuleLocalId = $ruleLocalId;
        }
        return $this;
    }
}
