<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleEngine.RuleSet StructType
 * @subpackage Structs
 */
class RuleEngine_RuleSet extends PersistableEntity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EffectiveFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveFrom;
    /**
     * The EffectiveUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveUntil;
    /**
     * The EvaluationPolicyTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EvaluationPolicyTypeName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PrerequisiteRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RuleEngine_Rule
     */
    public $PrerequisiteRule;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The RuleIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RuleIds
     */
    public $RuleIds;
    /**
     * The RuleSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RuleSystemId;
    /**
     * Constructor method for RuleEngine.RuleSet
     * @uses RuleEngine_RuleSet::setActive()
     * @uses RuleEngine_RuleSet::setDescription()
     * @uses RuleEngine_RuleSet::setEffectiveFrom()
     * @uses RuleEngine_RuleSet::setEffectiveUntil()
     * @uses RuleEngine_RuleSet::setEvaluationPolicyTypeName()
     * @uses RuleEngine_RuleSet::setName()
     * @uses RuleEngine_RuleSet::setPrerequisiteRule()
     * @uses RuleEngine_RuleSet::setPriority()
     * @uses RuleEngine_RuleSet::setRuleIds()
     * @uses RuleEngine_RuleSet::setRuleSystemId()
     * @param bool $active
     * @param string $description
     * @param string $effectiveFrom
     * @param string $effectiveUntil
     * @param string $evaluationPolicyTypeName
     * @param string $name
     * @param \patest\StructType\RuleEngine_Rule $prerequisiteRule
     * @param int $priority
     * @param \patest\StructType\RuleIds $ruleIds
     * @param string $ruleSystemId
     */
    public function __construct($active = null, $description = null, $effectiveFrom = null, $effectiveUntil = null, $evaluationPolicyTypeName = null, $name = null, \patest\StructType\RuleEngine_Rule $prerequisiteRule = null, $priority = null, \patest\StructType\RuleIds $ruleIds = null, $ruleSystemId = null)
    {
        $this
            ->setActive($active)
            ->setDescription($description)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveUntil($effectiveUntil)
            ->setEvaluationPolicyTypeName($evaluationPolicyTypeName)
            ->setName($name)
            ->setPrerequisiteRule($prerequisiteRule)
            ->setPriority($priority)
            ->setRuleIds($ruleIds)
            ->setRuleSystemId($ruleSystemId);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $active
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return isset($this->EffectiveFrom) ? $this->EffectiveFrom : null;
    }
    /**
     * Set EffectiveFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveFrom
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveFrom, true), gettype($effectiveFrom)), __LINE__);
        }
        if (is_null($effectiveFrom) || (is_array($effectiveFrom) && empty($effectiveFrom))) {
            unset($this->EffectiveFrom);
        } else {
            $this->EffectiveFrom = $effectiveFrom;
        }
        return $this;
    }
    /**
     * Get EffectiveUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveUntil()
    {
        return isset($this->EffectiveUntil) ? $this->EffectiveUntil : null;
    }
    /**
     * Set EffectiveUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveUntil
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setEffectiveUntil($effectiveUntil = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveUntil) && !is_string($effectiveUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveUntil, true), gettype($effectiveUntil)), __LINE__);
        }
        if (is_null($effectiveUntil) || (is_array($effectiveUntil) && empty($effectiveUntil))) {
            unset($this->EffectiveUntil);
        } else {
            $this->EffectiveUntil = $effectiveUntil;
        }
        return $this;
    }
    /**
     * Get EvaluationPolicyTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvaluationPolicyTypeName()
    {
        return isset($this->EvaluationPolicyTypeName) ? $this->EvaluationPolicyTypeName : null;
    }
    /**
     * Set EvaluationPolicyTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evaluationPolicyTypeName
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setEvaluationPolicyTypeName($evaluationPolicyTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($evaluationPolicyTypeName) && !is_string($evaluationPolicyTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evaluationPolicyTypeName, true), gettype($evaluationPolicyTypeName)), __LINE__);
        }
        if (is_null($evaluationPolicyTypeName) || (is_array($evaluationPolicyTypeName) && empty($evaluationPolicyTypeName))) {
            unset($this->EvaluationPolicyTypeName);
        } else {
            $this->EvaluationPolicyTypeName = $evaluationPolicyTypeName;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PrerequisiteRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RuleEngine_Rule|null
     */
    public function getPrerequisiteRule()
    {
        return isset($this->PrerequisiteRule) ? $this->PrerequisiteRule : null;
    }
    /**
     * Set PrerequisiteRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RuleEngine_Rule $prerequisiteRule
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setPrerequisiteRule(\patest\StructType\RuleEngine_Rule $prerequisiteRule = null)
    {
        if (is_null($prerequisiteRule) || (is_array($prerequisiteRule) && empty($prerequisiteRule))) {
            unset($this->PrerequisiteRule);
        } else {
            $this->PrerequisiteRule = $prerequisiteRule;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get RuleIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RuleIds|null
     */
    public function getRuleIds()
    {
        return isset($this->RuleIds) ? $this->RuleIds : null;
    }
    /**
     * Set RuleIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RuleIds $ruleIds
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setRuleIds(\patest\StructType\RuleIds $ruleIds = null)
    {
        if (is_null($ruleIds) || (is_array($ruleIds) && empty($ruleIds))) {
            unset($this->RuleIds);
        } else {
            $this->RuleIds = $ruleIds;
        }
        return $this;
    }
    /**
     * Get RuleSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleSystemId()
    {
        return isset($this->RuleSystemId) ? $this->RuleSystemId : null;
    }
    /**
     * Set RuleSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleSystemId
     * @return \patest\StructType\RuleEngine_RuleSet
     */
    public function setRuleSystemId($ruleSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleSystemId) && !is_string($ruleSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleSystemId, true), gettype($ruleSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ruleSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ruleSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ruleSystemId, true)), __LINE__);
        }
        if (is_null($ruleSystemId) || (is_array($ruleSystemId) && empty($ruleSystemId))) {
            unset($this->RuleSystemId);
        } else {
            $this->RuleSystemId = $ruleSystemId;
        }
        return $this;
    }
}
