<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleEngine.Action StructType
 * @subpackage Structs
 */
class RuleEngine_Action extends PersistableEntity
{
    /**
     * The ActionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionValue;
    /**
     * The AuditValue
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditValue;
    /**
     * The DisplayString
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayString;
    /**
     * The DisplayStrings
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfStringStringPair
     */
    public $DisplayStrings;
    /**
     * The InstanceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstanceValue;
    /**
     * The InstanceValueJson
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstanceValueJson;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Order;
    /**
     * The RuleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RuleId;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeId;
    /**
     * Constructor method for RuleEngine.Action
     * @uses RuleEngine_Action::setActionValue()
     * @uses RuleEngine_Action::setAuditValue()
     * @uses RuleEngine_Action::setDisplayString()
     * @uses RuleEngine_Action::setDisplayStrings()
     * @uses RuleEngine_Action::setInstanceValue()
     * @uses RuleEngine_Action::setInstanceValueJson()
     * @uses RuleEngine_Action::setOrder()
     * @uses RuleEngine_Action::setRuleId()
     * @uses RuleEngine_Action::setTypeId()
     * @param string $actionValue
     * @param string $auditValue
     * @param string $displayString
     * @param \patest\StructType\RecordSetOfStringStringPair $displayStrings
     * @param string $instanceValue
     * @param string $instanceValueJson
     * @param int $order
     * @param string $ruleId
     * @param string $typeId
     */
    public function __construct($actionValue = null, $auditValue = null, $displayString = null, \patest\StructType\RecordSetOfStringStringPair $displayStrings = null, $instanceValue = null, $instanceValueJson = null, $order = null, $ruleId = null, $typeId = null)
    {
        $this
            ->setActionValue($actionValue)
            ->setAuditValue($auditValue)
            ->setDisplayString($displayString)
            ->setDisplayStrings($displayStrings)
            ->setInstanceValue($instanceValue)
            ->setInstanceValueJson($instanceValueJson)
            ->setOrder($order)
            ->setRuleId($ruleId)
            ->setTypeId($typeId);
    }
    /**
     * Get ActionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionValue()
    {
        return isset($this->ActionValue) ? $this->ActionValue : null;
    }
    /**
     * Set ActionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionValue
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setActionValue($actionValue = null)
    {
        // validation for constraint: string
        if (!is_null($actionValue) && !is_string($actionValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionValue, true), gettype($actionValue)), __LINE__);
        }
        if (is_null($actionValue) || (is_array($actionValue) && empty($actionValue))) {
            unset($this->ActionValue);
        } else {
            $this->ActionValue = $actionValue;
        }
        return $this;
    }
    /**
     * Get AuditValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditValue()
    {
        return isset($this->AuditValue) ? $this->AuditValue : null;
    }
    /**
     * Set AuditValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditValue
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setAuditValue($auditValue = null)
    {
        // validation for constraint: string
        if (!is_null($auditValue) && !is_string($auditValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditValue, true), gettype($auditValue)), __LINE__);
        }
        if (is_null($auditValue) || (is_array($auditValue) && empty($auditValue))) {
            unset($this->AuditValue);
        } else {
            $this->AuditValue = $auditValue;
        }
        return $this;
    }
    /**
     * Get DisplayString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayString()
    {
        return isset($this->DisplayString) ? $this->DisplayString : null;
    }
    /**
     * Set DisplayString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayString
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setDisplayString($displayString = null)
    {
        // validation for constraint: string
        if (!is_null($displayString) && !is_string($displayString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayString, true), gettype($displayString)), __LINE__);
        }
        if (is_null($displayString) || (is_array($displayString) && empty($displayString))) {
            unset($this->DisplayString);
        } else {
            $this->DisplayString = $displayString;
        }
        return $this;
    }
    /**
     * Get DisplayStrings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfStringStringPair|null
     */
    public function getDisplayStrings()
    {
        return isset($this->DisplayStrings) ? $this->DisplayStrings : null;
    }
    /**
     * Set DisplayStrings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfStringStringPair $displayStrings
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setDisplayStrings(\patest\StructType\RecordSetOfStringStringPair $displayStrings = null)
    {
        if (is_null($displayStrings) || (is_array($displayStrings) && empty($displayStrings))) {
            unset($this->DisplayStrings);
        } else {
            $this->DisplayStrings = $displayStrings;
        }
        return $this;
    }
    /**
     * Get InstanceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstanceValue()
    {
        return isset($this->InstanceValue) ? $this->InstanceValue : null;
    }
    /**
     * Set InstanceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instanceValue
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setInstanceValue($instanceValue = null)
    {
        // validation for constraint: string
        if (!is_null($instanceValue) && !is_string($instanceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceValue, true), gettype($instanceValue)), __LINE__);
        }
        if (is_null($instanceValue) || (is_array($instanceValue) && empty($instanceValue))) {
            unset($this->InstanceValue);
        } else {
            $this->InstanceValue = $instanceValue;
        }
        return $this;
    }
    /**
     * Get InstanceValueJson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstanceValueJson()
    {
        return isset($this->InstanceValueJson) ? $this->InstanceValueJson : null;
    }
    /**
     * Set InstanceValueJson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instanceValueJson
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setInstanceValueJson($instanceValueJson = null)
    {
        // validation for constraint: string
        if (!is_null($instanceValueJson) && !is_string($instanceValueJson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceValueJson, true), gettype($instanceValueJson)), __LINE__);
        }
        if (is_null($instanceValueJson) || (is_array($instanceValueJson) && empty($instanceValueJson))) {
            unset($this->InstanceValueJson);
        } else {
            $this->InstanceValueJson = $instanceValueJson;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $order
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get RuleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleId()
    {
        return isset($this->RuleId) ? $this->RuleId : null;
    }
    /**
     * Set RuleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleId
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleId) && !is_string($ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ruleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ruleId, true)), __LINE__);
        }
        if (is_null($ruleId) || (is_array($ruleId) && empty($ruleId))) {
            unset($this->RuleId);
        } else {
            $this->RuleId = $ruleId;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\RuleEngine_Action
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
}
