<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSalesItemsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSalesItemsRequest
 * @subpackage Structs
 */
class RetrieveSalesItemsRequest extends AbstractStructBase
{
    /**
     * The BulkSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BulkSize;
    /**
     * The FromDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDateTime;
    /**
     * The RowVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowVersion;
    /**
     * The Watermark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Watermark
     */
    public $Watermark;
    /**
     * Constructor method for RetrieveSalesItemsRequest
     * @uses RetrieveSalesItemsRequest::setBulkSize()
     * @uses RetrieveSalesItemsRequest::setFromDateTime()
     * @uses RetrieveSalesItemsRequest::setRowVersion()
     * @uses RetrieveSalesItemsRequest::setWatermark()
     * @param int $bulkSize
     * @param string $fromDateTime
     * @param int $rowVersion
     * @param \patest\StructType\Watermark $watermark
     */
    public function __construct($bulkSize = null, $fromDateTime = null, $rowVersion = null, \patest\StructType\Watermark $watermark = null)
    {
        $this
            ->setBulkSize($bulkSize)
            ->setFromDateTime($fromDateTime)
            ->setRowVersion($rowVersion)
            ->setWatermark($watermark);
    }
    /**
     * Get BulkSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBulkSize()
    {
        return isset($this->BulkSize) ? $this->BulkSize : null;
    }
    /**
     * Set BulkSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bulkSize
     * @return \patest\StructType\RetrieveSalesItemsRequest
     */
    public function setBulkSize($bulkSize = null)
    {
        // validation for constraint: int
        if (!is_null($bulkSize) && !(is_int($bulkSize) || ctype_digit($bulkSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bulkSize, true), gettype($bulkSize)), __LINE__);
        }
        if (is_null($bulkSize) || (is_array($bulkSize) && empty($bulkSize))) {
            unset($this->BulkSize);
        } else {
            $this->BulkSize = $bulkSize;
        }
        return $this;
    }
    /**
     * Get FromDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDateTime()
    {
        return isset($this->FromDateTime) ? $this->FromDateTime : null;
    }
    /**
     * Set FromDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDateTime
     * @return \patest\StructType\RetrieveSalesItemsRequest
     */
    public function setFromDateTime($fromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateTime) && !is_string($fromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDateTime, true), gettype($fromDateTime)), __LINE__);
        }
        if (is_null($fromDateTime) || (is_array($fromDateTime) && empty($fromDateTime))) {
            unset($this->FromDateTime);
        } else {
            $this->FromDateTime = $fromDateTime;
        }
        return $this;
    }
    /**
     * Get RowVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowVersion()
    {
        return isset($this->RowVersion) ? $this->RowVersion : null;
    }
    /**
     * Set RowVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowVersion
     * @return \patest\StructType\RetrieveSalesItemsRequest
     */
    public function setRowVersion($rowVersion = null)
    {
        // validation for constraint: int
        if (!is_null($rowVersion) && !(is_int($rowVersion) || ctype_digit($rowVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowVersion, true), gettype($rowVersion)), __LINE__);
        }
        if (is_null($rowVersion) || (is_array($rowVersion) && empty($rowVersion))) {
            unset($this->RowVersion);
        } else {
            $this->RowVersion = $rowVersion;
        }
        return $this;
    }
    /**
     * Get Watermark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Watermark|null
     */
    public function getWatermark()
    {
        return isset($this->Watermark) ? $this->Watermark : null;
    }
    /**
     * Set Watermark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Watermark $watermark
     * @return \patest\StructType\RetrieveSalesItemsRequest
     */
    public function setWatermark(\patest\StructType\Watermark $watermark = null)
    {
        if (is_null($watermark) || (is_array($watermark) && empty($watermark))) {
            unset($this->Watermark);
        } else {
            $this->Watermark = $watermark;
        }
        return $this;
    }
}
