<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveHallVersionDesign-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveHallVersionDesign-Request
 * @subpackage Structs
 */
class RetrieveHallVersionDesign_Request extends ExtensibleDataContract
{
    /**
     * The AreaGuids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AreaGuids;
    /**
     * The HallVersionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionGuid;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Level;
    /**
     * The ShowGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowGuid;
    /**
     * The ValidateVersionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ValidateVersionStatus;
    /**
     * The WithoutHallData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $WithoutHallData;
    /**
     * The SeatingPlanGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanGuid;
    /**
     * The IsRetrieveNotImplementedAreas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRetrieveNotImplementedAreas;
    /**
     * Constructor method for RetrieveHallVersionDesign-Request
     * @uses RetrieveHallVersionDesign_Request::setAreaGuids()
     * @uses RetrieveHallVersionDesign_Request::setHallVersionGuid()
     * @uses RetrieveHallVersionDesign_Request::setLevel()
     * @uses RetrieveHallVersionDesign_Request::setShowGuid()
     * @uses RetrieveHallVersionDesign_Request::setValidateVersionStatus()
     * @uses RetrieveHallVersionDesign_Request::setWithoutHallData()
     * @uses RetrieveHallVersionDesign_Request::setSeatingPlanGuid()
     * @uses RetrieveHallVersionDesign_Request::setIsRetrieveNotImplementedAreas()
     * @param \patest\ArrayType\ArrayOfguid $areaGuids
     * @param string $hallVersionGuid
     * @param string $level
     * @param string $showGuid
     * @param bool $validateVersionStatus
     * @param bool $withoutHallData
     * @param string $seatingPlanGuid
     * @param bool $isRetrieveNotImplementedAreas
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $areaGuids = null, $hallVersionGuid = null, $level = null, $showGuid = null, $validateVersionStatus = null, $withoutHallData = null, $seatingPlanGuid = null, $isRetrieveNotImplementedAreas = null)
    {
        $this
            ->setAreaGuids($areaGuids)
            ->setHallVersionGuid($hallVersionGuid)
            ->setLevel($level)
            ->setShowGuid($showGuid)
            ->setValidateVersionStatus($validateVersionStatus)
            ->setWithoutHallData($withoutHallData)
            ->setSeatingPlanGuid($seatingPlanGuid)
            ->setIsRetrieveNotImplementedAreas($isRetrieveNotImplementedAreas);
    }
    /**
     * Get AreaGuids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAreaGuids()
    {
        return isset($this->AreaGuids) ? $this->AreaGuids : null;
    }
    /**
     * Set AreaGuids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $areaGuids
     * @return \patest\StructType\RetrieveHallVersionDesign_Request
     */
    public function setAreaGuids(\patest\ArrayType\ArrayOfguid $areaGuids = null)
    {
        if (is_null($areaGuids) || (is_array($areaGuids) && empty($areaGuids))) {
            unset($this->AreaGuids);
        } else {
            $this->AreaGuids = $areaGuids;
        }
        return $this;
    }
    /**
     * Get HallVersionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionGuid()
    {
        return isset($this->HallVersionGuid) ? $this->HallVersionGuid : null;
    }
    /**
     * Set HallVersionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionGuid
     * @return \patest\StructType\RetrieveHallVersionDesign_Request
     */
    public function setHallVersionGuid($hallVersionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionGuid) && !is_string($hallVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionGuid, true), gettype($hallVersionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionGuid, true)), __LINE__);
        }
        if (is_null($hallVersionGuid) || (is_array($hallVersionGuid) && empty($hallVersionGuid))) {
            unset($this->HallVersionGuid);
        } else {
            $this->HallVersionGuid = $hallVersionGuid;
        }
        return $this;
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @uses \patest\EnumType\HallAreaLevel::valueIsValid()
     * @uses \patest\EnumType\HallAreaLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \patest\StructType\RetrieveHallVersionDesign_Request
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallAreaLevel::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallAreaLevel', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \patest\EnumType\HallAreaLevel::getValidValues())), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get ShowGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowGuid()
    {
        return isset($this->ShowGuid) ? $this->ShowGuid : null;
    }
    /**
     * Set ShowGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showGuid
     * @return \patest\StructType\RetrieveHallVersionDesign_Request
     */
    public function setShowGuid($showGuid = null)
    {
        // validation for constraint: string
        if (!is_null($showGuid) && !is_string($showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showGuid, true), gettype($showGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showGuid, true)), __LINE__);
        }
        if (is_null($showGuid) || (is_array($showGuid) && empty($showGuid))) {
            unset($this->ShowGuid);
        } else {
            $this->ShowGuid = $showGuid;
        }
        return $this;
    }
    /**
     * Get ValidateVersionStatus value
     * @return bool|null
     */
    public function getValidateVersionStatus()
    {
        return $this->ValidateVersionStatus;
    }
    /**
     * Set ValidateVersionStatus value
     * @param bool $validateVersionStatus
     * @return \patest\StructType\RetrieveHallVersionDesign_Request
     */
    public function setValidateVersionStatus($validateVersionStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($validateVersionStatus) && !is_bool($validateVersionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validateVersionStatus, true), gettype($validateVersionStatus)), __LINE__);
        }
        $this->ValidateVersionStatus = $validateVersionStatus;
        return $this;
    }
    /**
     * Get WithoutHallData value
     * @return bool|null
     */
    public function getWithoutHallData()
    {
        return $this->WithoutHallData;
    }
    /**
     * Set WithoutHallData value
     * @param bool $withoutHallData
     * @return \patest\StructType\RetrieveHallVersionDesign_Request
     */
    public function setWithoutHallData($withoutHallData = null)
    {
        // validation for constraint: boolean
        if (!is_null($withoutHallData) && !is_bool($withoutHallData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutHallData, true), gettype($withoutHallData)), __LINE__);
        }
        $this->WithoutHallData = $withoutHallData;
        return $this;
    }
    /**
     * Get SeatingPlanGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanGuid()
    {
        return isset($this->SeatingPlanGuid) ? $this->SeatingPlanGuid : null;
    }
    /**
     * Set SeatingPlanGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanGuid
     * @return \patest\StructType\RetrieveHallVersionDesign_Request
     */
    public function setSeatingPlanGuid($seatingPlanGuid = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanGuid) && !is_string($seatingPlanGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanGuid, true), gettype($seatingPlanGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanGuid, true)), __LINE__);
        }
        if (is_null($seatingPlanGuid) || (is_array($seatingPlanGuid) && empty($seatingPlanGuid))) {
            unset($this->SeatingPlanGuid);
        } else {
            $this->SeatingPlanGuid = $seatingPlanGuid;
        }
        return $this;
    }
    /**
     * Get IsRetrieveNotImplementedAreas value
     * @return bool|null
     */
    public function getIsRetrieveNotImplementedAreas()
    {
        return $this->IsRetrieveNotImplementedAreas;
    }
    /**
     * Set IsRetrieveNotImplementedAreas value
     * @param bool $isRetrieveNotImplementedAreas
     * @return \patest\StructType\RetrieveHallVersionDesign_Request
     */
    public function setIsRetrieveNotImplementedAreas($isRetrieveNotImplementedAreas = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRetrieveNotImplementedAreas) && !is_bool($isRetrieveNotImplementedAreas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRetrieveNotImplementedAreas, true), gettype($isRetrieveNotImplementedAreas)), __LINE__);
        }
        $this->IsRetrieveNotImplementedAreas = $isRetrieveNotImplementedAreas;
        return $this;
    }
}
