<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultMetadata StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultMetadata
 * @subpackage Structs
 */
class ResultMetadata extends AbstractStructBase
{
    /**
     * The Parts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfResultPartMetadata
     */
    public $Parts;
    /**
     * Constructor method for ResultMetadata
     * @uses ResultMetadata::setParts()
     * @param \patest\ArrayType\ArrayOfResultPartMetadata $parts
     */
    public function __construct(\patest\ArrayType\ArrayOfResultPartMetadata $parts = null)
    {
        $this
            ->setParts($parts);
    }
    /**
     * Get Parts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfResultPartMetadata|null
     */
    public function getParts()
    {
        return isset($this->Parts) ? $this->Parts : null;
    }
    /**
     * Set Parts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfResultPartMetadata $parts
     * @return \patest\StructType\ResultMetadata
     */
    public function setParts(\patest\ArrayType\ArrayOfResultPartMetadata $parts = null)
    {
        if (is_null($parts) || (is_array($parts) && empty($parts))) {
            unset($this->Parts);
        } else {
            $this->Parts = $parts;
        }
        return $this;
    }
}
