<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionIdentity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RestrictionIdentity
 * @subpackage Structs
 */
class RestrictionIdentity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The RestrictionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RestrictionType;
    /**
     * Constructor method for RestrictionIdentity
     * @uses RestrictionIdentity::setId()
     * @uses RestrictionIdentity::setRestrictionType()
     * @param string $id
     * @param string $restrictionType
     */
    public function __construct($id = null, $restrictionType = null)
    {
        $this
            ->setId($id)
            ->setRestrictionType($restrictionType);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\RestrictionIdentity
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RestrictionType value
     * @return string|null
     */
    public function getRestrictionType()
    {
        return $this->RestrictionType;
    }
    /**
     * Set RestrictionType value
     * @uses \patest\EnumType\RestrictionType::valueIsValid()
     * @uses \patest\EnumType\RestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionType
     * @return \patest\StructType\RestrictionIdentity
     */
    public function setRestrictionType($restrictionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionType::valueIsValid($restrictionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionType', is_array($restrictionType) ? implode(', ', $restrictionType) : var_export($restrictionType, true), implode(', ', \patest\EnumType\RestrictionType::getValidValues())), __LINE__);
        }
        $this->RestrictionType = $restrictionType;
        return $this;
    }
}
