<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrctionConsumptionItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RestrctionConsumptionItem
 * @subpackage Structs
 */
class RestrctionConsumptionItem extends AbstractStructBase
{
    /**
     * The Consumed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Consumed;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Total;
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Available;
    /**
     * The CommittedReserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommittedReserved;
    /**
     * The CommittedSold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommittedSold;
    /**
     * The IsAvailableToUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailableToUser;
    /**
     * The IsExpired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExpired;
    /**
     * The RestrictionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RestrictionType;
    /**
     * The ForResaleCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ForResaleCount;
    /**
     * Constructor method for RestrctionConsumptionItem
     * @uses RestrctionConsumptionItem::setConsumed()
     * @uses RestrctionConsumptionItem::setTotal()
     * @uses RestrctionConsumptionItem::setAvailable()
     * @uses RestrctionConsumptionItem::setCommittedReserved()
     * @uses RestrctionConsumptionItem::setCommittedSold()
     * @uses RestrctionConsumptionItem::setIsAvailableToUser()
     * @uses RestrctionConsumptionItem::setIsExpired()
     * @uses RestrctionConsumptionItem::setRestrictionType()
     * @uses RestrctionConsumptionItem::setForResaleCount()
     * @param int $consumed
     * @param int $total
     * @param int $available
     * @param int $committedReserved
     * @param int $committedSold
     * @param bool $isAvailableToUser
     * @param bool $isExpired
     * @param string $restrictionType
     * @param int $forResaleCount
     */
    public function __construct($consumed = null, $total = null, $available = null, $committedReserved = null, $committedSold = null, $isAvailableToUser = null, $isExpired = null, $restrictionType = null, $forResaleCount = null)
    {
        $this
            ->setConsumed($consumed)
            ->setTotal($total)
            ->setAvailable($available)
            ->setCommittedReserved($committedReserved)
            ->setCommittedSold($committedSold)
            ->setIsAvailableToUser($isAvailableToUser)
            ->setIsExpired($isExpired)
            ->setRestrictionType($restrictionType)
            ->setForResaleCount($forResaleCount);
    }
    /**
     * Get Consumed value
     * @return int|null
     */
    public function getConsumed()
    {
        return $this->Consumed;
    }
    /**
     * Set Consumed value
     * @param int $consumed
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setConsumed($consumed = null)
    {
        // validation for constraint: int
        if (!is_null($consumed) && !(is_int($consumed) || ctype_digit($consumed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consumed, true), gettype($consumed)), __LINE__);
        }
        $this->Consumed = $consumed;
        return $this;
    }
    /**
     * Get Total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Available value
     * @return int|null
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param int $available
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: int
        if (!is_null($available) && !(is_int($available) || ctype_digit($available))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get CommittedReserved value
     * @return int|null
     */
    public function getCommittedReserved()
    {
        return $this->CommittedReserved;
    }
    /**
     * Set CommittedReserved value
     * @param int $committedReserved
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setCommittedReserved($committedReserved = null)
    {
        // validation for constraint: int
        if (!is_null($committedReserved) && !(is_int($committedReserved) || ctype_digit($committedReserved))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($committedReserved, true), gettype($committedReserved)), __LINE__);
        }
        $this->CommittedReserved = $committedReserved;
        return $this;
    }
    /**
     * Get CommittedSold value
     * @return int|null
     */
    public function getCommittedSold()
    {
        return $this->CommittedSold;
    }
    /**
     * Set CommittedSold value
     * @param int $committedSold
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setCommittedSold($committedSold = null)
    {
        // validation for constraint: int
        if (!is_null($committedSold) && !(is_int($committedSold) || ctype_digit($committedSold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($committedSold, true), gettype($committedSold)), __LINE__);
        }
        $this->CommittedSold = $committedSold;
        return $this;
    }
    /**
     * Get IsAvailableToUser value
     * @return bool|null
     */
    public function getIsAvailableToUser()
    {
        return $this->IsAvailableToUser;
    }
    /**
     * Set IsAvailableToUser value
     * @param bool $isAvailableToUser
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setIsAvailableToUser($isAvailableToUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableToUser) && !is_bool($isAvailableToUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableToUser, true), gettype($isAvailableToUser)), __LINE__);
        }
        $this->IsAvailableToUser = $isAvailableToUser;
        return $this;
    }
    /**
     * Get IsExpired value
     * @return bool|null
     */
    public function getIsExpired()
    {
        return $this->IsExpired;
    }
    /**
     * Set IsExpired value
     * @param bool $isExpired
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setIsExpired($isExpired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExpired) && !is_bool($isExpired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExpired, true), gettype($isExpired)), __LINE__);
        }
        $this->IsExpired = $isExpired;
        return $this;
    }
    /**
     * Get RestrictionType value
     * @return string|null
     */
    public function getRestrictionType()
    {
        return $this->RestrictionType;
    }
    /**
     * Set RestrictionType value
     * @uses \patest\EnumType\RestrictionType::valueIsValid()
     * @uses \patest\EnumType\RestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionType
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setRestrictionType($restrictionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionType::valueIsValid($restrictionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionType', is_array($restrictionType) ? implode(', ', $restrictionType) : var_export($restrictionType, true), implode(', ', \patest\EnumType\RestrictionType::getValidValues())), __LINE__);
        }
        $this->RestrictionType = $restrictionType;
        return $this;
    }
    /**
     * Get ForResaleCount value
     * @return int|null
     */
    public function getForResaleCount()
    {
        return $this->ForResaleCount;
    }
    /**
     * Set ForResaleCount value
     * @param int $forResaleCount
     * @return \patest\StructType\RestrctionConsumptionItem
     */
    public function setForResaleCount($forResaleCount = null)
    {
        // validation for constraint: int
        if (!is_null($forResaleCount) && !(is_int($forResaleCount) || ctype_digit($forResaleCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forResaleCount, true), gettype($forResaleCount)), __LINE__);
        }
        $this->ForResaleCount = $forResaleCount;
        return $this;
    }
}
