<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResolveClientNameBySalutationFormatRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResolveClientNameBySalutationFormatRequest
 * @subpackage Structs
 */
class ResolveClientNameBySalutationFormatRequest extends AbstractStructBase
{
    /**
     * The AccountSalutationFormatId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountSalutationFormatId;
    /**
     * The ClientNamesByClientId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidCrm_CombinedClientNameIqjNp0cc
     */
    public $ClientNamesByClientId;
    /**
     * The CustomerSalutationFormatId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerSalutationFormatId;
    /**
     * The Purpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Purpose;
    /**
     * The UseIndividualSalutation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseIndividualSalutation;
    /**
     * Constructor method for ResolveClientNameBySalutationFormatRequest
     * @uses ResolveClientNameBySalutationFormatRequest::setAccountSalutationFormatId()
     * @uses ResolveClientNameBySalutationFormatRequest::setClientNamesByClientId()
     * @uses ResolveClientNameBySalutationFormatRequest::setCustomerSalutationFormatId()
     * @uses ResolveClientNameBySalutationFormatRequest::setPurpose()
     * @uses ResolveClientNameBySalutationFormatRequest::setUseIndividualSalutation()
     * @param string $accountSalutationFormatId
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidCrm_CombinedClientNameIqjNp0cc $clientNamesByClientId
     * @param string $customerSalutationFormatId
     * @param string $purpose
     * @param bool $useIndividualSalutation
     */
    public function __construct($accountSalutationFormatId = null, \patest\ArrayType\ArrayOfKeyValueOfguidCrm_CombinedClientNameIqjNp0cc $clientNamesByClientId = null, $customerSalutationFormatId = null, $purpose = null, $useIndividualSalutation = null)
    {
        $this
            ->setAccountSalutationFormatId($accountSalutationFormatId)
            ->setClientNamesByClientId($clientNamesByClientId)
            ->setCustomerSalutationFormatId($customerSalutationFormatId)
            ->setPurpose($purpose)
            ->setUseIndividualSalutation($useIndividualSalutation);
    }
    /**
     * Get AccountSalutationFormatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountSalutationFormatId()
    {
        return isset($this->AccountSalutationFormatId) ? $this->AccountSalutationFormatId : null;
    }
    /**
     * Set AccountSalutationFormatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountSalutationFormatId
     * @return \patest\StructType\ResolveClientNameBySalutationFormatRequest
     */
    public function setAccountSalutationFormatId($accountSalutationFormatId = null)
    {
        // validation for constraint: string
        if (!is_null($accountSalutationFormatId) && !is_string($accountSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountSalutationFormatId, true), gettype($accountSalutationFormatId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountSalutationFormatId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountSalutationFormatId, true)), __LINE__);
        }
        if (is_null($accountSalutationFormatId) || (is_array($accountSalutationFormatId) && empty($accountSalutationFormatId))) {
            unset($this->AccountSalutationFormatId);
        } else {
            $this->AccountSalutationFormatId = $accountSalutationFormatId;
        }
        return $this;
    }
    /**
     * Get ClientNamesByClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidCrm_CombinedClientNameIqjNp0cc|null
     */
    public function getClientNamesByClientId()
    {
        return isset($this->ClientNamesByClientId) ? $this->ClientNamesByClientId : null;
    }
    /**
     * Set ClientNamesByClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidCrm_CombinedClientNameIqjNp0cc $clientNamesByClientId
     * @return \patest\StructType\ResolveClientNameBySalutationFormatRequest
     */
    public function setClientNamesByClientId(\patest\ArrayType\ArrayOfKeyValueOfguidCrm_CombinedClientNameIqjNp0cc $clientNamesByClientId = null)
    {
        if (is_null($clientNamesByClientId) || (is_array($clientNamesByClientId) && empty($clientNamesByClientId))) {
            unset($this->ClientNamesByClientId);
        } else {
            $this->ClientNamesByClientId = $clientNamesByClientId;
        }
        return $this;
    }
    /**
     * Get CustomerSalutationFormatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerSalutationFormatId()
    {
        return isset($this->CustomerSalutationFormatId) ? $this->CustomerSalutationFormatId : null;
    }
    /**
     * Set CustomerSalutationFormatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerSalutationFormatId
     * @return \patest\StructType\ResolveClientNameBySalutationFormatRequest
     */
    public function setCustomerSalutationFormatId($customerSalutationFormatId = null)
    {
        // validation for constraint: string
        if (!is_null($customerSalutationFormatId) && !is_string($customerSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerSalutationFormatId, true), gettype($customerSalutationFormatId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerSalutationFormatId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerSalutationFormatId, true)), __LINE__);
        }
        if (is_null($customerSalutationFormatId) || (is_array($customerSalutationFormatId) && empty($customerSalutationFormatId))) {
            unset($this->CustomerSalutationFormatId);
        } else {
            $this->CustomerSalutationFormatId = $customerSalutationFormatId;
        }
        return $this;
    }
    /**
     * Get Purpose value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurpose()
    {
        return isset($this->Purpose) ? $this->Purpose : null;
    }
    /**
     * Set Purpose value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purpose
     * @return \patest\StructType\ResolveClientNameBySalutationFormatRequest
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        if (is_null($purpose) || (is_array($purpose) && empty($purpose))) {
            unset($this->Purpose);
        } else {
            $this->Purpose = $purpose;
        }
        return $this;
    }
    /**
     * Get UseIndividualSalutation value
     * @return bool|null
     */
    public function getUseIndividualSalutation()
    {
        return $this->UseIndividualSalutation;
    }
    /**
     * Set UseIndividualSalutation value
     * @param bool $useIndividualSalutation
     * @return \patest\StructType\ResolveClientNameBySalutationFormatRequest
     */
    public function setUseIndividualSalutation($useIndividualSalutation = null)
    {
        // validation for constraint: boolean
        if (!is_null($useIndividualSalutation) && !is_bool($useIndividualSalutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useIndividualSalutation, true), gettype($useIndividualSalutation)), __LINE__);
        }
        $this->UseIndividualSalutation = $useIndividualSalutation;
        return $this;
    }
}
