<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservedSeatingLayerSettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservedSeatingLayerSettings
 * @subpackage Structs
 */
class ReservedSeatingLayerSettings extends AreaLayerSettings
{
    /**
     * The LayerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LayerType;
    /**
     * The LayerValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LayerValue;
    /**
     * The SeatIdsInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValuePairOfintNullableOfintU6ho3Bhd
     */
    public $SeatIdsInAreaMap;
    /**
     * Constructor method for ReservedSeatingLayerSettings
     * @uses ReservedSeatingLayerSettings::setLayerType()
     * @uses ReservedSeatingLayerSettings::setLayerValue()
     * @uses ReservedSeatingLayerSettings::setSeatIdsInAreaMap()
     * @param string $layerType
     * @param string $layerValue
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfintNullableOfintU6ho3Bhd $seatIdsInAreaMap
     */
    public function __construct($layerType = null, $layerValue = null, \patest\ArrayType\ArrayOfKeyValuePairOfintNullableOfintU6ho3Bhd $seatIdsInAreaMap = null)
    {
        $this
            ->setLayerType($layerType)
            ->setLayerValue($layerValue)
            ->setSeatIdsInAreaMap($seatIdsInAreaMap);
    }
    /**
     * Get LayerType value
     * @return string|null
     */
    public function getLayerType()
    {
        return $this->LayerType;
    }
    /**
     * Set LayerType value
     * @uses \patest\EnumType\LayerTypes::valueIsValid()
     * @uses \patest\EnumType\LayerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layerType
     * @return \patest\StructType\ReservedSeatingLayerSettings
     */
    public function setLayerType($layerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerTypes::valueIsValid($layerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerTypes', is_array($layerType) ? implode(', ', $layerType) : var_export($layerType, true), implode(', ', \patest\EnumType\LayerTypes::getValidValues())), __LINE__);
        }
        $this->LayerType = $layerType;
        return $this;
    }
    /**
     * Get LayerValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerValue()
    {
        return isset($this->LayerValue) ? $this->LayerValue : null;
    }
    /**
     * Set LayerValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $layerValue
     * @return \patest\StructType\ReservedSeatingLayerSettings
     */
    public function setLayerValue($layerValue = null)
    {
        // validation for constraint: string
        if (!is_null($layerValue) && !is_string($layerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layerValue, true), gettype($layerValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($layerValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $layerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($layerValue, true)), __LINE__);
        }
        if (is_null($layerValue) || (is_array($layerValue) && empty($layerValue))) {
            unset($this->LayerValue);
        } else {
            $this->LayerValue = $layerValue;
        }
        return $this;
    }
    /**
     * Get SeatIdsInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValuePairOfintNullableOfintU6ho3Bhd|null
     */
    public function getSeatIdsInAreaMap()
    {
        return isset($this->SeatIdsInAreaMap) ? $this->SeatIdsInAreaMap : null;
    }
    /**
     * Set SeatIdsInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfintNullableOfintU6ho3Bhd $seatIdsInAreaMap
     * @return \patest\StructType\ReservedSeatingLayerSettings
     */
    public function setSeatIdsInAreaMap(\patest\ArrayType\ArrayOfKeyValuePairOfintNullableOfintU6ho3Bhd $seatIdsInAreaMap = null)
    {
        if (is_null($seatIdsInAreaMap) || (is_array($seatIdsInAreaMap) && empty($seatIdsInAreaMap))) {
            unset($this->SeatIdsInAreaMap);
        } else {
            $this->SeatIdsInAreaMap = $seatIdsInAreaMap;
        }
        return $this;
    }
}
