<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reporting.SimplifiedFactPriceModifier StructType
 * @subpackage Structs
 */
class Reporting_SimplifiedFactPriceModifier extends PersistableEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The InsertionSign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionSign;
    /**
     * The IsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncluded;
    /**
     * The ItemGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemGuid;
    /**
     * The OrganizationGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationGuid;
    /**
     * The PriceModifierDefinitionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceModifierDefinitionGuid;
    /**
     * The PriceModifierName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceModifierName;
    /**
     * The PriceModifierTypeEnum
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceModifierTypeEnum;
    /**
     * Constructor method for Reporting.SimplifiedFactPriceModifier
     * @uses Reporting_SimplifiedFactPriceModifier::setAmount()
     * @uses Reporting_SimplifiedFactPriceModifier::setInsertionSign()
     * @uses Reporting_SimplifiedFactPriceModifier::setIsIncluded()
     * @uses Reporting_SimplifiedFactPriceModifier::setItemGuid()
     * @uses Reporting_SimplifiedFactPriceModifier::setOrganizationGuid()
     * @uses Reporting_SimplifiedFactPriceModifier::setPriceModifierDefinitionGuid()
     * @uses Reporting_SimplifiedFactPriceModifier::setPriceModifierName()
     * @uses Reporting_SimplifiedFactPriceModifier::setPriceModifierTypeEnum()
     * @param \patest\StructType\Money $amount
     * @param string $insertionSign
     * @param bool $isIncluded
     * @param string $itemGuid
     * @param string $organizationGuid
     * @param string $priceModifierDefinitionGuid
     * @param \patest\StructType\GlobalString $priceModifierName
     * @param string $priceModifierTypeEnum
     */
    public function __construct(\patest\StructType\Money $amount = null, $insertionSign = null, $isIncluded = null, $itemGuid = null, $organizationGuid = null, $priceModifierDefinitionGuid = null, \patest\StructType\GlobalString $priceModifierName = null, $priceModifierTypeEnum = null)
    {
        $this
            ->setAmount($amount)
            ->setInsertionSign($insertionSign)
            ->setIsIncluded($isIncluded)
            ->setItemGuid($itemGuid)
            ->setOrganizationGuid($organizationGuid)
            ->setPriceModifierDefinitionGuid($priceModifierDefinitionGuid)
            ->setPriceModifierName($priceModifierName)
            ->setPriceModifierTypeEnum($priceModifierTypeEnum);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\Reporting_SimplifiedFactPriceModifier
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get InsertionSign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionSign()
    {
        return isset($this->InsertionSign) ? $this->InsertionSign : null;
    }
    /**
     * Set InsertionSign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insertionSign
     * @return \patest\StructType\Reporting_SimplifiedFactPriceModifier
     */
    public function setInsertionSign($insertionSign = null)
    {
        // validation for constraint: string
        if (!is_null($insertionSign) && !is_string($insertionSign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertionSign, true), gettype($insertionSign)), __LINE__);
        }
        if (is_null($insertionSign) || (is_array($insertionSign) && empty($insertionSign))) {
            unset($this->InsertionSign);
        } else {
            $this->InsertionSign = $insertionSign;
        }
        return $this;
    }
    /**
     * Get IsIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncluded()
    {
        return isset($this->IsIncluded) ? $this->IsIncluded : null;
    }
    /**
     * Set IsIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncluded
     * @return \patest\StructType\Reporting_SimplifiedFactPriceModifier
     */
    public function setIsIncluded($isIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncluded) && !is_bool($isIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncluded, true), gettype($isIncluded)), __LINE__);
        }
        if (is_null($isIncluded) || (is_array($isIncluded) && empty($isIncluded))) {
            unset($this->IsIncluded);
        } else {
            $this->IsIncluded = $isIncluded;
        }
        return $this;
    }
    /**
     * Get ItemGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemGuid()
    {
        return isset($this->ItemGuid) ? $this->ItemGuid : null;
    }
    /**
     * Set ItemGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemGuid
     * @return \patest\StructType\Reporting_SimplifiedFactPriceModifier
     */
    public function setItemGuid($itemGuid = null)
    {
        // validation for constraint: string
        if (!is_null($itemGuid) && !is_string($itemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemGuid, true), gettype($itemGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemGuid, true)), __LINE__);
        }
        if (is_null($itemGuid) || (is_array($itemGuid) && empty($itemGuid))) {
            unset($this->ItemGuid);
        } else {
            $this->ItemGuid = $itemGuid;
        }
        return $this;
    }
    /**
     * Get OrganizationGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationGuid()
    {
        return isset($this->OrganizationGuid) ? $this->OrganizationGuid : null;
    }
    /**
     * Set OrganizationGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationGuid
     * @return \patest\StructType\Reporting_SimplifiedFactPriceModifier
     */
    public function setOrganizationGuid($organizationGuid = null)
    {
        // validation for constraint: string
        if (!is_null($organizationGuid) && !is_string($organizationGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationGuid, true), gettype($organizationGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationGuid, true)), __LINE__);
        }
        if (is_null($organizationGuid) || (is_array($organizationGuid) && empty($organizationGuid))) {
            unset($this->OrganizationGuid);
        } else {
            $this->OrganizationGuid = $organizationGuid;
        }
        return $this;
    }
    /**
     * Get PriceModifierDefinitionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceModifierDefinitionGuid()
    {
        return isset($this->PriceModifierDefinitionGuid) ? $this->PriceModifierDefinitionGuid : null;
    }
    /**
     * Set PriceModifierDefinitionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceModifierDefinitionGuid
     * @return \patest\StructType\Reporting_SimplifiedFactPriceModifier
     */
    public function setPriceModifierDefinitionGuid($priceModifierDefinitionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($priceModifierDefinitionGuid) && !is_string($priceModifierDefinitionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceModifierDefinitionGuid, true), gettype($priceModifierDefinitionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceModifierDefinitionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceModifierDefinitionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceModifierDefinitionGuid, true)), __LINE__);
        }
        if (is_null($priceModifierDefinitionGuid) || (is_array($priceModifierDefinitionGuid) && empty($priceModifierDefinitionGuid))) {
            unset($this->PriceModifierDefinitionGuid);
        } else {
            $this->PriceModifierDefinitionGuid = $priceModifierDefinitionGuid;
        }
        return $this;
    }
    /**
     * Get PriceModifierName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceModifierName()
    {
        return isset($this->PriceModifierName) ? $this->PriceModifierName : null;
    }
    /**
     * Set PriceModifierName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceModifierName
     * @return \patest\StructType\Reporting_SimplifiedFactPriceModifier
     */
    public function setPriceModifierName(\patest\StructType\GlobalString $priceModifierName = null)
    {
        if (is_null($priceModifierName) || (is_array($priceModifierName) && empty($priceModifierName))) {
            unset($this->PriceModifierName);
        } else {
            $this->PriceModifierName = $priceModifierName;
        }
        return $this;
    }
    /**
     * Get PriceModifierTypeEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceModifierTypeEnum()
    {
        return isset($this->PriceModifierTypeEnum) ? $this->PriceModifierTypeEnum : null;
    }
    /**
     * Set PriceModifierTypeEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceModifierTypeEnum
     * @return \patest\StructType\Reporting_SimplifiedFactPriceModifier
     */
    public function setPriceModifierTypeEnum($priceModifierTypeEnum = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierType::valueIsValid($priceModifierTypeEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierType', is_array($priceModifierTypeEnum) ? implode(', ', $priceModifierTypeEnum) : var_export($priceModifierTypeEnum, true), implode(', ', \patest\EnumType\PriceModifierType::getValidValues())), __LINE__);
        }
        if (is_null($priceModifierTypeEnum) || (is_array($priceModifierTypeEnum) && empty($priceModifierTypeEnum))) {
            unset($this->PriceModifierTypeEnum);
        } else {
            $this->PriceModifierTypeEnum = $priceModifierTypeEnum;
        }
        return $this;
    }
}
