<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reporting.InternalReportDefinition StructType
 * @subpackage Structs
 */
class Reporting_InternalReportDefinition extends MaintainableGlobalizedEntity
{
    /**
     * The AccountSalutationFormatId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountSalutationFormatId;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Author;
    /**
     * The AvailableForList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AvailableForList;
    /**
     * The BaseReportID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BaseReportID;
    /**
     * The CanExport
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanExport;
    /**
     * The CanGetRawData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanGetRawData;
    /**
     * The CanImport
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanImport;
    /**
     * The CanModify
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanModify;
    /**
     * The CanRun
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanRun;
    /**
     * The CanSaveAs
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanSaveAs;
    /**
     * The CanSchedule
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanSchedule;
    /**
     * The CanUseDataSecurityRunAsSeller
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanUseDataSecurityRunAsSeller;
    /**
     * The Categories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Categories
     */
    public $Categories;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Code;
    /**
     * The CompiledRDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompiledRDL;
    /**
     * The CustomerSalutationFormatId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerSalutationFormatId;
    /**
     * The DataSecurityRunAsSeller
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DataSecurityRunAsSeller;
    /**
     * The EnabledForDashboard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnabledForDashboard;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Image;
    /**
     * The IsCopyOfBaseReport
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCopyOfBaseReport;
    /**
     * The IsIncompleteReport
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncompleteReport;
    /**
     * The IsReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReport;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The IsTempReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTempReport;
    /**
     * The LastRun
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastRun;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OthersCanModify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OthersCanModify;
    /**
     * The OthersCanRun
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OthersCanRun;
    /**
     * The ProfilesCanModify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProfilesCanModify
     */
    public $ProfilesCanModify;
    /**
     * The ProfilesCanRun
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProfilesCanRun
     */
    public $ProfilesCanRun;
    /**
     * The QueryEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QueryBuilder_Query
     */
    public $QueryEntity;
    /**
     * The RDLDataSets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RDLDataSets;
    /**
     * The RDLDataSources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RDLDataSources;
    /**
     * The RDLParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RDLParameters;
    /**
     * The RDLTemplate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Reporting_RDLTemplate
     */
    public $RDLTemplate;
    /**
     * The RDLTemplateID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RDLTemplateID;
    /**
     * The RelatedFeature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedFeature;
    /**
     * The ReportCatalogNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportCatalogNumber;
    /**
     * The ReportDefinitionData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportDefinitionData;
    /**
     * The ReportImplementaionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportImplementaionType;
    /**
     * The ReportKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportKey;
    /**
     * The ReportPreviewImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportPreviewImage;
    /**
     * The ReportPreviewImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportPreviewImageUrl;
    /**
     * The ReportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportType;
    /**
     * The RequestEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestEntityName;
    /**
     * The RequestScreen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestScreen;
    /**
     * The SupportedClientApp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupportedClientApp;
    /**
     * The UpdateLatencySec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UpdateLatencySec;
    /**
     * The UpToDateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpToDateType;
    /**
     * The VersionOf
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VersionOf;
    /**
     * The Visible
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Visible;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Reporting.InternalReportDefinition
     * @uses Reporting_InternalReportDefinition::setAccountSalutationFormatId()
     * @uses Reporting_InternalReportDefinition::setAuthor()
     * @uses Reporting_InternalReportDefinition::setAvailableForList()
     * @uses Reporting_InternalReportDefinition::setBaseReportID()
     * @uses Reporting_InternalReportDefinition::setCanExport()
     * @uses Reporting_InternalReportDefinition::setCanGetRawData()
     * @uses Reporting_InternalReportDefinition::setCanImport()
     * @uses Reporting_InternalReportDefinition::setCanModify()
     * @uses Reporting_InternalReportDefinition::setCanRun()
     * @uses Reporting_InternalReportDefinition::setCanSaveAs()
     * @uses Reporting_InternalReportDefinition::setCanSchedule()
     * @uses Reporting_InternalReportDefinition::setCanUseDataSecurityRunAsSeller()
     * @uses Reporting_InternalReportDefinition::setCategories()
     * @uses Reporting_InternalReportDefinition::setCategory()
     * @uses Reporting_InternalReportDefinition::setCode()
     * @uses Reporting_InternalReportDefinition::setCompiledRDL()
     * @uses Reporting_InternalReportDefinition::setCustomerSalutationFormatId()
     * @uses Reporting_InternalReportDefinition::setDataSecurityRunAsSeller()
     * @uses Reporting_InternalReportDefinition::setEnabledForDashboard()
     * @uses Reporting_InternalReportDefinition::setEntityName()
     * @uses Reporting_InternalReportDefinition::setEntityVersion()
     * @uses Reporting_InternalReportDefinition::setImage()
     * @uses Reporting_InternalReportDefinition::setIsCopyOfBaseReport()
     * @uses Reporting_InternalReportDefinition::setIsIncompleteReport()
     * @uses Reporting_InternalReportDefinition::setIsReport()
     * @uses Reporting_InternalReportDefinition::setIsSystem()
     * @uses Reporting_InternalReportDefinition::setIsTempReport()
     * @uses Reporting_InternalReportDefinition::setLastRun()
     * @uses Reporting_InternalReportDefinition::setOrdinal()
     * @uses Reporting_InternalReportDefinition::setOrganizationUnitId()
     * @uses Reporting_InternalReportDefinition::setOthersCanModify()
     * @uses Reporting_InternalReportDefinition::setOthersCanRun()
     * @uses Reporting_InternalReportDefinition::setProfilesCanModify()
     * @uses Reporting_InternalReportDefinition::setProfilesCanRun()
     * @uses Reporting_InternalReportDefinition::setQueryEntity()
     * @uses Reporting_InternalReportDefinition::setRDLDataSets()
     * @uses Reporting_InternalReportDefinition::setRDLDataSources()
     * @uses Reporting_InternalReportDefinition::setRDLParameters()
     * @uses Reporting_InternalReportDefinition::setRDLTemplate()
     * @uses Reporting_InternalReportDefinition::setRDLTemplateID()
     * @uses Reporting_InternalReportDefinition::setRelatedFeature()
     * @uses Reporting_InternalReportDefinition::setReportCatalogNumber()
     * @uses Reporting_InternalReportDefinition::setReportDefinitionData()
     * @uses Reporting_InternalReportDefinition::setReportImplementaionType()
     * @uses Reporting_InternalReportDefinition::setReportKey()
     * @uses Reporting_InternalReportDefinition::setReportPreviewImage()
     * @uses Reporting_InternalReportDefinition::setReportPreviewImageUrl()
     * @uses Reporting_InternalReportDefinition::setReportType()
     * @uses Reporting_InternalReportDefinition::setRequestEntityName()
     * @uses Reporting_InternalReportDefinition::setRequestScreen()
     * @uses Reporting_InternalReportDefinition::setSupportedClientApp()
     * @uses Reporting_InternalReportDefinition::setUpdateLatencySec()
     * @uses Reporting_InternalReportDefinition::setUpToDateType()
     * @uses Reporting_InternalReportDefinition::setVersionOf()
     * @uses Reporting_InternalReportDefinition::setVisible()
     * @uses Reporting_InternalReportDefinition::setVisibleBySubordinates()
     * @param string $accountSalutationFormatId
     * @param string $author
     * @param bool $availableForList
     * @param string $baseReportID
     * @param bool $canExport
     * @param bool $canGetRawData
     * @param bool $canImport
     * @param bool $canModify
     * @param bool $canRun
     * @param bool $canSaveAs
     * @param bool $canSchedule
     * @param bool $canUseDataSecurityRunAsSeller
     * @param \patest\StructType\Categories $categories
     * @param string $category
     * @param int $code
     * @param string $compiledRDL
     * @param string $customerSalutationFormatId
     * @param bool $dataSecurityRunAsSeller
     * @param bool $enabledForDashboard
     * @param string $entityName
     * @param string $entityVersion
     * @param string $image
     * @param bool $isCopyOfBaseReport
     * @param bool $isIncompleteReport
     * @param bool $isReport
     * @param bool $isSystem
     * @param bool $isTempReport
     * @param string $lastRun
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param string $othersCanModify
     * @param string $othersCanRun
     * @param \patest\StructType\ProfilesCanModify $profilesCanModify
     * @param \patest\StructType\ProfilesCanRun $profilesCanRun
     * @param \patest\StructType\QueryBuilder_Query $queryEntity
     * @param string $rDLDataSets
     * @param string $rDLDataSources
     * @param string $rDLParameters
     * @param \patest\StructType\Reporting_RDLTemplate $rDLTemplate
     * @param string $rDLTemplateID
     * @param string $relatedFeature
     * @param string $reportCatalogNumber
     * @param string $reportDefinitionData
     * @param string $reportImplementaionType
     * @param string $reportKey
     * @param string $reportPreviewImage
     * @param string $reportPreviewImageUrl
     * @param string $reportType
     * @param string $requestEntityName
     * @param string $requestScreen
     * @param string $supportedClientApp
     * @param int $updateLatencySec
     * @param string $upToDateType
     * @param string $versionOf
     * @param bool $visible
     * @param bool $visibleBySubordinates
     */
    public function __construct($accountSalutationFormatId = null, $author = null, $availableForList = null, $baseReportID = null, $canExport = null, $canGetRawData = null, $canImport = null, $canModify = null, $canRun = null, $canSaveAs = null, $canSchedule = null, $canUseDataSecurityRunAsSeller = null, \patest\StructType\Categories $categories = null, $category = null, $code = null, $compiledRDL = null, $customerSalutationFormatId = null, $dataSecurityRunAsSeller = null, $enabledForDashboard = null, $entityName = null, $entityVersion = null, $image = null, $isCopyOfBaseReport = null, $isIncompleteReport = null, $isReport = null, $isSystem = null, $isTempReport = null, $lastRun = null, $ordinal = null, $organizationUnitId = null, $othersCanModify = null, $othersCanRun = null, \patest\StructType\ProfilesCanModify $profilesCanModify = null, \patest\StructType\ProfilesCanRun $profilesCanRun = null, \patest\StructType\QueryBuilder_Query $queryEntity = null, $rDLDataSets = null, $rDLDataSources = null, $rDLParameters = null, \patest\StructType\Reporting_RDLTemplate $rDLTemplate = null, $rDLTemplateID = null, $relatedFeature = null, $reportCatalogNumber = null, $reportDefinitionData = null, $reportImplementaionType = null, $reportKey = null, $reportPreviewImage = null, $reportPreviewImageUrl = null, $reportType = null, $requestEntityName = null, $requestScreen = null, $supportedClientApp = null, $updateLatencySec = null, $upToDateType = null, $versionOf = null, $visible = null, $visibleBySubordinates = null)
    {
        $this
            ->setAccountSalutationFormatId($accountSalutationFormatId)
            ->setAuthor($author)
            ->setAvailableForList($availableForList)
            ->setBaseReportID($baseReportID)
            ->setCanExport($canExport)
            ->setCanGetRawData($canGetRawData)
            ->setCanImport($canImport)
            ->setCanModify($canModify)
            ->setCanRun($canRun)
            ->setCanSaveAs($canSaveAs)
            ->setCanSchedule($canSchedule)
            ->setCanUseDataSecurityRunAsSeller($canUseDataSecurityRunAsSeller)
            ->setCategories($categories)
            ->setCategory($category)
            ->setCode($code)
            ->setCompiledRDL($compiledRDL)
            ->setCustomerSalutationFormatId($customerSalutationFormatId)
            ->setDataSecurityRunAsSeller($dataSecurityRunAsSeller)
            ->setEnabledForDashboard($enabledForDashboard)
            ->setEntityName($entityName)
            ->setEntityVersion($entityVersion)
            ->setImage($image)
            ->setIsCopyOfBaseReport($isCopyOfBaseReport)
            ->setIsIncompleteReport($isIncompleteReport)
            ->setIsReport($isReport)
            ->setIsSystem($isSystem)
            ->setIsTempReport($isTempReport)
            ->setLastRun($lastRun)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOthersCanModify($othersCanModify)
            ->setOthersCanRun($othersCanRun)
            ->setProfilesCanModify($profilesCanModify)
            ->setProfilesCanRun($profilesCanRun)
            ->setQueryEntity($queryEntity)
            ->setRDLDataSets($rDLDataSets)
            ->setRDLDataSources($rDLDataSources)
            ->setRDLParameters($rDLParameters)
            ->setRDLTemplate($rDLTemplate)
            ->setRDLTemplateID($rDLTemplateID)
            ->setRelatedFeature($relatedFeature)
            ->setReportCatalogNumber($reportCatalogNumber)
            ->setReportDefinitionData($reportDefinitionData)
            ->setReportImplementaionType($reportImplementaionType)
            ->setReportKey($reportKey)
            ->setReportPreviewImage($reportPreviewImage)
            ->setReportPreviewImageUrl($reportPreviewImageUrl)
            ->setReportType($reportType)
            ->setRequestEntityName($requestEntityName)
            ->setRequestScreen($requestScreen)
            ->setSupportedClientApp($supportedClientApp)
            ->setUpdateLatencySec($updateLatencySec)
            ->setUpToDateType($upToDateType)
            ->setVersionOf($versionOf)
            ->setVisible($visible)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AccountSalutationFormatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountSalutationFormatId()
    {
        return isset($this->AccountSalutationFormatId) ? $this->AccountSalutationFormatId : null;
    }
    /**
     * Set AccountSalutationFormatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountSalutationFormatId
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setAccountSalutationFormatId($accountSalutationFormatId = null)
    {
        // validation for constraint: string
        if (!is_null($accountSalutationFormatId) && !is_string($accountSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountSalutationFormatId, true), gettype($accountSalutationFormatId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountSalutationFormatId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountSalutationFormatId, true)), __LINE__);
        }
        if (is_null($accountSalutationFormatId) || (is_array($accountSalutationFormatId) && empty($accountSalutationFormatId))) {
            unset($this->AccountSalutationFormatId);
        } else {
            $this->AccountSalutationFormatId = $accountSalutationFormatId;
        }
        return $this;
    }
    /**
     * Get Author value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthor()
    {
        return isset($this->Author) ? $this->Author : null;
    }
    /**
     * Set Author value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $author
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        if (is_null($author) || (is_array($author) && empty($author))) {
            unset($this->Author);
        } else {
            $this->Author = $author;
        }
        return $this;
    }
    /**
     * Get AvailableForList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAvailableForList()
    {
        return isset($this->AvailableForList) ? $this->AvailableForList : null;
    }
    /**
     * Set AvailableForList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $availableForList
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setAvailableForList($availableForList = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForList) && !is_bool($availableForList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForList, true), gettype($availableForList)), __LINE__);
        }
        if (is_null($availableForList) || (is_array($availableForList) && empty($availableForList))) {
            unset($this->AvailableForList);
        } else {
            $this->AvailableForList = $availableForList;
        }
        return $this;
    }
    /**
     * Get BaseReportID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseReportID()
    {
        return isset($this->BaseReportID) ? $this->BaseReportID : null;
    }
    /**
     * Set BaseReportID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseReportID
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setBaseReportID($baseReportID = null)
    {
        // validation for constraint: string
        if (!is_null($baseReportID) && !is_string($baseReportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseReportID, true), gettype($baseReportID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($baseReportID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $baseReportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($baseReportID, true)), __LINE__);
        }
        if (is_null($baseReportID) || (is_array($baseReportID) && empty($baseReportID))) {
            unset($this->BaseReportID);
        } else {
            $this->BaseReportID = $baseReportID;
        }
        return $this;
    }
    /**
     * Get CanExport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanExport()
    {
        return isset($this->CanExport) ? $this->CanExport : null;
    }
    /**
     * Set CanExport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canExport
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCanExport($canExport = null)
    {
        // validation for constraint: boolean
        if (!is_null($canExport) && !is_bool($canExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canExport, true), gettype($canExport)), __LINE__);
        }
        if (is_null($canExport) || (is_array($canExport) && empty($canExport))) {
            unset($this->CanExport);
        } else {
            $this->CanExport = $canExport;
        }
        return $this;
    }
    /**
     * Get CanGetRawData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanGetRawData()
    {
        return isset($this->CanGetRawData) ? $this->CanGetRawData : null;
    }
    /**
     * Set CanGetRawData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canGetRawData
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCanGetRawData($canGetRawData = null)
    {
        // validation for constraint: boolean
        if (!is_null($canGetRawData) && !is_bool($canGetRawData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canGetRawData, true), gettype($canGetRawData)), __LINE__);
        }
        if (is_null($canGetRawData) || (is_array($canGetRawData) && empty($canGetRawData))) {
            unset($this->CanGetRawData);
        } else {
            $this->CanGetRawData = $canGetRawData;
        }
        return $this;
    }
    /**
     * Get CanImport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanImport()
    {
        return isset($this->CanImport) ? $this->CanImport : null;
    }
    /**
     * Set CanImport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canImport
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCanImport($canImport = null)
    {
        // validation for constraint: boolean
        if (!is_null($canImport) && !is_bool($canImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canImport, true), gettype($canImport)), __LINE__);
        }
        if (is_null($canImport) || (is_array($canImport) && empty($canImport))) {
            unset($this->CanImport);
        } else {
            $this->CanImport = $canImport;
        }
        return $this;
    }
    /**
     * Get CanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanModify()
    {
        return isset($this->CanModify) ? $this->CanModify : null;
    }
    /**
     * Set CanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canModify
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCanModify($canModify = null)
    {
        // validation for constraint: boolean
        if (!is_null($canModify) && !is_bool($canModify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canModify, true), gettype($canModify)), __LINE__);
        }
        if (is_null($canModify) || (is_array($canModify) && empty($canModify))) {
            unset($this->CanModify);
        } else {
            $this->CanModify = $canModify;
        }
        return $this;
    }
    /**
     * Get CanRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanRun()
    {
        return isset($this->CanRun) ? $this->CanRun : null;
    }
    /**
     * Set CanRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canRun
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCanRun($canRun = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRun) && !is_bool($canRun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRun, true), gettype($canRun)), __LINE__);
        }
        if (is_null($canRun) || (is_array($canRun) && empty($canRun))) {
            unset($this->CanRun);
        } else {
            $this->CanRun = $canRun;
        }
        return $this;
    }
    /**
     * Get CanSaveAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanSaveAs()
    {
        return isset($this->CanSaveAs) ? $this->CanSaveAs : null;
    }
    /**
     * Set CanSaveAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canSaveAs
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCanSaveAs($canSaveAs = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSaveAs) && !is_bool($canSaveAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canSaveAs, true), gettype($canSaveAs)), __LINE__);
        }
        if (is_null($canSaveAs) || (is_array($canSaveAs) && empty($canSaveAs))) {
            unset($this->CanSaveAs);
        } else {
            $this->CanSaveAs = $canSaveAs;
        }
        return $this;
    }
    /**
     * Get CanSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanSchedule()
    {
        return isset($this->CanSchedule) ? $this->CanSchedule : null;
    }
    /**
     * Set CanSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canSchedule
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCanSchedule($canSchedule = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSchedule) && !is_bool($canSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canSchedule, true), gettype($canSchedule)), __LINE__);
        }
        if (is_null($canSchedule) || (is_array($canSchedule) && empty($canSchedule))) {
            unset($this->CanSchedule);
        } else {
            $this->CanSchedule = $canSchedule;
        }
        return $this;
    }
    /**
     * Get CanUseDataSecurityRunAsSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUseDataSecurityRunAsSeller()
    {
        return isset($this->CanUseDataSecurityRunAsSeller) ? $this->CanUseDataSecurityRunAsSeller : null;
    }
    /**
     * Set CanUseDataSecurityRunAsSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUseDataSecurityRunAsSeller
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCanUseDataSecurityRunAsSeller($canUseDataSecurityRunAsSeller = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUseDataSecurityRunAsSeller) && !is_bool($canUseDataSecurityRunAsSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUseDataSecurityRunAsSeller, true), gettype($canUseDataSecurityRunAsSeller)), __LINE__);
        }
        if (is_null($canUseDataSecurityRunAsSeller) || (is_array($canUseDataSecurityRunAsSeller) && empty($canUseDataSecurityRunAsSeller))) {
            unset($this->CanUseDataSecurityRunAsSeller);
        } else {
            $this->CanUseDataSecurityRunAsSeller = $canUseDataSecurityRunAsSeller;
        }
        return $this;
    }
    /**
     * Get Categories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Categories|null
     */
    public function getCategories()
    {
        return isset($this->Categories) ? $this->Categories : null;
    }
    /**
     * Set Categories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Categories $categories
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCategories(\patest\StructType\Categories $categories = null)
    {
        if (is_null($categories) || (is_array($categories) && empty($categories))) {
            unset($this->Categories);
        } else {
            $this->Categories = $categories;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $code
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get CompiledRDL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompiledRDL()
    {
        return isset($this->CompiledRDL) ? $this->CompiledRDL : null;
    }
    /**
     * Set CompiledRDL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compiledRDL
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCompiledRDL($compiledRDL = null)
    {
        // validation for constraint: string
        if (!is_null($compiledRDL) && !is_string($compiledRDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compiledRDL, true), gettype($compiledRDL)), __LINE__);
        }
        if (is_null($compiledRDL) || (is_array($compiledRDL) && empty($compiledRDL))) {
            unset($this->CompiledRDL);
        } else {
            $this->CompiledRDL = $compiledRDL;
        }
        return $this;
    }
    /**
     * Get CustomerSalutationFormatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerSalutationFormatId()
    {
        return isset($this->CustomerSalutationFormatId) ? $this->CustomerSalutationFormatId : null;
    }
    /**
     * Set CustomerSalutationFormatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerSalutationFormatId
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setCustomerSalutationFormatId($customerSalutationFormatId = null)
    {
        // validation for constraint: string
        if (!is_null($customerSalutationFormatId) && !is_string($customerSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerSalutationFormatId, true), gettype($customerSalutationFormatId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerSalutationFormatId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerSalutationFormatId, true)), __LINE__);
        }
        if (is_null($customerSalutationFormatId) || (is_array($customerSalutationFormatId) && empty($customerSalutationFormatId))) {
            unset($this->CustomerSalutationFormatId);
        } else {
            $this->CustomerSalutationFormatId = $customerSalutationFormatId;
        }
        return $this;
    }
    /**
     * Get DataSecurityRunAsSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDataSecurityRunAsSeller()
    {
        return isset($this->DataSecurityRunAsSeller) ? $this->DataSecurityRunAsSeller : null;
    }
    /**
     * Set DataSecurityRunAsSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dataSecurityRunAsSeller
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setDataSecurityRunAsSeller($dataSecurityRunAsSeller = null)
    {
        // validation for constraint: boolean
        if (!is_null($dataSecurityRunAsSeller) && !is_bool($dataSecurityRunAsSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dataSecurityRunAsSeller, true), gettype($dataSecurityRunAsSeller)), __LINE__);
        }
        if (is_null($dataSecurityRunAsSeller) || (is_array($dataSecurityRunAsSeller) && empty($dataSecurityRunAsSeller))) {
            unset($this->DataSecurityRunAsSeller);
        } else {
            $this->DataSecurityRunAsSeller = $dataSecurityRunAsSeller;
        }
        return $this;
    }
    /**
     * Get EnabledForDashboard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnabledForDashboard()
    {
        return isset($this->EnabledForDashboard) ? $this->EnabledForDashboard : null;
    }
    /**
     * Set EnabledForDashboard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enabledForDashboard
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setEnabledForDashboard($enabledForDashboard = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabledForDashboard) && !is_bool($enabledForDashboard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabledForDashboard, true), gettype($enabledForDashboard)), __LINE__);
        }
        if (is_null($enabledForDashboard) || (is_array($enabledForDashboard) && empty($enabledForDashboard))) {
            unset($this->EnabledForDashboard);
        } else {
            $this->EnabledForDashboard = $enabledForDashboard;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get Image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * Set Image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get IsCopyOfBaseReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCopyOfBaseReport()
    {
        return isset($this->IsCopyOfBaseReport) ? $this->IsCopyOfBaseReport : null;
    }
    /**
     * Set IsCopyOfBaseReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCopyOfBaseReport
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setIsCopyOfBaseReport($isCopyOfBaseReport = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCopyOfBaseReport) && !is_bool($isCopyOfBaseReport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCopyOfBaseReport, true), gettype($isCopyOfBaseReport)), __LINE__);
        }
        if (is_null($isCopyOfBaseReport) || (is_array($isCopyOfBaseReport) && empty($isCopyOfBaseReport))) {
            unset($this->IsCopyOfBaseReport);
        } else {
            $this->IsCopyOfBaseReport = $isCopyOfBaseReport;
        }
        return $this;
    }
    /**
     * Get IsIncompleteReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncompleteReport()
    {
        return isset($this->IsIncompleteReport) ? $this->IsIncompleteReport : null;
    }
    /**
     * Set IsIncompleteReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncompleteReport
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setIsIncompleteReport($isIncompleteReport = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncompleteReport) && !is_bool($isIncompleteReport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncompleteReport, true), gettype($isIncompleteReport)), __LINE__);
        }
        if (is_null($isIncompleteReport) || (is_array($isIncompleteReport) && empty($isIncompleteReport))) {
            unset($this->IsIncompleteReport);
        } else {
            $this->IsIncompleteReport = $isIncompleteReport;
        }
        return $this;
    }
    /**
     * Get IsReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReport()
    {
        return isset($this->IsReport) ? $this->IsReport : null;
    }
    /**
     * Set IsReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReport
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setIsReport($isReport = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReport) && !is_bool($isReport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReport, true), gettype($isReport)), __LINE__);
        }
        if (is_null($isReport) || (is_array($isReport) && empty($isReport))) {
            unset($this->IsReport);
        } else {
            $this->IsReport = $isReport;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get IsTempReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTempReport()
    {
        return isset($this->IsTempReport) ? $this->IsTempReport : null;
    }
    /**
     * Set IsTempReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTempReport
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setIsTempReport($isTempReport = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTempReport) && !is_bool($isTempReport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTempReport, true), gettype($isTempReport)), __LINE__);
        }
        if (is_null($isTempReport) || (is_array($isTempReport) && empty($isTempReport))) {
            unset($this->IsTempReport);
        } else {
            $this->IsTempReport = $isTempReport;
        }
        return $this;
    }
    /**
     * Get LastRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastRun()
    {
        return isset($this->LastRun) ? $this->LastRun : null;
    }
    /**
     * Set LastRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastRun
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setLastRun($lastRun = null)
    {
        // validation for constraint: string
        if (!is_null($lastRun) && !is_string($lastRun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRun, true), gettype($lastRun)), __LINE__);
        }
        if (is_null($lastRun) || (is_array($lastRun) && empty($lastRun))) {
            unset($this->LastRun);
        } else {
            $this->LastRun = $lastRun;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OthersCanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOthersCanModify()
    {
        return isset($this->OthersCanModify) ? $this->OthersCanModify : null;
    }
    /**
     * Set OthersCanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportPermission::valueIsValid()
     * @uses \patest\EnumType\ReportPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $othersCanModify
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setOthersCanModify($othersCanModify = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportPermission::valueIsValid($othersCanModify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportPermission', is_array($othersCanModify) ? implode(', ', $othersCanModify) : var_export($othersCanModify, true), implode(', ', \patest\EnumType\ReportPermission::getValidValues())), __LINE__);
        }
        if (is_null($othersCanModify) || (is_array($othersCanModify) && empty($othersCanModify))) {
            unset($this->OthersCanModify);
        } else {
            $this->OthersCanModify = $othersCanModify;
        }
        return $this;
    }
    /**
     * Get OthersCanRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOthersCanRun()
    {
        return isset($this->OthersCanRun) ? $this->OthersCanRun : null;
    }
    /**
     * Set OthersCanRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportPermission::valueIsValid()
     * @uses \patest\EnumType\ReportPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $othersCanRun
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setOthersCanRun($othersCanRun = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportPermission::valueIsValid($othersCanRun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportPermission', is_array($othersCanRun) ? implode(', ', $othersCanRun) : var_export($othersCanRun, true), implode(', ', \patest\EnumType\ReportPermission::getValidValues())), __LINE__);
        }
        if (is_null($othersCanRun) || (is_array($othersCanRun) && empty($othersCanRun))) {
            unset($this->OthersCanRun);
        } else {
            $this->OthersCanRun = $othersCanRun;
        }
        return $this;
    }
    /**
     * Get ProfilesCanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProfilesCanModify|null
     */
    public function getProfilesCanModify()
    {
        return isset($this->ProfilesCanModify) ? $this->ProfilesCanModify : null;
    }
    /**
     * Set ProfilesCanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProfilesCanModify $profilesCanModify
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setProfilesCanModify(\patest\StructType\ProfilesCanModify $profilesCanModify = null)
    {
        if (is_null($profilesCanModify) || (is_array($profilesCanModify) && empty($profilesCanModify))) {
            unset($this->ProfilesCanModify);
        } else {
            $this->ProfilesCanModify = $profilesCanModify;
        }
        return $this;
    }
    /**
     * Get ProfilesCanRun value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProfilesCanRun|null
     */
    public function getProfilesCanRun()
    {
        return isset($this->ProfilesCanRun) ? $this->ProfilesCanRun : null;
    }
    /**
     * Set ProfilesCanRun value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProfilesCanRun $profilesCanRun
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setProfilesCanRun(\patest\StructType\ProfilesCanRun $profilesCanRun = null)
    {
        if (is_null($profilesCanRun) || (is_array($profilesCanRun) && empty($profilesCanRun))) {
            unset($this->ProfilesCanRun);
        } else {
            $this->ProfilesCanRun = $profilesCanRun;
        }
        return $this;
    }
    /**
     * Get QueryEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QueryBuilder_Query|null
     */
    public function getQueryEntity()
    {
        return isset($this->QueryEntity) ? $this->QueryEntity : null;
    }
    /**
     * Set QueryEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QueryBuilder_Query $queryEntity
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setQueryEntity(\patest\StructType\QueryBuilder_Query $queryEntity = null)
    {
        if (is_null($queryEntity) || (is_array($queryEntity) && empty($queryEntity))) {
            unset($this->QueryEntity);
        } else {
            $this->QueryEntity = $queryEntity;
        }
        return $this;
    }
    /**
     * Get RDLDataSets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRDLDataSets()
    {
        return isset($this->RDLDataSets) ? $this->RDLDataSets : null;
    }
    /**
     * Set RDLDataSets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rDLDataSets
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setRDLDataSets($rDLDataSets = null)
    {
        // validation for constraint: string
        if (!is_null($rDLDataSets) && !is_string($rDLDataSets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rDLDataSets, true), gettype($rDLDataSets)), __LINE__);
        }
        if (is_null($rDLDataSets) || (is_array($rDLDataSets) && empty($rDLDataSets))) {
            unset($this->RDLDataSets);
        } else {
            $this->RDLDataSets = $rDLDataSets;
        }
        return $this;
    }
    /**
     * Get RDLDataSources value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRDLDataSources()
    {
        return isset($this->RDLDataSources) ? $this->RDLDataSources : null;
    }
    /**
     * Set RDLDataSources value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rDLDataSources
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setRDLDataSources($rDLDataSources = null)
    {
        // validation for constraint: string
        if (!is_null($rDLDataSources) && !is_string($rDLDataSources)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rDLDataSources, true), gettype($rDLDataSources)), __LINE__);
        }
        if (is_null($rDLDataSources) || (is_array($rDLDataSources) && empty($rDLDataSources))) {
            unset($this->RDLDataSources);
        } else {
            $this->RDLDataSources = $rDLDataSources;
        }
        return $this;
    }
    /**
     * Get RDLParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRDLParameters()
    {
        return isset($this->RDLParameters) ? $this->RDLParameters : null;
    }
    /**
     * Set RDLParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rDLParameters
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setRDLParameters($rDLParameters = null)
    {
        // validation for constraint: string
        if (!is_null($rDLParameters) && !is_string($rDLParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rDLParameters, true), gettype($rDLParameters)), __LINE__);
        }
        if (is_null($rDLParameters) || (is_array($rDLParameters) && empty($rDLParameters))) {
            unset($this->RDLParameters);
        } else {
            $this->RDLParameters = $rDLParameters;
        }
        return $this;
    }
    /**
     * Get RDLTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Reporting_RDLTemplate|null
     */
    public function getRDLTemplate()
    {
        return isset($this->RDLTemplate) ? $this->RDLTemplate : null;
    }
    /**
     * Set RDLTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Reporting_RDLTemplate $rDLTemplate
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setRDLTemplate(\patest\StructType\Reporting_RDLTemplate $rDLTemplate = null)
    {
        if (is_null($rDLTemplate) || (is_array($rDLTemplate) && empty($rDLTemplate))) {
            unset($this->RDLTemplate);
        } else {
            $this->RDLTemplate = $rDLTemplate;
        }
        return $this;
    }
    /**
     * Get RDLTemplateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRDLTemplateID()
    {
        return isset($this->RDLTemplateID) ? $this->RDLTemplateID : null;
    }
    /**
     * Set RDLTemplateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rDLTemplateID
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setRDLTemplateID($rDLTemplateID = null)
    {
        // validation for constraint: string
        if (!is_null($rDLTemplateID) && !is_string($rDLTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rDLTemplateID, true), gettype($rDLTemplateID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($rDLTemplateID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $rDLTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($rDLTemplateID, true)), __LINE__);
        }
        if (is_null($rDLTemplateID) || (is_array($rDLTemplateID) && empty($rDLTemplateID))) {
            unset($this->RDLTemplateID);
        } else {
            $this->RDLTemplateID = $rDLTemplateID;
        }
        return $this;
    }
    /**
     * Get RelatedFeature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedFeature()
    {
        return isset($this->RelatedFeature) ? $this->RelatedFeature : null;
    }
    /**
     * Set RelatedFeature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedFeature
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setRelatedFeature($relatedFeature = null)
    {
        // validation for constraint: string
        if (!is_null($relatedFeature) && !is_string($relatedFeature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedFeature, true), gettype($relatedFeature)), __LINE__);
        }
        if (is_null($relatedFeature) || (is_array($relatedFeature) && empty($relatedFeature))) {
            unset($this->RelatedFeature);
        } else {
            $this->RelatedFeature = $relatedFeature;
        }
        return $this;
    }
    /**
     * Get ReportCatalogNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportCatalogNumber()
    {
        return isset($this->ReportCatalogNumber) ? $this->ReportCatalogNumber : null;
    }
    /**
     * Set ReportCatalogNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportCatalogNumber
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setReportCatalogNumber($reportCatalogNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reportCatalogNumber) && !is_string($reportCatalogNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportCatalogNumber, true), gettype($reportCatalogNumber)), __LINE__);
        }
        if (is_null($reportCatalogNumber) || (is_array($reportCatalogNumber) && empty($reportCatalogNumber))) {
            unset($this->ReportCatalogNumber);
        } else {
            $this->ReportCatalogNumber = $reportCatalogNumber;
        }
        return $this;
    }
    /**
     * Get ReportDefinitionData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportDefinitionData()
    {
        return isset($this->ReportDefinitionData) ? $this->ReportDefinitionData : null;
    }
    /**
     * Set ReportDefinitionData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportDefinitionData
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setReportDefinitionData($reportDefinitionData = null)
    {
        // validation for constraint: string
        if (!is_null($reportDefinitionData) && !is_string($reportDefinitionData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportDefinitionData, true), gettype($reportDefinitionData)), __LINE__);
        }
        if (is_null($reportDefinitionData) || (is_array($reportDefinitionData) && empty($reportDefinitionData))) {
            unset($this->ReportDefinitionData);
        } else {
            $this->ReportDefinitionData = $reportDefinitionData;
        }
        return $this;
    }
    /**
     * Get ReportImplementaionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportImplementaionType()
    {
        return isset($this->ReportImplementaionType) ? $this->ReportImplementaionType : null;
    }
    /**
     * Set ReportImplementaionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportImplementaionType::valueIsValid()
     * @uses \patest\EnumType\ReportImplementaionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportImplementaionType
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setReportImplementaionType($reportImplementaionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportImplementaionType::valueIsValid($reportImplementaionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportImplementaionType', is_array($reportImplementaionType) ? implode(', ', $reportImplementaionType) : var_export($reportImplementaionType, true), implode(', ', \patest\EnumType\ReportImplementaionType::getValidValues())), __LINE__);
        }
        if (is_null($reportImplementaionType) || (is_array($reportImplementaionType) && empty($reportImplementaionType))) {
            unset($this->ReportImplementaionType);
        } else {
            $this->ReportImplementaionType = $reportImplementaionType;
        }
        return $this;
    }
    /**
     * Get ReportKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportKey()
    {
        return isset($this->ReportKey) ? $this->ReportKey : null;
    }
    /**
     * Set ReportKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportKey
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setReportKey($reportKey = null)
    {
        // validation for constraint: string
        if (!is_null($reportKey) && !is_string($reportKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportKey, true), gettype($reportKey)), __LINE__);
        }
        if (is_null($reportKey) || (is_array($reportKey) && empty($reportKey))) {
            unset($this->ReportKey);
        } else {
            $this->ReportKey = $reportKey;
        }
        return $this;
    }
    /**
     * Get ReportPreviewImage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportPreviewImage()
    {
        return isset($this->ReportPreviewImage) ? $this->ReportPreviewImage : null;
    }
    /**
     * Set ReportPreviewImage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportPreviewImage
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setReportPreviewImage($reportPreviewImage = null)
    {
        // validation for constraint: string
        if (!is_null($reportPreviewImage) && !is_string($reportPreviewImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportPreviewImage, true), gettype($reportPreviewImage)), __LINE__);
        }
        if (is_null($reportPreviewImage) || (is_array($reportPreviewImage) && empty($reportPreviewImage))) {
            unset($this->ReportPreviewImage);
        } else {
            $this->ReportPreviewImage = $reportPreviewImage;
        }
        return $this;
    }
    /**
     * Get ReportPreviewImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportPreviewImageUrl()
    {
        return isset($this->ReportPreviewImageUrl) ? $this->ReportPreviewImageUrl : null;
    }
    /**
     * Set ReportPreviewImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportPreviewImageUrl
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setReportPreviewImageUrl($reportPreviewImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($reportPreviewImageUrl) && !is_string($reportPreviewImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportPreviewImageUrl, true), gettype($reportPreviewImageUrl)), __LINE__);
        }
        if (is_null($reportPreviewImageUrl) || (is_array($reportPreviewImageUrl) && empty($reportPreviewImageUrl))) {
            unset($this->ReportPreviewImageUrl);
        } else {
            $this->ReportPreviewImageUrl = $reportPreviewImageUrl;
        }
        return $this;
    }
    /**
     * Get ReportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportType()
    {
        return isset($this->ReportType) ? $this->ReportType : null;
    }
    /**
     * Set ReportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportType::valueIsValid()
     * @uses \patest\EnumType\ReportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportType
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setReportType($reportType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportType::valueIsValid($reportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportType', is_array($reportType) ? implode(', ', $reportType) : var_export($reportType, true), implode(', ', \patest\EnumType\ReportType::getValidValues())), __LINE__);
        }
        if (is_null($reportType) || (is_array($reportType) && empty($reportType))) {
            unset($this->ReportType);
        } else {
            $this->ReportType = $reportType;
        }
        return $this;
    }
    /**
     * Get RequestEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestEntityName()
    {
        return isset($this->RequestEntityName) ? $this->RequestEntityName : null;
    }
    /**
     * Set RequestEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestEntityName
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setRequestEntityName($requestEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($requestEntityName) && !is_string($requestEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestEntityName, true), gettype($requestEntityName)), __LINE__);
        }
        if (is_null($requestEntityName) || (is_array($requestEntityName) && empty($requestEntityName))) {
            unset($this->RequestEntityName);
        } else {
            $this->RequestEntityName = $requestEntityName;
        }
        return $this;
    }
    /**
     * Get RequestScreen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestScreen()
    {
        return isset($this->RequestScreen) ? $this->RequestScreen : null;
    }
    /**
     * Set RequestScreen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestScreen
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setRequestScreen($requestScreen = null)
    {
        // validation for constraint: string
        if (!is_null($requestScreen) && !is_string($requestScreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestScreen, true), gettype($requestScreen)), __LINE__);
        }
        if (is_null($requestScreen) || (is_array($requestScreen) && empty($requestScreen))) {
            unset($this->RequestScreen);
        } else {
            $this->RequestScreen = $requestScreen;
        }
        return $this;
    }
    /**
     * Get SupportedClientApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupportedClientApp()
    {
        return isset($this->SupportedClientApp) ? $this->SupportedClientApp : null;
    }
    /**
     * Set SupportedClientApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportingClientApp::valueIsValid()
     * @uses \patest\EnumType\ReportingClientApp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $supportedClientApp
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setSupportedClientApp($supportedClientApp = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportingClientApp::valueIsValid($supportedClientApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportingClientApp', is_array($supportedClientApp) ? implode(', ', $supportedClientApp) : var_export($supportedClientApp, true), implode(', ', \patest\EnumType\ReportingClientApp::getValidValues())), __LINE__);
        }
        if (is_null($supportedClientApp) || (is_array($supportedClientApp) && empty($supportedClientApp))) {
            unset($this->SupportedClientApp);
        } else {
            $this->SupportedClientApp = $supportedClientApp;
        }
        return $this;
    }
    /**
     * Get UpdateLatencySec value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUpdateLatencySec()
    {
        return isset($this->UpdateLatencySec) ? $this->UpdateLatencySec : null;
    }
    /**
     * Set UpdateLatencySec value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $updateLatencySec
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setUpdateLatencySec($updateLatencySec = null)
    {
        // validation for constraint: int
        if (!is_null($updateLatencySec) && !(is_int($updateLatencySec) || ctype_digit($updateLatencySec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateLatencySec, true), gettype($updateLatencySec)), __LINE__);
        }
        if (is_null($updateLatencySec) || (is_array($updateLatencySec) && empty($updateLatencySec))) {
            unset($this->UpdateLatencySec);
        } else {
            $this->UpdateLatencySec = $updateLatencySec;
        }
        return $this;
    }
    /**
     * Get UpToDateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpToDateType()
    {
        return isset($this->UpToDateType) ? $this->UpToDateType : null;
    }
    /**
     * Set UpToDateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportUpdateType::valueIsValid()
     * @uses \patest\EnumType\ReportUpdateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $upToDateType
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setUpToDateType($upToDateType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportUpdateType::valueIsValid($upToDateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportUpdateType', is_array($upToDateType) ? implode(', ', $upToDateType) : var_export($upToDateType, true), implode(', ', \patest\EnumType\ReportUpdateType::getValidValues())), __LINE__);
        }
        if (is_null($upToDateType) || (is_array($upToDateType) && empty($upToDateType))) {
            unset($this->UpToDateType);
        } else {
            $this->UpToDateType = $upToDateType;
        }
        return $this;
    }
    /**
     * Get VersionOf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersionOf()
    {
        return isset($this->VersionOf) ? $this->VersionOf : null;
    }
    /**
     * Set VersionOf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $versionOf
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setVersionOf($versionOf = null)
    {
        // validation for constraint: string
        if (!is_null($versionOf) && !is_string($versionOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionOf, true), gettype($versionOf)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($versionOf) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $versionOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($versionOf, true)), __LINE__);
        }
        if (is_null($versionOf) || (is_array($versionOf) && empty($versionOf))) {
            unset($this->VersionOf);
        } else {
            $this->VersionOf = $versionOf;
        }
        return $this;
    }
    /**
     * Get Visible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisible()
    {
        return isset($this->Visible) ? $this->Visible : null;
    }
    /**
     * Set Visible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visible
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setVisible($visible = null)
    {
        // validation for constraint: boolean
        if (!is_null($visible) && !is_bool($visible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visible, true), gettype($visible)), __LINE__);
        }
        if (is_null($visible) || (is_array($visible) && empty($visible))) {
            unset($this->Visible);
        } else {
            $this->Visible = $visible;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Reporting_InternalReportDefinition
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
