<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportExternalBarcodeUsagesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportExternalBarcodeUsagesRequest
 * @subpackage Structs
 */
class ReportExternalBarcodeUsagesRequest extends ExtensibleDataContract
{
    /**
     * The BarcodeUsages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAccessControl_BarcodeUsage
     */
    public $BarcodeUsages;
    /**
     * The ReportingAccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReportingAccessControlSystemId;
    /**
     * The ReportingAccessControlSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportingAccessControlSystemName;
    /**
     * The ReportingComputerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportingComputerName;
    /**
     * Constructor method for ReportExternalBarcodeUsagesRequest
     * @uses ReportExternalBarcodeUsagesRequest::setBarcodeUsages()
     * @uses ReportExternalBarcodeUsagesRequest::setReportingAccessControlSystemId()
     * @uses ReportExternalBarcodeUsagesRequest::setReportingAccessControlSystemName()
     * @uses ReportExternalBarcodeUsagesRequest::setReportingComputerName()
     * @param \patest\ArrayType\ArrayOfAccessControl_BarcodeUsage $barcodeUsages
     * @param string $reportingAccessControlSystemId
     * @param string $reportingAccessControlSystemName
     * @param string $reportingComputerName
     */
    public function __construct(\patest\ArrayType\ArrayOfAccessControl_BarcodeUsage $barcodeUsages = null, $reportingAccessControlSystemId = null, $reportingAccessControlSystemName = null, $reportingComputerName = null)
    {
        $this
            ->setBarcodeUsages($barcodeUsages)
            ->setReportingAccessControlSystemId($reportingAccessControlSystemId)
            ->setReportingAccessControlSystemName($reportingAccessControlSystemName)
            ->setReportingComputerName($reportingComputerName);
    }
    /**
     * Get BarcodeUsages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAccessControl_BarcodeUsage|null
     */
    public function getBarcodeUsages()
    {
        return isset($this->BarcodeUsages) ? $this->BarcodeUsages : null;
    }
    /**
     * Set BarcodeUsages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAccessControl_BarcodeUsage $barcodeUsages
     * @return \patest\StructType\ReportExternalBarcodeUsagesRequest
     */
    public function setBarcodeUsages(\patest\ArrayType\ArrayOfAccessControl_BarcodeUsage $barcodeUsages = null)
    {
        if (is_null($barcodeUsages) || (is_array($barcodeUsages) && empty($barcodeUsages))) {
            unset($this->BarcodeUsages);
        } else {
            $this->BarcodeUsages = $barcodeUsages;
        }
        return $this;
    }
    /**
     * Get ReportingAccessControlSystemId value
     * @return string|null
     */
    public function getReportingAccessControlSystemId()
    {
        return $this->ReportingAccessControlSystemId;
    }
    /**
     * Set ReportingAccessControlSystemId value
     * @param string $reportingAccessControlSystemId
     * @return \patest\StructType\ReportExternalBarcodeUsagesRequest
     */
    public function setReportingAccessControlSystemId($reportingAccessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($reportingAccessControlSystemId) && !is_string($reportingAccessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingAccessControlSystemId, true), gettype($reportingAccessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reportingAccessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reportingAccessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reportingAccessControlSystemId, true)), __LINE__);
        }
        $this->ReportingAccessControlSystemId = $reportingAccessControlSystemId;
        return $this;
    }
    /**
     * Get ReportingAccessControlSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportingAccessControlSystemName()
    {
        return isset($this->ReportingAccessControlSystemName) ? $this->ReportingAccessControlSystemName : null;
    }
    /**
     * Set ReportingAccessControlSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportingAccessControlSystemName
     * @return \patest\StructType\ReportExternalBarcodeUsagesRequest
     */
    public function setReportingAccessControlSystemName($reportingAccessControlSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($reportingAccessControlSystemName) && !is_string($reportingAccessControlSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingAccessControlSystemName, true), gettype($reportingAccessControlSystemName)), __LINE__);
        }
        if (is_null($reportingAccessControlSystemName) || (is_array($reportingAccessControlSystemName) && empty($reportingAccessControlSystemName))) {
            unset($this->ReportingAccessControlSystemName);
        } else {
            $this->ReportingAccessControlSystemName = $reportingAccessControlSystemName;
        }
        return $this;
    }
    /**
     * Get ReportingComputerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportingComputerName()
    {
        return isset($this->ReportingComputerName) ? $this->ReportingComputerName : null;
    }
    /**
     * Set ReportingComputerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportingComputerName
     * @return \patest\StructType\ReportExternalBarcodeUsagesRequest
     */
    public function setReportingComputerName($reportingComputerName = null)
    {
        // validation for constraint: string
        if (!is_null($reportingComputerName) && !is_string($reportingComputerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingComputerName, true), gettype($reportingComputerName)), __LINE__);
        }
        if (is_null($reportingComputerName) || (is_array($reportingComputerName) && empty($reportingComputerName))) {
            unset($this->ReportingComputerName);
        } else {
            $this->ReportingComputerName = $reportingComputerName;
        }
        return $this;
    }
}
