<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenderDocumentsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RenderDocumentsResponse
 * @subpackage Structs
 */
class RenderDocumentsResponse extends AbstractStructBase
{
    /**
     * The RenderedDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfRenderSingleDocumentResponse
     */
    public $RenderedDocuments;
    /**
     * Constructor method for RenderDocumentsResponse
     * @uses RenderDocumentsResponse::setRenderedDocuments()
     * @param \patest\ArrayType\ArrayOfRenderSingleDocumentResponse $renderedDocuments
     */
    public function __construct(\patest\ArrayType\ArrayOfRenderSingleDocumentResponse $renderedDocuments = null)
    {
        $this
            ->setRenderedDocuments($renderedDocuments);
    }
    /**
     * Get RenderedDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfRenderSingleDocumentResponse|null
     */
    public function getRenderedDocuments()
    {
        return isset($this->RenderedDocuments) ? $this->RenderedDocuments : null;
    }
    /**
     * Set RenderedDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfRenderSingleDocumentResponse $renderedDocuments
     * @return \patest\StructType\RenderDocumentsResponse
     */
    public function setRenderedDocuments(\patest\ArrayType\ArrayOfRenderSingleDocumentResponse $renderedDocuments = null)
    {
        if (is_null($renderedDocuments) || (is_array($renderedDocuments) && empty($renderedDocuments))) {
            unset($this->RenderedDocuments);
        } else {
            $this->RenderedDocuments = $renderedDocuments;
        }
        return $this;
    }
}
