<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenderDocumentsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RenderDocumentsRequest
 * @subpackage Structs
 */
class RenderDocumentsRequest extends AbstractStructBase
{
    /**
     * The CommonDataEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfRenderedDocumentDataEntity
     */
    public $CommonDataEntities;
    /**
     * The DefaultRenderingFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultRenderingFormat;
    /**
     * The DocumentsToRender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfRenderSingleDocumentRequest
     */
    public $DocumentsToRender;
    /**
     * Constructor method for RenderDocumentsRequest
     * @uses RenderDocumentsRequest::setCommonDataEntities()
     * @uses RenderDocumentsRequest::setDefaultRenderingFormat()
     * @uses RenderDocumentsRequest::setDocumentsToRender()
     * @param \patest\ArrayType\ArrayOfRenderedDocumentDataEntity $commonDataEntities
     * @param string $defaultRenderingFormat
     * @param \patest\ArrayType\ArrayOfRenderSingleDocumentRequest $documentsToRender
     */
    public function __construct(\patest\ArrayType\ArrayOfRenderedDocumentDataEntity $commonDataEntities = null, $defaultRenderingFormat = null, \patest\ArrayType\ArrayOfRenderSingleDocumentRequest $documentsToRender = null)
    {
        $this
            ->setCommonDataEntities($commonDataEntities)
            ->setDefaultRenderingFormat($defaultRenderingFormat)
            ->setDocumentsToRender($documentsToRender);
    }
    /**
     * Get CommonDataEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfRenderedDocumentDataEntity|null
     */
    public function getCommonDataEntities()
    {
        return isset($this->CommonDataEntities) ? $this->CommonDataEntities : null;
    }
    /**
     * Set CommonDataEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfRenderedDocumentDataEntity $commonDataEntities
     * @return \patest\StructType\RenderDocumentsRequest
     */
    public function setCommonDataEntities(\patest\ArrayType\ArrayOfRenderedDocumentDataEntity $commonDataEntities = null)
    {
        if (is_null($commonDataEntities) || (is_array($commonDataEntities) && empty($commonDataEntities))) {
            unset($this->CommonDataEntities);
        } else {
            $this->CommonDataEntities = $commonDataEntities;
        }
        return $this;
    }
    /**
     * Get DefaultRenderingFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultRenderingFormat()
    {
        return isset($this->DefaultRenderingFormat) ? $this->DefaultRenderingFormat : null;
    }
    /**
     * Set DefaultRenderingFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultRenderingFormat
     * @return \patest\StructType\RenderDocumentsRequest
     */
    public function setDefaultRenderingFormat($defaultRenderingFormat = null)
    {
        // validation for constraint: string
        if (!is_null($defaultRenderingFormat) && !is_string($defaultRenderingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultRenderingFormat, true), gettype($defaultRenderingFormat)), __LINE__);
        }
        if (is_null($defaultRenderingFormat) || (is_array($defaultRenderingFormat) && empty($defaultRenderingFormat))) {
            unset($this->DefaultRenderingFormat);
        } else {
            $this->DefaultRenderingFormat = $defaultRenderingFormat;
        }
        return $this;
    }
    /**
     * Get DocumentsToRender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfRenderSingleDocumentRequest|null
     */
    public function getDocumentsToRender()
    {
        return isset($this->DocumentsToRender) ? $this->DocumentsToRender : null;
    }
    /**
     * Set DocumentsToRender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfRenderSingleDocumentRequest $documentsToRender
     * @return \patest\StructType\RenderDocumentsRequest
     */
    public function setDocumentsToRender(\patest\ArrayType\ArrayOfRenderSingleDocumentRequest $documentsToRender = null)
    {
        if (is_null($documentsToRender) || (is_array($documentsToRender) && empty($documentsToRender))) {
            unset($this->DocumentsToRender);
        } else {
            $this->DocumentsToRender = $documentsToRender;
        }
        return $this;
    }
}
