<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelocateSubscriptions-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RelocateSubscriptions-Request
 * @subpackage Structs
 */
class RelocateSubscriptions_Request extends ExtensibleDataContract
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The NewSeatsDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfRelocationSeatDetails
     */
    public $NewSeatsDetails;
    /**
     * The OriginalSubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $OriginalSubscriptionInstanceIds;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for RelocateSubscriptions-Request
     * @uses RelocateSubscriptions_Request::setClientId()
     * @uses RelocateSubscriptions_Request::setNewSeatsDetails()
     * @uses RelocateSubscriptions_Request::setOriginalSubscriptionInstanceIds()
     * @uses RelocateSubscriptions_Request::setTransactionGuid()
     * @uses RelocateSubscriptions_Request::setTransactionSnapshotType()
     * @param string $clientId
     * @param \patest\ArrayType\ArrayOfRelocationSeatDetails $newSeatsDetails
     * @param \patest\ArrayType\ArrayOfguid $originalSubscriptionInstanceIds
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($clientId = null, \patest\ArrayType\ArrayOfRelocationSeatDetails $newSeatsDetails = null, \patest\ArrayType\ArrayOfguid $originalSubscriptionInstanceIds = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setClientId($clientId)
            ->setNewSeatsDetails($newSeatsDetails)
            ->setOriginalSubscriptionInstanceIds($originalSubscriptionInstanceIds)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\RelocateSubscriptions_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get NewSeatsDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfRelocationSeatDetails|null
     */
    public function getNewSeatsDetails()
    {
        return isset($this->NewSeatsDetails) ? $this->NewSeatsDetails : null;
    }
    /**
     * Set NewSeatsDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfRelocationSeatDetails $newSeatsDetails
     * @return \patest\StructType\RelocateSubscriptions_Request
     */
    public function setNewSeatsDetails(\patest\ArrayType\ArrayOfRelocationSeatDetails $newSeatsDetails = null)
    {
        if (is_null($newSeatsDetails) || (is_array($newSeatsDetails) && empty($newSeatsDetails))) {
            unset($this->NewSeatsDetails);
        } else {
            $this->NewSeatsDetails = $newSeatsDetails;
        }
        return $this;
    }
    /**
     * Get OriginalSubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getOriginalSubscriptionInstanceIds()
    {
        return isset($this->OriginalSubscriptionInstanceIds) ? $this->OriginalSubscriptionInstanceIds : null;
    }
    /**
     * Set OriginalSubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $originalSubscriptionInstanceIds
     * @return \patest\StructType\RelocateSubscriptions_Request
     */
    public function setOriginalSubscriptionInstanceIds(\patest\ArrayType\ArrayOfguid $originalSubscriptionInstanceIds = null)
    {
        if (is_null($originalSubscriptionInstanceIds) || (is_array($originalSubscriptionInstanceIds) && empty($originalSubscriptionInstanceIds))) {
            unset($this->OriginalSubscriptionInstanceIds);
        } else {
            $this->OriginalSubscriptionInstanceIds = $originalSubscriptionInstanceIds;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\RelocateSubscriptions_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\RelocateSubscriptions_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
