<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundOptionDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RefundOptionDescription
 * @subpackage Structs
 */
class RefundOptionDescription extends AbstractStructBase
{
    /**
     * The ExpectedResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpectedResult;
    /**
     * The IsAlreadyInBasket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAlreadyInBasket;
    /**
     * The IsMandatory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMandatory;
    /**
     * The IsUserInteractionNeeded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsUserInteractionNeeded;
    /**
     * The OriginalPaymentItemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalPaymentItemDescription;
    /**
     * The OriginalPaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalPaymentItemId;
    /**
     * The OriginalPaymentItemIdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginalPaymentItemIdInTransaction;
    /**
     * The OriginalPaymentItemStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalPaymentItemStatus;
    /**
     * The OriginalPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalPaymentMethodId;
    /**
     * The OriginalTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTransactionGuid;
    /**
     * The OriginalTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalTransactionNumber;
    /**
     * The PaymentDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAbstractPaymentDescription
     */
    public $PaymentDescriptions;
    /**
     * The RefundAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $RefundAmount;
    /**
     * The RefundAmountReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RefundAmountReferenceId;
    /**
     * The ReturnedProductsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReturnedProductsCount;
    /**
     * The ReturnedProductsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnedProductsDescription;
    /**
     * Constructor method for RefundOptionDescription
     * @uses RefundOptionDescription::setExpectedResult()
     * @uses RefundOptionDescription::setIsAlreadyInBasket()
     * @uses RefundOptionDescription::setIsMandatory()
     * @uses RefundOptionDescription::setIsUserInteractionNeeded()
     * @uses RefundOptionDescription::setOriginalPaymentItemDescription()
     * @uses RefundOptionDescription::setOriginalPaymentItemId()
     * @uses RefundOptionDescription::setOriginalPaymentItemIdInTransaction()
     * @uses RefundOptionDescription::setOriginalPaymentItemStatus()
     * @uses RefundOptionDescription::setOriginalPaymentMethodId()
     * @uses RefundOptionDescription::setOriginalTransactionGuid()
     * @uses RefundOptionDescription::setOriginalTransactionNumber()
     * @uses RefundOptionDescription::setPaymentDescriptions()
     * @uses RefundOptionDescription::setRefundAmount()
     * @uses RefundOptionDescription::setRefundAmountReferenceId()
     * @uses RefundOptionDescription::setReturnedProductsCount()
     * @uses RefundOptionDescription::setReturnedProductsDescription()
     * @param string $expectedResult
     * @param bool $isAlreadyInBasket
     * @param bool $isMandatory
     * @param bool $isUserInteractionNeeded
     * @param string $originalPaymentItemDescription
     * @param string $originalPaymentItemId
     * @param int $originalPaymentItemIdInTransaction
     * @param string $originalPaymentItemStatus
     * @param string $originalPaymentMethodId
     * @param string $originalTransactionGuid
     * @param string $originalTransactionNumber
     * @param \patest\ArrayType\ArrayOfAbstractPaymentDescription $paymentDescriptions
     * @param \patest\StructType\Money $refundAmount
     * @param string $refundAmountReferenceId
     * @param int $returnedProductsCount
     * @param string $returnedProductsDescription
     */
    public function __construct($expectedResult = null, $isAlreadyInBasket = null, $isMandatory = null, $isUserInteractionNeeded = null, $originalPaymentItemDescription = null, $originalPaymentItemId = null, $originalPaymentItemIdInTransaction = null, $originalPaymentItemStatus = null, $originalPaymentMethodId = null, $originalTransactionGuid = null, $originalTransactionNumber = null, \patest\ArrayType\ArrayOfAbstractPaymentDescription $paymentDescriptions = null, \patest\StructType\Money $refundAmount = null, $refundAmountReferenceId = null, $returnedProductsCount = null, $returnedProductsDescription = null)
    {
        $this
            ->setExpectedResult($expectedResult)
            ->setIsAlreadyInBasket($isAlreadyInBasket)
            ->setIsMandatory($isMandatory)
            ->setIsUserInteractionNeeded($isUserInteractionNeeded)
            ->setOriginalPaymentItemDescription($originalPaymentItemDescription)
            ->setOriginalPaymentItemId($originalPaymentItemId)
            ->setOriginalPaymentItemIdInTransaction($originalPaymentItemIdInTransaction)
            ->setOriginalPaymentItemStatus($originalPaymentItemStatus)
            ->setOriginalPaymentMethodId($originalPaymentMethodId)
            ->setOriginalTransactionGuid($originalTransactionGuid)
            ->setOriginalTransactionNumber($originalTransactionNumber)
            ->setPaymentDescriptions($paymentDescriptions)
            ->setRefundAmount($refundAmount)
            ->setRefundAmountReferenceId($refundAmountReferenceId)
            ->setReturnedProductsCount($returnedProductsCount)
            ->setReturnedProductsDescription($returnedProductsDescription);
    }
    /**
     * Get ExpectedResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpectedResult()
    {
        return isset($this->ExpectedResult) ? $this->ExpectedResult : null;
    }
    /**
     * Set ExpectedResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expectedResult
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setExpectedResult($expectedResult = null)
    {
        // validation for constraint: string
        if (!is_null($expectedResult) && !is_string($expectedResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedResult, true), gettype($expectedResult)), __LINE__);
        }
        if (is_null($expectedResult) || (is_array($expectedResult) && empty($expectedResult))) {
            unset($this->ExpectedResult);
        } else {
            $this->ExpectedResult = $expectedResult;
        }
        return $this;
    }
    /**
     * Get IsAlreadyInBasket value
     * @return bool|null
     */
    public function getIsAlreadyInBasket()
    {
        return $this->IsAlreadyInBasket;
    }
    /**
     * Set IsAlreadyInBasket value
     * @param bool $isAlreadyInBasket
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setIsAlreadyInBasket($isAlreadyInBasket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlreadyInBasket) && !is_bool($isAlreadyInBasket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlreadyInBasket, true), gettype($isAlreadyInBasket)), __LINE__);
        }
        $this->IsAlreadyInBasket = $isAlreadyInBasket;
        return $this;
    }
    /**
     * Get IsMandatory value
     * @return bool|null
     */
    public function getIsMandatory()
    {
        return $this->IsMandatory;
    }
    /**
     * Set IsMandatory value
     * @param bool $isMandatory
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setIsMandatory($isMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMandatory) && !is_bool($isMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMandatory, true), gettype($isMandatory)), __LINE__);
        }
        $this->IsMandatory = $isMandatory;
        return $this;
    }
    /**
     * Get IsUserInteractionNeeded value
     * @return bool|null
     */
    public function getIsUserInteractionNeeded()
    {
        return $this->IsUserInteractionNeeded;
    }
    /**
     * Set IsUserInteractionNeeded value
     * @param bool $isUserInteractionNeeded
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setIsUserInteractionNeeded($isUserInteractionNeeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUserInteractionNeeded) && !is_bool($isUserInteractionNeeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUserInteractionNeeded, true), gettype($isUserInteractionNeeded)), __LINE__);
        }
        $this->IsUserInteractionNeeded = $isUserInteractionNeeded;
        return $this;
    }
    /**
     * Get OriginalPaymentItemDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPaymentItemDescription()
    {
        return isset($this->OriginalPaymentItemDescription) ? $this->OriginalPaymentItemDescription : null;
    }
    /**
     * Set OriginalPaymentItemDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPaymentItemDescription
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setOriginalPaymentItemDescription($originalPaymentItemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentItemDescription) && !is_string($originalPaymentItemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentItemDescription, true), gettype($originalPaymentItemDescription)), __LINE__);
        }
        if (is_null($originalPaymentItemDescription) || (is_array($originalPaymentItemDescription) && empty($originalPaymentItemDescription))) {
            unset($this->OriginalPaymentItemDescription);
        } else {
            $this->OriginalPaymentItemDescription = $originalPaymentItemDescription;
        }
        return $this;
    }
    /**
     * Get OriginalPaymentItemId value
     * @return string|null
     */
    public function getOriginalPaymentItemId()
    {
        return $this->OriginalPaymentItemId;
    }
    /**
     * Set OriginalPaymentItemId value
     * @param string $originalPaymentItemId
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setOriginalPaymentItemId($originalPaymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentItemId) && !is_string($originalPaymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentItemId, true), gettype($originalPaymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalPaymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalPaymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalPaymentItemId, true)), __LINE__);
        }
        $this->OriginalPaymentItemId = $originalPaymentItemId;
        return $this;
    }
    /**
     * Get OriginalPaymentItemIdInTransaction value
     * @return int|null
     */
    public function getOriginalPaymentItemIdInTransaction()
    {
        return $this->OriginalPaymentItemIdInTransaction;
    }
    /**
     * Set OriginalPaymentItemIdInTransaction value
     * @param int $originalPaymentItemIdInTransaction
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setOriginalPaymentItemIdInTransaction($originalPaymentItemIdInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($originalPaymentItemIdInTransaction) && !(is_int($originalPaymentItemIdInTransaction) || ctype_digit($originalPaymentItemIdInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalPaymentItemIdInTransaction, true), gettype($originalPaymentItemIdInTransaction)), __LINE__);
        }
        $this->OriginalPaymentItemIdInTransaction = $originalPaymentItemIdInTransaction;
        return $this;
    }
    /**
     * Get OriginalPaymentItemStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPaymentItemStatus()
    {
        return isset($this->OriginalPaymentItemStatus) ? $this->OriginalPaymentItemStatus : null;
    }
    /**
     * Set OriginalPaymentItemStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPaymentItemStatus
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setOriginalPaymentItemStatus($originalPaymentItemStatus = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentItemStatus) && !is_string($originalPaymentItemStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentItemStatus, true), gettype($originalPaymentItemStatus)), __LINE__);
        }
        if (is_null($originalPaymentItemStatus) || (is_array($originalPaymentItemStatus) && empty($originalPaymentItemStatus))) {
            unset($this->OriginalPaymentItemStatus);
        } else {
            $this->OriginalPaymentItemStatus = $originalPaymentItemStatus;
        }
        return $this;
    }
    /**
     * Get OriginalPaymentMethodId value
     * @return string|null
     */
    public function getOriginalPaymentMethodId()
    {
        return $this->OriginalPaymentMethodId;
    }
    /**
     * Set OriginalPaymentMethodId value
     * @param string $originalPaymentMethodId
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setOriginalPaymentMethodId($originalPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentMethodId) && !is_string($originalPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentMethodId, true), gettype($originalPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalPaymentMethodId, true)), __LINE__);
        }
        $this->OriginalPaymentMethodId = $originalPaymentMethodId;
        return $this;
    }
    /**
     * Get OriginalTransactionGuid value
     * @return string|null
     */
    public function getOriginalTransactionGuid()
    {
        return $this->OriginalTransactionGuid;
    }
    /**
     * Set OriginalTransactionGuid value
     * @param string $originalTransactionGuid
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setOriginalTransactionGuid($originalTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($originalTransactionGuid) && !is_string($originalTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTransactionGuid, true), gettype($originalTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTransactionGuid, true)), __LINE__);
        }
        $this->OriginalTransactionGuid = $originalTransactionGuid;
        return $this;
    }
    /**
     * Get OriginalTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTransactionNumber()
    {
        return isset($this->OriginalTransactionNumber) ? $this->OriginalTransactionNumber : null;
    }
    /**
     * Set OriginalTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTransactionNumber
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setOriginalTransactionNumber($originalTransactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($originalTransactionNumber) && !is_string($originalTransactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTransactionNumber, true), gettype($originalTransactionNumber)), __LINE__);
        }
        if (is_null($originalTransactionNumber) || (is_array($originalTransactionNumber) && empty($originalTransactionNumber))) {
            unset($this->OriginalTransactionNumber);
        } else {
            $this->OriginalTransactionNumber = $originalTransactionNumber;
        }
        return $this;
    }
    /**
     * Get PaymentDescriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAbstractPaymentDescription|null
     */
    public function getPaymentDescriptions()
    {
        return isset($this->PaymentDescriptions) ? $this->PaymentDescriptions : null;
    }
    /**
     * Set PaymentDescriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAbstractPaymentDescription $paymentDescriptions
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setPaymentDescriptions(\patest\ArrayType\ArrayOfAbstractPaymentDescription $paymentDescriptions = null)
    {
        if (is_null($paymentDescriptions) || (is_array($paymentDescriptions) && empty($paymentDescriptions))) {
            unset($this->PaymentDescriptions);
        } else {
            $this->PaymentDescriptions = $paymentDescriptions;
        }
        return $this;
    }
    /**
     * Get RefundAmount value
     * @return \patest\StructType\Money|null
     */
    public function getRefundAmount()
    {
        return $this->RefundAmount;
    }
    /**
     * Set RefundAmount value
     * @param \patest\StructType\Money $refundAmount
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setRefundAmount(\patest\StructType\Money $refundAmount = null)
    {
        $this->RefundAmount = $refundAmount;
        return $this;
    }
    /**
     * Get RefundAmountReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundAmountReferenceId()
    {
        return isset($this->RefundAmountReferenceId) ? $this->RefundAmountReferenceId : null;
    }
    /**
     * Set RefundAmountReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundAmountReferenceId
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setRefundAmountReferenceId($refundAmountReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($refundAmountReferenceId) && !is_string($refundAmountReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundAmountReferenceId, true), gettype($refundAmountReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($refundAmountReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $refundAmountReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($refundAmountReferenceId, true)), __LINE__);
        }
        if (is_null($refundAmountReferenceId) || (is_array($refundAmountReferenceId) && empty($refundAmountReferenceId))) {
            unset($this->RefundAmountReferenceId);
        } else {
            $this->RefundAmountReferenceId = $refundAmountReferenceId;
        }
        return $this;
    }
    /**
     * Get ReturnedProductsCount value
     * @return int|null
     */
    public function getReturnedProductsCount()
    {
        return $this->ReturnedProductsCount;
    }
    /**
     * Set ReturnedProductsCount value
     * @param int $returnedProductsCount
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setReturnedProductsCount($returnedProductsCount = null)
    {
        // validation for constraint: int
        if (!is_null($returnedProductsCount) && !(is_int($returnedProductsCount) || ctype_digit($returnedProductsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnedProductsCount, true), gettype($returnedProductsCount)), __LINE__);
        }
        $this->ReturnedProductsCount = $returnedProductsCount;
        return $this;
    }
    /**
     * Get ReturnedProductsDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnedProductsDescription()
    {
        return isset($this->ReturnedProductsDescription) ? $this->ReturnedProductsDescription : null;
    }
    /**
     * Set ReturnedProductsDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnedProductsDescription
     * @return \patest\StructType\RefundOptionDescription
     */
    public function setReturnedProductsDescription($returnedProductsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($returnedProductsDescription) && !is_string($returnedProductsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnedProductsDescription, true), gettype($returnedProductsDescription)), __LINE__);
        }
        if (is_null($returnedProductsDescription) || (is_array($returnedProductsDescription) && empty($returnedProductsDescription))) {
            unset($this->ReturnedProductsDescription);
        } else {
            $this->ReturnedProductsDescription = $returnedProductsDescription;
        }
        return $this;
    }
}
