<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordSetOfCrm.AccountType StructType
 * @subpackage Structs
 */
class RecordSetOfCrm_AccountType extends AbstractStructBase
{
    /**
     * The Record
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_AccountType[]
     */
    public $Record;
    /**
     * Constructor method for RecordSetOfCrm.AccountType
     * @uses RecordSetOfCrm_AccountType::setRecord()
     * @param \patest\StructType\Crm_AccountType[] $record
     */
    public function __construct(array $record = array())
    {
        $this
            ->setRecord($record);
    }
    /**
     * Get Record value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_AccountType[]|null
     */
    public function getRecord()
    {
        return isset($this->Record) ? $this->Record : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecordForArrayConstraintsFromSetRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recordSetOfCrm_AccountTypeRecordItem) {
            // validation for constraint: itemType
            if (!$recordSetOfCrm_AccountTypeRecordItem instanceof \patest\StructType\Crm_AccountType) {
                $invalidValues[] = is_object($recordSetOfCrm_AccountTypeRecordItem) ? get_class($recordSetOfCrm_AccountTypeRecordItem) : sprintf('%s(%s)', gettype($recordSetOfCrm_AccountTypeRecordItem), var_export($recordSetOfCrm_AccountTypeRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Record property can only contain items of type \patest\StructType\Crm_AccountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Record value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\Crm_AccountType[] $record
     * @return \patest\StructType\RecordSetOfCrm_AccountType
     */
    public function setRecord(array $record = array())
    {
        // validation for constraint: array
        if ('' !== ($recordArrayErrorMessage = self::validateRecordForArrayConstraintsFromSetRecord($record))) {
            throw new \InvalidArgumentException($recordArrayErrorMessage, __LINE__);
        }
        if (is_null($record) || (is_array($record) && empty($record))) {
            unset($this->Record);
        } else {
            $this->Record = $record;
        }
        return $this;
    }
    /**
     * Add item to Record value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\Crm_AccountType $item
     * @return \patest\StructType\RecordSetOfCrm_AccountType
     */
    public function addToRecord(\patest\StructType\Crm_AccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\Crm_AccountType) {
            throw new \InvalidArgumentException(sprintf('The Record property can only contain items of type \patest\StructType\Crm_AccountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Record[] = $item;
        return $this;
    }
}
