<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReLockOrAllocateTickets-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReLockOrAllocateTickets-Request
 * @subpackage Structs
 */
class ReLockOrAllocateTickets_Request extends ExtensibleDataContract
{
    /**
     * The NewRestrictionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewRestrictionId;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketItem
     */
    public $Tickets;
    /**
     * Constructor method for ReLockOrAllocateTickets-Request
     * @uses ReLockOrAllocateTickets_Request::setNewRestrictionId()
     * @uses ReLockOrAllocateTickets_Request::setTickets()
     * @param string $newRestrictionId
     * @param \patest\ArrayType\ArrayOfTicketItem $tickets
     */
    public function __construct($newRestrictionId = null, \patest\ArrayType\ArrayOfTicketItem $tickets = null)
    {
        $this
            ->setNewRestrictionId($newRestrictionId)
            ->setTickets($tickets);
    }
    /**
     * Get NewRestrictionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewRestrictionId()
    {
        return isset($this->NewRestrictionId) ? $this->NewRestrictionId : null;
    }
    /**
     * Set NewRestrictionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newRestrictionId
     * @return \patest\StructType\ReLockOrAllocateTickets_Request
     */
    public function setNewRestrictionId($newRestrictionId = null)
    {
        // validation for constraint: string
        if (!is_null($newRestrictionId) && !is_string($newRestrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newRestrictionId, true), gettype($newRestrictionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newRestrictionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newRestrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newRestrictionId, true)), __LINE__);
        }
        if (is_null($newRestrictionId) || (is_array($newRestrictionId) && empty($newRestrictionId))) {
            unset($this->NewRestrictionId);
        } else {
            $this->NewRestrictionId = $newRestrictionId;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketItem|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketItem $tickets
     * @return \patest\StructType\ReLockOrAllocateTickets_Request
     */
    public function setTickets(\patest\ArrayType\ArrayOfTicketItem $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
}
