<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryUniversalFlagResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryUniversalFlagResponse
 * @subpackage Structs
 */
class QueryUniversalFlagResponse extends ExtensibleDataContract
{
    /**
     * The FlagValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlagValue;
    /**
     * Constructor method for QueryUniversalFlagResponse
     * @uses QueryUniversalFlagResponse::setFlagValue()
     * @param string $flagValue
     */
    public function __construct($flagValue = null)
    {
        $this
            ->setFlagValue($flagValue);
    }
    /**
     * Get FlagValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlagValue()
    {
        return isset($this->FlagValue) ? $this->FlagValue : null;
    }
    /**
     * Set FlagValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flagValue
     * @return \patest\StructType\QueryUniversalFlagResponse
     */
    public function setFlagValue($flagValue = null)
    {
        // validation for constraint: string
        if (!is_null($flagValue) && !is_string($flagValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flagValue, true), gettype($flagValue)), __LINE__);
        }
        if (is_null($flagValue) || (is_array($flagValue) && empty($flagValue))) {
            unset($this->FlagValue);
        } else {
            $this->FlagValue = $flagValue;
        }
        return $this;
    }
}
